/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.constraint.Assert;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.jar.JarFile;
import org.qbicc.driver.DirectoryClassPathElement;
import org.qbicc.driver.JarFileClassPathElement;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;
import org.qbicc.type.definition.ByteBufferInputStream;

public abstract class ClassPathElement
implements Closeable {
    static final Resource NON_EXISTENT = new Resource(){
        static final ByteBuffer EMPTY = ByteBuffer.allocate(0);

        @Override
        public ByteBuffer getBuffer() {
            return EMPTY;
        }

        @Override
        public InputStream openStream() {
            return InputStream.nullInputStream();
        }

        @Override
        public void close() {
        }
    };

    ClassPathElement() {
    }

    public abstract String getName();

    public abstract Resource getResource(String var1) throws IOException;

    public abstract void mount(VirtualFileSystem var1, VirtualPath var2) throws IOException;

    public static ClassPathElement forDirectory(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        return new DirectoryClassPathElement(path);
    }

    public static ClassPathElement forJarFile(Path path, Runtime.Version version) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)path);
        return new JarFileClassPathElement(new JarFile(path.toFile(), true, 1, version));
    }

    public static ClassPathElement forJarFile(File file, Runtime.Version version) throws IOException {
        Assert.checkNotNullParam((String)"path", (Object)file);
        return ClassPathElement.forJarFile(file.toPath(), version);
    }

    public static abstract class Resource
    implements Closeable {
        Resource() {
        }

        public abstract ByteBuffer getBuffer() throws IOException;

        public InputStream openStream() throws IOException {
            return new ByteBufferInputStream(this.getBuffer());
        }

        public final BufferedReader openBufferedReader() throws IOException {
            return new BufferedReader(new InputStreamReader(this.openStream(), StandardCharsets.UTF_8));
        }
    }
}

