/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.constraint.Assert;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.ListIterator;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

public record ClassPathItem(String name, List<ClassPathElement> classRoots, List<ClassPathElement> sourceRoots) implements Closeable
{
    public ClassPathItem {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"classRoots", classRoots);
        Assert.checkNotNullParam((String)"sourceRoots", sourceRoots);
    }

    public void mount(VirtualFileSystem vfs, VirtualPath mountPoint) throws IOException {
        ListIterator<ClassPathElement> iterator = this.classRoots.listIterator(this.classRoots.size());
        while (iterator.hasPrevious()) {
            iterator.previous().mount(vfs, mountPoint);
        }
    }

    public ClassPathElement.Resource findResource(String name) throws IOException {
        Assert.checkNotNullParam((String)"name", (Object)name);
        for (ClassPathElement classRoot : this.classRoots) {
            ClassPathElement.Resource resource = classRoot.getResource(name);
            if (resource == ClassPathElement.NON_EXISTENT) continue;
            return resource;
        }
        return ClassPathElement.NON_EXISTENT;
    }

    public ClassPathElement.Resource findSourceFile(String packagePath, String className, String fileName) throws IOException {
        Assert.checkNotNullParam((String)"packagePath", (Object)packagePath);
        Assert.checkNotNullParam((String)"className", (Object)className);
        Assert.checkNotNullParam((String)"fileName", (Object)fileName);
        for (ClassPathElement sourceRoot : this.sourceRoots) {
            Object name;
            ClassPathElement.Resource resource;
            if (!packagePath.isEmpty() && (resource = sourceRoot.getResource((String)(name = packagePath + "/" + fileName))) != ClassPathElement.NON_EXISTENT) {
                return resource;
            }
            name = fileName;
            resource = sourceRoot.getResource((String)name);
            if (resource == ClassPathElement.NON_EXISTENT) continue;
            return resource;
        }
        return ClassPathElement.NON_EXISTENT;
    }

    @Override
    public void close() {
        for (List<ClassPathElement> rootList : List.of(this.classRoots, this.sourceRoots)) {
            for (ClassPathElement classRoot : rootList) {
                try {
                    classRoot.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

