/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.constraint.Assert;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Diagnostic;
import org.qbicc.context.Locatable;
import org.qbicc.context.Location;
import org.qbicc.context.PhaseAttachmentKey;
import org.qbicc.driver.BaseDiagnosticContext;
import org.qbicc.driver.ClassContextImpl;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.schedule.Scheduler;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClassLoader;
import org.qbicc.machine.arch.Platform;
import org.qbicc.object.Function;
import org.qbicc.object.ModuleSection;
import org.qbicc.object.ProgramModule;
import org.qbicc.object.Section;
import org.qbicc.object.Segment;
import org.qbicc.type.ClassObjectType;
import org.qbicc.type.FunctionType;
import org.qbicc.type.InstanceMethodType;
import org.qbicc.type.InvokableType;
import org.qbicc.type.MethodType;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.ValueType;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.definition.MethodTypeId;
import org.qbicc.type.definition.NativeMethodConfigurator;
import org.qbicc.type.definition.TypeId;
import org.qbicc.type.definition.element.ConstructorElement;
import org.qbicc.type.definition.element.Element;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.FieldElement;
import org.qbicc.type.definition.element.FunctionElement;
import org.qbicc.type.definition.element.InitializerElement;
import org.qbicc.type.definition.element.MemberElement;
import org.qbicc.type.definition.element.MethodElement;
import org.qbicc.type.descriptor.ClassTypeDescriptor;
import org.qbicc.type.descriptor.MethodDescriptor;
import org.qbicc.type.descriptor.TypeDescriptor;
import org.qbicc.type.generic.ClassSignature;
import org.qbicc.type.generic.Signature;

final class CompilationContextImpl
implements CompilationContext {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.driver");
    private final Platform platform;
    private final TypeSystem typeSystem;
    private final LiteralFactory literalFactory;
    private final BaseDiagnosticContext baseDiagnosticContext;
    private final ConcurrentMap<VmClassLoader, ClassContext> classLoaderContexts = new ConcurrentHashMap<VmClassLoader, ClassContext>();
    final Queue<Object> queue = new ArrayDeque<Object>();
    final Set<ExecutableElement> entryPoints = ConcurrentHashMap.newKeySet();
    final ClassContext bootstrapClassContext;
    final java.util.function.Function<VmClassLoader, ClassContext> platformClassContextFactory;
    final java.util.function.Function<VmClassLoader, ClassContext> appClassContextFactory;
    private final ConcurrentMap<DefinedTypeDefinition, ProgramModule> programModules = new ConcurrentHashMap<DefinedTypeDefinition, ProgramModule>();
    private final ConcurrentMap<ExecutableElement, Function> exactFunctions = new ConcurrentHashMap<ExecutableElement, Function>();
    private final ConcurrentMap<ExecutableElement, FunctionElement> establishedFunctions = new ConcurrentHashMap<ExecutableElement, FunctionElement>();
    private final ConcurrentMap<TypeId, ConcurrentMap<List<TypeId>, MethodTypeId>> methodTypes = new ConcurrentHashMap<TypeId, ConcurrentMap<List<TypeId>, MethodTypeId>>();
    private final Path outputDir;
    final List<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>> resolverFactories;
    private volatile DefinedTypeDefinition defaultTypeDefinition;
    private final List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> typeBuilderFactories;
    private volatile BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> blockFactory;
    private volatile BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> copier;
    private final Vm vm;
    private final NativeMethodConfigurator nativeMethodConfigurator;
    private final Consumer<ClassContext> classContextListener;
    private final Section implicitSection;
    private final Scheduler scheduler;
    static final Base64.Encoder ENCODER = Base64.getUrlEncoder().withoutPadding();
    private static final char[] hexDigits = "0123456789abcdef".toCharArray();
    private int state;
    private int activeThreads;
    private int threadAcks;
    private Consumer<CompilationContext> task;
    private volatile BiConsumer<Consumer<CompilationContext>, CompilationContext> taskRunner = Consumer::accept;
    private static final int ST_WAITING = 0;
    private static final int ST_TASK = 1;
    private static final int ST_JOIN = 2;
    private static final int ST_EXIT = 3;
    private final Runnable threadTask = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            CompilationContextImpl lock;
            CompilationContextImpl compilationContextImpl = lock = CompilationContextImpl.this;
            synchronized (compilationContextImpl) {
                ++CompilationContextImpl.this.activeThreads;
            }
            boolean needsJoin = false;
            while (true) {
                Consumer<CompilationContext> task;
                int state;
                CompilationContextImpl compilationContextImpl2 = lock;
                synchronized (compilationContextImpl2) {
                    block21: while (true) {
                        state = CompilationContextImpl.this.state;
                        switch (state) {
                            case 0: {
                                try {
                                    lock.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                continue block21;
                            }
                            case 1: {
                                if (needsJoin) {
                                    try {
                                        lock.wait();
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    continue block21;
                                }
                                needsJoin = true;
                                task = CompilationContextImpl.this.task;
                                if (++CompilationContextImpl.this.threadAcks != CompilationContextImpl.this.activeThreads) break block21;
                                lock.notifyAll();
                                break block21;
                            }
                            case 2: {
                                needsJoin = false;
                                if (++CompilationContextImpl.this.threadAcks == CompilationContextImpl.this.activeThreads) {
                                    lock.notifyAll();
                                }
                                try {
                                    lock.wait();
                                }
                                catch (InterruptedException interruptedException) {}
                                continue block21;
                            }
                            case 3: {
                                if (--CompilationContextImpl.this.activeThreads == 0) {
                                    lock.notifyAll();
                                }
                                return;
                            }
                            default: {
                                throw Assert.impossibleSwitchCase((int)state);
                            }
                        }
                        break;
                    }
                }
                assert (state == 1);
                try {
                    CompilationContextImpl.this.taskRunner.accept(task, lock);
                    continue;
                }
                catch (Throwable t) {
                    log.error((Object)"An exception was thrown from a parallel task", t);
                    CompilationContextImpl.this.error(t, "A task threw an uncaught exception: %s", new Object[]{t});
                    continue;
                }
                break;
            }
        }
    };
    int waiting;

    CompilationContextImpl(Builder builder) {
        this.baseDiagnosticContext = builder.baseDiagnosticContext;
        this.platform = builder.platform;
        this.typeSystem = builder.typeSystem;
        this.literalFactory = builder.literalFactory;
        this.scheduler = builder.scheduler;
        this.outputDir = builder.outputDir;
        this.resolverFactories = builder.resolverFactories;
        this.classContextListener = builder.classContextListener;
        this.bootstrapClassContext = new ClassContextImpl(this, null, builder.bootstrapFinder, builder.bootstrapResourceFinder, builder.bootstrapResourcesFinder);
        this.appClassContextFactory = cl -> new ClassContextImpl(this, (VmClassLoader)cl, builder.appFinder, builder.appResourceFinder, builder.appResourcesFinder);
        this.platformClassContextFactory = cl -> new ClassContextImpl(this, (VmClassLoader)cl, builder.platformFinder, builder.platformResourceFinder, builder.platformResourcesFinder);
        this.typeBuilderFactories = builder.typeBuilderFactories;
        this.nativeMethodConfigurator = builder.nativeMethodConfigurator;
        this.implicitSection = Section.defineSection((CompilationContext)this, (int)0, (String)"__implicit__", (Segment)Segment.DATA, (Section.Attribute[])new Section.Attribute[0]);
        this.handleNewClassContext(this.bootstrapClassContext);
        this.vm = builder.vmFactory.apply(this);
    }

    public <T> T getAttachment(AttachmentKey<T> key) {
        return this.baseDiagnosticContext.getAttachment(key);
    }

    public <T> T getAttachmentOrDefault(AttachmentKey<T> key, T defVal) {
        return this.baseDiagnosticContext.getAttachmentOrDefault(key, defVal);
    }

    public <T> T putAttachment(AttachmentKey<T> key, T value) {
        return this.baseDiagnosticContext.putAttachment(key, value);
    }

    public <T> T putAttachmentIfAbsent(AttachmentKey<T> key, T value) {
        return this.baseDiagnosticContext.putAttachmentIfAbsent(key, value);
    }

    public <T> T removeAttachment(AttachmentKey<T> key) {
        return this.baseDiagnosticContext.removeAttachment(key);
    }

    public <T> boolean removeAttachment(AttachmentKey<T> key, T expect) {
        return this.baseDiagnosticContext.removeAttachment(key, expect);
    }

    public <T> T replaceAttachment(AttachmentKey<T> key, T update) {
        return this.baseDiagnosticContext.replaceAttachment(key, update);
    }

    public <T> boolean replaceAttachment(AttachmentKey<T> key, T expect, T update) {
        return this.baseDiagnosticContext.replaceAttachment(key, expect, update);
    }

    public <T> T computeAttachmentIfAbsent(AttachmentKey<T> key, Supplier<T> function) {
        return this.baseDiagnosticContext.computeAttachmentIfAbsent(key, function);
    }

    public <T> T computeAttachmentIfPresent(AttachmentKey<T> key, java.util.function.Function<T, T> function) {
        return this.baseDiagnosticContext.computeAttachmentIfPresent(key, function);
    }

    public <T> T computeAttachment(AttachmentKey<T> key, java.util.function.Function<T, T> function) {
        return this.baseDiagnosticContext.computeAttachment(key, function);
    }

    public <T> T getAttachment(PhaseAttachmentKey<T> key) {
        return this.baseDiagnosticContext.getAttachment(key);
    }

    public <T> T getAttachmentOrDefault(PhaseAttachmentKey<T> key, T defVal) {
        return this.baseDiagnosticContext.getAttachmentOrDefault(key, defVal);
    }

    public <T> T putAttachment(PhaseAttachmentKey<T> key, T value) {
        return this.baseDiagnosticContext.putAttachment(key, value);
    }

    public <T> T putAttachmentIfAbsent(PhaseAttachmentKey<T> key, T value) {
        return this.baseDiagnosticContext.putAttachmentIfAbsent(key, value);
    }

    public <T> T removeAttachment(PhaseAttachmentKey<T> key) {
        return this.baseDiagnosticContext.removeAttachment(key);
    }

    public <T> boolean removeAttachment(PhaseAttachmentKey<T> key, T expect) {
        return this.baseDiagnosticContext.removeAttachment(key, expect);
    }

    public <T> T replaceAttachment(PhaseAttachmentKey<T> key, T update) {
        return this.baseDiagnosticContext.replaceAttachment(key, update);
    }

    public <T> boolean replaceAttachment(PhaseAttachmentKey<T> key, T expect, T update) {
        return this.baseDiagnosticContext.replaceAttachment(key, expect, update);
    }

    public <T> T computeAttachmentIfAbsent(PhaseAttachmentKey<T> key, Supplier<T> function) {
        return this.baseDiagnosticContext.computeAttachmentIfAbsent(key, function);
    }

    public <T> T computeAttachmentIfPresent(PhaseAttachmentKey<T> key, java.util.function.Function<T, T> function) {
        return this.baseDiagnosticContext.computeAttachmentIfPresent(key, function);
    }

    public <T> T computeAttachment(PhaseAttachmentKey<T> key, java.util.function.Function<T, T> function) {
        return this.baseDiagnosticContext.computeAttachment(key, function);
    }

    public void cyclePhaseAttachments() {
        this.baseDiagnosticContext.cyclePhaseAttachments();
    }

    public <T> T getPreviousPhaseAttachment(PhaseAttachmentKey<T> key) {
        return this.baseDiagnosticContext.getPreviousPhaseAttachment(key);
    }

    public int errors() {
        return this.baseDiagnosticContext.errors();
    }

    public int warnings() {
        return this.baseDiagnosticContext.warnings();
    }

    public Diagnostic msg(Diagnostic diagnostic) {
        return this.baseDiagnosticContext.msg(diagnostic);
    }

    public Diagnostic msg(Diagnostic parent, Location loc, Diagnostic.Level level, String fmt, Object ... args) {
        return this.baseDiagnosticContext.msg(parent, loc, level, fmt, args);
    }

    public Diagnostic msg(Diagnostic parent, Element element, Node node, Diagnostic.Level level, String fmt, Object ... args) {
        return this.baseDiagnosticContext.msg(parent, element, node, level, fmt, args);
    }

    public Iterable<Diagnostic> getDiagnostics() {
        return this.baseDiagnosticContext.getDiagnostics();
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public TypeSystem getTypeSystem() {
        return this.typeSystem;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public LiteralFactory getLiteralFactory() {
        return this.literalFactory;
    }

    public ClassContext getBootstrapClassContext() {
        return this.bootstrapClassContext;
    }

    public String deduplicate(ByteBuffer buffer, int offset, int length) {
        return this.baseDiagnosticContext.deduplicate(buffer, offset, length);
    }

    public String deduplicate(String original) {
        return this.baseDiagnosticContext.deduplicate(original);
    }

    public ClassContext constructClassContext(VmClassLoader classLoaderObject) {
        return this.classLoaderContexts.computeIfAbsent(classLoaderObject, classLoader -> this.handleNewClassContext(new ClassContextImpl(this, (VmClassLoader)classLoader, (arg_0, arg_1) -> ((Vm)this.vm).loadClass(arg_0, arg_1), (arg_0, arg_1) -> ((Vm)this.vm).loadResource(arg_0, arg_1), (arg_0, arg_1) -> ((Vm)this.vm).loadResources(arg_0, arg_1))));
    }

    public ClassContext constructAppClassLoaderClassContext(VmClassLoader appClassLoaderObject) {
        return this.appClassContextFactory.apply(appClassLoaderObject);
    }

    public ClassContext constructPlatformClassContext(VmClassLoader platformClassLoaderObject) {
        return this.platformClassContextFactory.apply(platformClassLoaderObject);
    }

    private ClassContext handleNewClassContext(ClassContext classContext) {
        this.classContextListener.accept(classContext);
        return classContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void submitTask(T item, Consumer<T> itemConsumer) {
        Queue<Object> queue = this.queue;
        synchronized (queue) {
            this.queue.add(item);
            this.queue.add(itemConsumer);
            this.queue.notify();
        }
    }

    public NativeMethodConfigurator getNativeMethodConfigurator() {
        return this.nativeMethodConfigurator;
    }

    public void registerEntryPoint(ExecutableElement method) {
        this.enqueue(method);
        this.entryPoints.add(method);
    }

    public Path getOutputDirectory() {
        return this.outputDir;
    }

    public Path getOutputFile(DefinedTypeDefinition type, String suffix) {
        Path basePath = this.getOutputDirectory(type);
        String fileName = basePath.getFileName().toString() + "." + suffix;
        return basePath.resolveSibling(fileName);
    }

    public Path getOutputDirectory(DefinedTypeDefinition type) {
        int idx;
        Path base = this.outputDir;
        VmClassLoader classLoader = type.getContext().getClassLoader();
        String name = classLoader == null ? "boot" : classLoader.getName();
        base = base.resolve(name);
        Object internalName = type.getInternalName();
        if (type.isHidden()) {
            internalName = (String)internalName + "~" + ENCODER.encodeToString(type.getDigest()) + "." + type.getHiddenClassIndex();
        }
        if ((idx = ((String)internalName).indexOf(47)) == -1) {
            return base.resolve((String)internalName);
        }
        base = base.resolve(((String)internalName).substring(0, idx));
        int start;
        while ((idx = ((String)internalName).indexOf(47, start = idx + 1)) != -1) {
            base = base.resolve(((String)internalName).substring(start, idx));
        }
        return base.resolve(((String)internalName).substring(start));
    }

    public Path getOutputDirectory(MemberElement element) {
        Path base = this.getOutputDirectory(element.getEnclosingType());
        if (element instanceof InitializerElement) {
            return base.resolve("class-init");
        }
        if (element instanceof FieldElement) {
            return base.resolve("fields").resolve(((FieldElement)element).getName());
        }
        if (element instanceof ConstructorElement) {
            return base.resolve("ctors").resolve("ctor.id" + element.getIndex());
        }
        if (element instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)element;
            return base.resolve("methods").resolve(methodElement.getName() + ".id" + element.getIndex());
        }
        if (element instanceof FunctionElement) {
            return base.resolve("functions").resolve(((FunctionElement)element).getName());
        }
        throw new UnsupportedOperationException("getOutputDirectory for element " + element.getClass());
    }

    public ProgramModule getOrAddProgramModule(DefinedTypeDefinition type) {
        return this.programModules.computeIfAbsent(type, t -> new ProgramModule(t, this.typeSystem, this.literalFactory));
    }

    public List<ProgramModule> getAllProgramModules() {
        return List.of((ProgramModule[])this.programModules.values().toArray(ProgramModule[]::new));
    }

    public Function getExactFunction(ExecutableElement element) {
        FunctionElement established = (FunctionElement)this.establishedFunctions.get(element);
        if (established != null) {
            return this.getExactFunction((ExecutableElement)established);
        }
        Function function = this.getExactFunctionIfExists(element);
        if (function != null) {
            return function;
        }
        if (!this.mayBeEnqueued(element)) {
            throw new IllegalArgumentException("Cannot access function for un-lowered element " + element);
        }
        return this.exactFunctions.computeIfAbsent(element, e -> {
            ModuleSection implicit = this.getImplicitSection(element);
            InvokableType elementType = element.getType();
            FunctionType functionType = this.getFunctionTypeForElement(element);
            return implicit.addFunction(element, this.getExactNameForElement(element, elementType), functionType);
        });
    }

    public Function getExactFunctionIfExists(ExecutableElement element) {
        FunctionElement established = (FunctionElement)this.establishedFunctions.get(element);
        if (established != null) {
            return this.getExactFunctionIfExists((ExecutableElement)established);
        }
        return (Function)this.exactFunctions.get(element);
    }

    public FunctionElement establishExactFunction(ExecutableElement element, FunctionElement function) {
        FunctionElement existing = this.establishedFunctions.putIfAbsent(element, function);
        if (existing != null) {
            throw new IllegalStateException(String.format("Attempted to map a function that was already mapped: element %s cannot map to %s because it is mapped to %s already", element, function, existing));
        }
        return function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefinedTypeDefinition getDefaultTypeDefinition() {
        if (this.defaultTypeDefinition != null) {
            return this.defaultTypeDefinition;
        }
        CompilationContextImpl compilationContextImpl = this;
        synchronized (compilationContextImpl) {
            DefinedTypeDefinition defaultType;
            if (this.defaultTypeDefinition != null) {
                return this.defaultTypeDefinition;
            }
            DefinedTypeDefinition.Builder typeBuilder = DefinedTypeDefinition.Builder.basic();
            ClassTypeDescriptor desc = ClassTypeDescriptor.synthesize((ClassContext)this.bootstrapClassContext, (String)"__qbicc-default-type__");
            typeBuilder.setDescriptor((TypeDescriptor)desc);
            typeBuilder.setSignature((Signature)ClassSignature.synthesize((ClassContext)this.bootstrapClassContext, null, List.of()));
            typeBuilder.setName("__qbicc-default-type__");
            typeBuilder.setContext(this.bootstrapClassContext);
            typeBuilder.setModifiers(0x800011);
            typeBuilder.setInitializer((index, enclosing, builder) -> {
                builder.setEnclosingType(enclosing);
                return builder.build();
            }, 0);
            this.defaultTypeDefinition = defaultType = typeBuilder.build();
            return defaultType;
        }
    }

    public ModuleSection getImplicitSection(ExecutableElement element) {
        return this.getImplicitSection(element.getEnclosingType());
    }

    public ModuleSection getImplicitSection(DefinedTypeDefinition typeDefinition) {
        return this.getOrAddProgramModule(typeDefinition).inSection(this.getImplicitSection());
    }

    public Section getImplicitSection() {
        return this.implicitSection;
    }

    public Vm getVm() {
        return this.vm;
    }

    private StringBuilder appendHex(StringBuilder b, char hex) {
        b.append(hexDigits[hex >> 12 & 0xF]);
        b.append(hexDigits[hex >> 8 & 0xF]);
        b.append(hexDigits[hex >> 4 & 0xF]);
        b.append(hexDigits[hex >> 0 & 0xF]);
        return b;
    }

    private StringBuilder mangleTo(StringBuilder b, String str) {
        int length = str.length();
        block8: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '/': {
                    b.append('_');
                    continue block8;
                }
                case '_': {
                    b.append("_1");
                    continue block8;
                }
                case ';': {
                    b.append("_2");
                    continue block8;
                }
                case '[': {
                    b.append("_3");
                    continue block8;
                }
                case '<': {
                    b.append("_4");
                    continue block8;
                }
                case '>': {
                    b.append("_5");
                    continue block8;
                }
                default: {
                    if ('A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z' || '0' <= ch && ch <= '9' || ch == '$' || ch == '.') {
                        b.append(ch);
                        continue block8;
                    }
                    this.appendHex(b.append("_0"), ch);
                }
            }
        }
        return b;
    }

    private String getExactNameForElement(ExecutableElement element, InvokableType type) {
        boolean overloaded;
        DefinedTypeDefinition enclosingType = element.getEnclosingType();
        Object internalName = enclosingType.getInternalName();
        if (enclosingType.isHidden()) {
            internalName = (String)internalName + "$" + ENCODER.encodeToString(enclosingType.getDigest()) + "." + enclosingType.getHiddenClassIndex();
        }
        if (element instanceof FunctionElement) {
            FunctionElement fe = (FunctionElement)element;
            return fe.getName();
        }
        StringBuilder b = new StringBuilder(((String)internalName).length() << 1);
        b.append("_J");
        this.mangleTo(b, (String)internalName);
        b.append('_');
        if (element instanceof InitializerElement) {
            this.mangleTo(b, "<clinit>");
            overloaded = false;
        } else if (element instanceof ConstructorElement) {
            this.mangleTo(b, "<init>");
            overloaded = true;
        } else if (element instanceof MethodElement) {
            MethodElement me = (MethodElement)element;
            this.mangleTo(b, me.getName());
            overloaded = true;
        } else {
            throw new IllegalStateException();
        }
        if (overloaded) {
            b.append("__");
            MethodDescriptor elementDescriptor = element.getDescriptor();
            for (TypeDescriptor descriptor : elementDescriptor.getParameterTypes()) {
                if (descriptor.equals(enclosingType.getDescriptor())) {
                    b.append('L');
                    this.mangleTo(b, (String)internalName);
                    this.mangleTo(b, ";");
                    continue;
                }
                this.mangleTo(b, descriptor.toString());
            }
            if (element instanceof MethodElement) {
                b.append("_");
                TypeDescriptor returnTypeDescriptor = elementDescriptor.getReturnType();
                if (returnTypeDescriptor.equals(enclosingType.getDescriptor())) {
                    b.append('L');
                    this.mangleTo(b, (String)internalName);
                    this.mangleTo(b, ";");
                } else {
                    this.mangleTo(b, returnTypeDescriptor.toString());
                }
            }
        }
        return b.toString();
    }

    public FunctionType getFunctionTypeForInvokableType(InvokableType origType) {
        ClassObjectType threadType = this.bootstrapClassContext.findDefinedType("java/lang/Thread").load().getClassType();
        int pcnt = origType.getParameterCount();
        if (origType instanceof FunctionType) {
            FunctionType ft = (FunctionType)origType;
            return ft;
        }
        assert (origType instanceof MethodType);
        MethodType mt = (MethodType)origType;
        ArrayList<Object> argTypes = new ArrayList<Object>(pcnt + 2);
        argTypes.add(threadType.getReference());
        if (origType instanceof InstanceMethodType) {
            InstanceMethodType imt = (InstanceMethodType)origType;
            argTypes.add(imt.getReceiverType());
        }
        argTypes.addAll(origType.getParameterTypes());
        return this.typeSystem.getFunctionType(mt.getReturnType(), List.copyOf(argTypes));
    }

    public FunctionType getFunctionTypeForElement(ExecutableElement element) {
        return this.getFunctionTypeForInvokableType(element.getType());
    }

    public FunctionType getFunctionTypeForInitializer() {
        ClassObjectType threadType = this.bootstrapClassContext.findDefinedType("java/lang/Thread").load().getClassType();
        return this.typeSystem.getFunctionType((ValueType)this.typeSystem.getVoidType(), List.of(threadType.getReference()));
    }

    public Iterable<ExecutableElement> getEntryPoints() {
        return this.entryPoints;
    }

    BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> getBlockFactory() {
        return this.blockFactory;
    }

    void setBlockFactory(BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> blockFactory) {
        this.blockFactory = blockFactory;
    }

    void setCopier(BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> copier) {
        this.copier = copier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskRunner(BiConsumer<Consumer<CompilationContext>, CompilationContext> taskRunner) throws IllegalStateException {
        Assert.checkNotNullParam((String)"taskRunner", taskRunner);
        CompilationContextImpl compilationContextImpl = this;
        synchronized (compilationContextImpl) {
            if (this.state != 0) {
                throw new IllegalStateException("Invalid thread state");
            }
            this.taskRunner = taskRunner;
        }
    }

    public void runWrappedTask(Consumer<CompilationContext> task) {
        this.taskRunner.accept(task, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runParallelTask(Consumer<CompilationContext> task) throws IllegalStateException {
        Assert.checkNotNullParam((String)"task", task);
        boolean intr = false;
        try {
            CompilationContextImpl compilationContextImpl = this;
            synchronized (compilationContextImpl) {
                if (this.state != 0) {
                    throw new IllegalStateException("Invalid thread state");
                }
                this.task = task;
                this.threadAcks = 0;
                this.state = 1;
                this.notifyAll();
                while (this.threadAcks < this.activeThreads) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                this.threadAcks = 0;
                this.state = 2;
                this.notifyAll();
                while (this.threadAcks < this.activeThreads) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
                this.threadAcks = 0;
                this.state = 0;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> getCopier() {
        BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> copier = this.copier;
        if (copier == null) {
            throw new IllegalStateException();
        }
        return copier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processQueue() {
        CompilationContextImpl compilationContextImpl = this;
        synchronized (compilationContextImpl) {
            this.waiting = 0;
        }
        this.runParallelTask(ctxt -> {
            while (true) {
                Consumer consumer;
                Object item;
                Queue<Object> queue = this.queue;
                synchronized (queue) {
                    item = this.queue.poll();
                    if (item == null) {
                        block13: {
                            ++this.waiting;
                            if (this.waiting == this.activeThreads) {
                                this.queue.notifyAll();
                                return;
                            }
                            do {
                                try {
                                    this.queue.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                item = this.queue.poll();
                                if (item != null) break block13;
                            } while (this.waiting != this.activeThreads);
                            return;
                        }
                        --this.waiting;
                    }
                    consumer = (Consumer)this.queue.poll();
                }
                assert (consumer != null);
                try {
                    CompilationContextImpl.safeAccept(consumer, item);
                    continue;
                }
                catch (Throwable e) {
                    log.error((Object)"An exception was thrown from a queue processing task", e);
                    if (item instanceof Locatable) {
                        Locatable loc = (Locatable)item;
                        this.error(loc.getLocation(), "Exception while processing queue task %s for %s: %s", new Object[]{consumer, item, e});
                        continue;
                    }
                    this.error("Exception while processing queue task %s for %s: %s", new Object[]{consumer, item, e});
                    continue;
                }
                break;
            }
        });
    }

    static <T> void safeAccept(Consumer<T> consumer, Object item) {
        consumer.accept(item);
    }

    void startThreads(int threadCnt, long stackSize) {
        int i;
        ThreadGroup threadGroup = new ThreadGroup("qbicc compiler thread group");
        Thread[] threads = new Thread[threadCnt];
        for (i = 0; i < threadCnt; ++i) {
            threads[i] = new Thread(threadGroup, this.threadTask, "qbicc compiler thread " + (i + 1) + "/" + threadCnt, stackSize, false);
        }
        for (i = 0; i < threadCnt; ++i) {
            try {
                threads[i].start();
                continue;
            }
            catch (Exception e) {
                this.error("Failed to start a compiler thread: %s", new Object[]{e});
                this.exitThreads();
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void exitThreads() {
        boolean intr = false;
        try {
            CompilationContextImpl compilationContextImpl = this;
            synchronized (compilationContextImpl) {
                int state = this.state;
                if (state != 0) {
                    throw new IllegalStateException("Unexpected thread state");
                }
                this.state = 3;
                this.notifyAll();
                while (true) {
                    if (this.activeThreads == 0) {
                        return;
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> getTypeBuilderFactories() {
        return this.typeBuilderFactories;
    }

    static Builder builder() {
        return new Builder();
    }

    MethodTypeId getMethodType(TypeId returnTypeId, List<TypeId> paramTypeIds, MethodDescriptor descriptor) {
        MethodTypeId appearing;
        MethodTypeId methodType;
        ConcurrentMap appearing2;
        ConcurrentMap<List<TypeId>, MethodTypeId> subMap = (ConcurrentHashMap)this.methodTypes.get(returnTypeId);
        if (subMap == null && (appearing2 = (ConcurrentMap)this.methodTypes.putIfAbsent(returnTypeId, subMap = new ConcurrentHashMap())) != null) {
            subMap = appearing2;
        }
        if ((methodType = (MethodTypeId)subMap.get(paramTypeIds)) == null && (appearing = subMap.putIfAbsent(paramTypeIds, methodType = new MethodTypeId(List.copyOf(paramTypeIds), returnTypeId, descriptor))) != null) {
            methodType = appearing;
        }
        return methodType;
    }

    static final class Builder {
        BaseDiagnosticContext baseDiagnosticContext;
        Platform platform;
        TypeSystem typeSystem;
        LiteralFactory literalFactory;
        Scheduler scheduler;
        BiFunction<ClassContext, String, DefinedTypeDefinition> bootstrapFinder;
        BiFunction<ClassContext, String, byte[]> bootstrapResourceFinder;
        BiFunction<ClassContext, String, List<byte[]>> bootstrapResourcesFinder;
        BiFunction<ClassContext, String, DefinedTypeDefinition> appFinder;
        BiFunction<ClassContext, String, byte[]> appResourceFinder;
        BiFunction<ClassContext, String, List<byte[]>> appResourcesFinder;
        BiFunction<ClassContext, String, DefinedTypeDefinition> platformFinder;
        BiFunction<ClassContext, String, byte[]> platformResourceFinder;
        BiFunction<ClassContext, String, List<byte[]>> platformResourcesFinder;
        java.util.function.Function<CompilationContext, Vm> vmFactory;
        Path outputDir;
        List<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>> resolverFactories;
        List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> typeBuilderFactories;
        NativeMethodConfigurator nativeMethodConfigurator;
        Consumer<ClassContext> classContextListener;

        private Builder() {
        }

        Builder setBaseDiagnosticContext(BaseDiagnosticContext baseDiagnosticContext) {
            this.baseDiagnosticContext = baseDiagnosticContext;
            return this;
        }

        Builder setPlatform(Platform platform) {
            this.platform = platform;
            return this;
        }

        Builder setTypeSystem(TypeSystem typeSystem) {
            this.typeSystem = typeSystem;
            return this;
        }

        Builder setLiteralFactory(LiteralFactory literalFactory) {
            this.literalFactory = literalFactory;
            return this;
        }

        Builder setScheduler(Scheduler scheduler) {
            this.scheduler = scheduler;
            return this;
        }

        Builder setBootstrapFinder(BiFunction<ClassContext, String, DefinedTypeDefinition> bootstrapFinder) {
            this.bootstrapFinder = bootstrapFinder;
            return this;
        }

        Builder setBootstrapResourceFinder(BiFunction<ClassContext, String, byte[]> bootstrapResourceFinder) {
            this.bootstrapResourceFinder = bootstrapResourceFinder;
            return this;
        }

        Builder setBootstrapResourcesFinder(BiFunction<ClassContext, String, List<byte[]>> bootstrapResourcesFinder) {
            this.bootstrapResourcesFinder = bootstrapResourcesFinder;
            return this;
        }

        Builder setAppFinder(BiFunction<ClassContext, String, DefinedTypeDefinition> appFinder) {
            this.appFinder = appFinder;
            return this;
        }

        Builder setAppResourceFinder(BiFunction<ClassContext, String, byte[]> appResourceFinder) {
            this.appResourceFinder = appResourceFinder;
            return this;
        }

        Builder setAppResourcesFinder(BiFunction<ClassContext, String, List<byte[]>> appResourcesFinder) {
            this.appResourcesFinder = appResourcesFinder;
            return this;
        }

        Builder setPlatformFinder(BiFunction<ClassContext, String, DefinedTypeDefinition> platformFinder) {
            this.platformFinder = platformFinder;
            return this;
        }

        Builder setPlatformResourceFinder(BiFunction<ClassContext, String, byte[]> platformResourceFinder) {
            this.platformResourceFinder = platformResourceFinder;
            return this;
        }

        Builder setPlatformResourcesFinder(BiFunction<ClassContext, String, List<byte[]>> platformResourcesFinder) {
            this.platformResourcesFinder = platformResourcesFinder;
            return this;
        }

        Builder setVmFactory(java.util.function.Function<CompilationContext, Vm> vmFactory) {
            this.vmFactory = vmFactory;
            return this;
        }

        Builder setOutputDir(Path outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        Builder setResolverFactories(List<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>> resolverFactories) {
            this.resolverFactories = resolverFactories;
            return this;
        }

        Builder setTypeBuilderFactories(List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> typeBuilderFactories) {
            this.typeBuilderFactories = typeBuilderFactories;
            return this;
        }

        Builder setNativeMethodConfigurator(NativeMethodConfigurator nativeMethodConfigurator) {
            this.nativeMethodConfigurator = nativeMethodConfigurator;
            return this;
        }

        Builder setClassContextListener(Consumer<ClassContext> classContextListener) {
            this.classContextListener = classContextListener;
            return this;
        }

        CompilationContextImpl build() {
            return new CompilationContextImpl(this);
        }
    }
}

