/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.os.OS;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

final class DirectoryClassPathElement
extends ClassPathElement {
    private final Path baseDir;

    DirectoryClassPathElement(Path baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public String getName() {
        return this.baseDir.toString();
    }

    @Override
    public ClassPathElement.Resource getResource(String name) throws IOException {
        Path resourcePath = this.baseDir.resolve(name);
        return !Files.exists(resourcePath, new LinkOption[0]) ? NON_EXISTENT : new Resource(FileChannel.open(resourcePath, Set.of(StandardOpenOption.READ), new FileAttribute[0]));
    }

    @Override
    public void close() {
    }

    @Override
    public void mount(VirtualFileSystem vfs, VirtualPath mountPoint) throws IOException {
        this.mount(vfs, mountPoint, this.baseDir);
    }

    private void mount(VirtualFileSystem vfs, VirtualPath mountPoint, Path dirPath) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dirPath);){
            for (Path path : stream) {
                if (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
                    VirtualPath subDirPath = mountPoint.resolve(path.getFileName().toString());
                    vfs.mkdir(subDirPath, 493);
                    this.mount(vfs, subDirPath, path);
                    continue;
                }
                vfs.bindExternalNode(mountPoint, path, true, false);
            }
        }
    }

    static final class Resource
    extends ClassPathElement.Resource {
        private final FileChannel channel;
        private ByteBuffer buffer;

        Resource(FileChannel channel) {
            this.channel = channel;
        }

        @Override
        public ByteBuffer getBuffer() throws IOException {
            ByteBuffer buffer = this.buffer;
            if (buffer == null) {
                buffer = OS.current() == OS.WINDOWS ? (this.buffer = ByteBuffer.wrap(Channels.newInputStream(this.channel).readAllBytes())) : (this.buffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size()));
            }
            return buffer;
        }

        @Override
        public void close() throws IOException {
            this.channel.close();
        }
    }
}

