/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.Functions;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.logging.Logger;
import org.qbicc.context.AttachmentKey;
import org.qbicc.context.ClassContext;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.Diagnostic;
import org.qbicc.driver.BaseDiagnosticContext;
import org.qbicc.driver.BuilderStage;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.driver.ClassPathItem;
import org.qbicc.driver.CompilationContextImpl;
import org.qbicc.driver.Phase;
import org.qbicc.graph.BasicBlock;
import org.qbicc.graph.BasicBlockBuilder;
import org.qbicc.graph.Node;
import org.qbicc.graph.NodeVisitor;
import org.qbicc.graph.Value;
import org.qbicc.graph.literal.LiteralFactory;
import org.qbicc.graph.schedule.Scheduler;
import org.qbicc.interpreter.Vm;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.object.ObjectFileProvider;
import org.qbicc.machine.tool.CToolChain;
import org.qbicc.tool.llvm.LlvmToolChain;
import org.qbicc.type.TypeSystem;
import org.qbicc.type.definition.DefinedTypeDefinition;
import org.qbicc.type.definition.DescriptorTypeResolver;
import org.qbicc.type.definition.LoadedTypeDefinition;
import org.qbicc.type.definition.ModuleDefinition;
import org.qbicc.type.definition.NativeMethodConfigurator;
import org.qbicc.type.definition.classfile.ClassFile;
import org.qbicc.type.definition.element.ExecutableElement;

public class Driver
implements Closeable {
    private static final Logger log = Logger.getLogger((String)"org.qbicc.driver");
    private static final AttachmentKey<Driver> KEY = new AttachmentKey();
    static final String MODULE_INFO = "module-info.class";
    public static final AttachmentKey<CToolChain> C_TOOL_CHAIN_KEY = new AttachmentKey();
    public static final AttachmentKey<LlvmToolChain> LLVM_TOOL_KEY = new AttachmentKey();
    public static final AttachmentKey<ObjectFileProvider> OBJ_PROVIDER_TOOL_KEY = new AttachmentKey();
    final BaseDiagnosticContext initialContext;
    final CompilationContextImpl compilationContext;
    final List<Consumer<CompilationContext>> preAddHooks;
    final List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> typeBuilderFactories;
    final BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> addBuilderFactory;
    final List<Consumer<CompilationContext>> postAddHooks;
    final List<Consumer<CompilationContext>> preAnalyzeHooks;
    final BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> addToAnalyzeCopiers;
    final BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> analyzeBuilderFactory;
    final List<Consumer<CompilationContext>> postAnalyzeHooks;
    final List<Consumer<CompilationContext>> preLowerHooks;
    final BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> analyzeToLowerCopiers;
    final BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> lowerBuilderFactory;
    final List<Consumer<CompilationContext>> postLowerHooks;
    final List<Consumer<CompilationContext>> preGenerateHooks;
    final List<Consumer<CompilationContext>> postGenerateHooks;
    final Map<String, BootModule> bootModules;
    final List<ClassPathItem> bootClassPath;
    final List<ClassPathItem> appClassPath;
    final Path outputDir;
    final float threadsPerCpu;
    final long stackSize;
    final Consumer<ClassContext> classContextListener;

    Driver(Builder builder) {
        this.initialContext = (BaseDiagnosticContext)Assert.checkNotNullParam((String)"builder.initialContext", (Object)builder.initialContext);
        this.outputDir = (Path)Assert.checkNotNullParam((String)"builder.outputDirectory", (Object)builder.outputDirectory);
        this.typeBuilderFactories = builder.typeBuilderFactories;
        this.initialContext.putAttachment(C_TOOL_CHAIN_KEY, (CToolChain)Assert.checkNotNullParam((String)"builder.toolChain", (Object)builder.toolChain));
        this.initialContext.putAttachment(LLVM_TOOL_KEY, (LlvmToolChain)Assert.checkNotNullParam((String)"builder.llvmToolChain", (Object)builder.llvmToolChain));
        this.initialContext.putAttachment(OBJ_PROVIDER_TOOL_KEY, (ObjectFileProvider)Assert.checkNotNullParam((String)"builder.objectFileProvider", (Object)builder.objectFileProvider));
        TypeSystem typeSystem = builder.typeSystem;
        LiteralFactory literalFactory = LiteralFactory.create((TypeSystem)typeSystem);
        HashMap<String, BootModule> bootModules = new HashMap<String, BootModule>();
        this.bootClassPath = List.copyOf(builder.bootClassPath);
        for (ClassPathItem item : this.bootClassPath) {
            try {
                ClassPathElement.Resource moduleInfo = item.findResource(MODULE_INFO);
                try {
                    if (moduleInfo == ClassPathElement.NON_EXISTENT) continue;
                    ByteBuffer buffer = moduleInfo.getBuffer();
                    ModuleDefinition moduleDefinition = ModuleDefinition.create((ByteBuffer)buffer);
                    bootModules.put(moduleDefinition.getName(), new BootModule(item, moduleDefinition));
                }
                finally {
                    if (moduleInfo == null) continue;
                    moduleInfo.close();
                }
            }
            catch (Exception e) {
                this.initialContext.error("Failed to read module from class path element \"%s\": %s", new Object[]{item, e});
            }
        }
        BootModule javaBase = (BootModule)bootModules.get("java.base");
        if (javaBase == null) {
            this.initialContext.error("Bootstrap failed: no java.base module found", new Object[0]);
        }
        this.bootModules = bootModules;
        this.appClassPath = List.copyOf(builder.appClassPath);
        this.preAddHooks = List.copyOf(builder.preHooks.getOrDefault((Object)Phase.ADD, List.of()));
        this.addBuilderFactory = Driver.constructFactory(builder, Phase.ADD);
        this.postAddHooks = List.copyOf(builder.postHooks.getOrDefault((Object)Phase.ADD, List.of()));
        this.preAnalyzeHooks = List.copyOf(builder.preHooks.getOrDefault((Object)Phase.ANALYZE, List.of()));
        this.addToAnalyzeCopiers = Driver.constructCopiers(builder, Phase.ANALYZE);
        this.analyzeBuilderFactory = Driver.constructFactory(builder, Phase.ANALYZE);
        this.postAnalyzeHooks = List.copyOf(builder.postHooks.getOrDefault((Object)Phase.ANALYZE, List.of()));
        this.preLowerHooks = List.copyOf(builder.preHooks.getOrDefault((Object)Phase.LOWER, List.of()));
        this.analyzeToLowerCopiers = Driver.constructCopiers(builder, Phase.LOWER);
        this.lowerBuilderFactory = Driver.constructFactory(builder, Phase.LOWER);
        this.postLowerHooks = List.copyOf(builder.postHooks.getOrDefault((Object)Phase.LOWER, List.of()));
        this.preGenerateHooks = List.copyOf(builder.preHooks.getOrDefault((Object)Phase.GENERATE, List.of()));
        this.postGenerateHooks = List.copyOf(builder.postHooks.getOrDefault((Object)Phase.GENERATE, List.of()));
        ArrayList<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>> resolverFactories = new ArrayList<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>>(builder.resolverFactories);
        Collections.reverse(resolverFactories);
        this.classContextListener = builder.classContextListener;
        Function vmFactory = (Function)Assert.checkNotNullParam((String)"builder.vmFactory", builder.vmFactory);
        NativeMethodConfigurator nativeMethodConfigurator = this.constructNativeMethodConfigurator(builder);
        Scheduler scheduler = new Scheduler(Scheduler.Mode.EARLY);
        CompilationContextImpl.Builder ctxtBuilder = CompilationContextImpl.builder().setBaseDiagnosticContext(this.initialContext).setPlatform(builder.targetPlatform).setTypeSystem(typeSystem).setLiteralFactory(literalFactory).setScheduler(scheduler).setBootstrapFinder(this::defaultFinder).setBootstrapResourceFinder(this::defaultResourceFinder).setBootstrapResourcesFinder(this::defaultResourcesFinder).setAppFinder(this::appFinder).setAppResourceFinder(this::appResourceFinder).setAppResourcesFinder(this::appResourcesFinder).setPlatformFinder(this::platFinder).setPlatformResourceFinder(this::platResourceFinder).setPlatformResourcesFinder(this::platResourcesFinder).setVmFactory(vmFactory).setOutputDir(this.outputDir).setResolverFactories(resolverFactories).setTypeBuilderFactories(this.typeBuilderFactories).setNativeMethodConfigurator(nativeMethodConfigurator).setClassContextListener(this.classContextListener);
        this.compilationContext = ctxtBuilder.build();
        this.compilationContext.setBlockFactory(this.addBuilderFactory);
        this.threadsPerCpu = builder.threadsPerCpu;
        this.stackSize = builder.stackSize;
        this.compilationContext.putAttachment(KEY, this);
    }

    public static Driver get(CompilationContext ctxt) {
        Driver driver = (Driver)ctxt.getAttachment(KEY);
        if (driver == null) {
            throw new IllegalStateException();
        }
        return driver;
    }

    public ClassPathItem getBootModuleClassPathItem(String name) {
        BootModule module = this.bootModules.get(name);
        if (module == null) {
            throw new NoSuchElementException();
        }
        return module.item();
    }

    public Collection<String> getBootModuleNames() {
        return List.copyOf(this.bootModules.keySet());
    }

    private NativeMethodConfigurator constructNativeMethodConfigurator(Builder builder) {
        ArrayList<UnaryOperator<NativeMethodConfigurator>> list = new ArrayList<UnaryOperator<NativeMethodConfigurator>>(builder.nativeMethodConfiguratorFactories);
        Collections.reverse(list);
        NativeMethodConfigurator result = (bbb, enclosing, name, methodDescriptor) -> {};
        for (UnaryOperator unaryOperator : list) {
            result = (NativeMethodConfigurator)unaryOperator.apply(result);
        }
        return result;
    }

    private static BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> constructCopiers(Builder builder, Phase phase) {
        List list = builder.copyFactories.getOrDefault((Object)phase, List.of());
        if (list.isEmpty()) {
            return (c, v) -> v;
        }
        if (list.size() == 1) {
            return (BiFunction)list.get(0);
        }
        ArrayList copy = new ArrayList(list);
        Collections.reverse(copy);
        return (c, v) -> {
            for (BiFunction fn : copy) {
                v = (NodeVisitor)fn.apply(c, v);
            }
            return v;
        };
    }

    private static BiFunction<BasicBlockBuilder.FactoryContext, ExecutableElement, BasicBlockBuilder> constructFactory(Builder builder, Phase phase) {
        BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder> addWrapper = Driver.assembleFactories(builder.builderFactories.getOrDefault((Object)phase, Map.of()));
        return (ctxt, executableElement) -> (BasicBlockBuilder)addWrapper.apply((BasicBlockBuilder.FactoryContext)ctxt, BasicBlockBuilder.simpleBuilder((ExecutableElement)executableElement));
    }

    private static BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder> assembleFactories(Map<BuilderStage, List<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>>> map) {
        return Driver.assembleFactories(List.of(Driver.assembleFactories(map.getOrDefault((Object)BuilderStage.TRANSFORM, List.of())), Driver.assembleFactories(map.getOrDefault((Object)BuilderStage.CORRECT, List.of())), Driver.assembleFactories(map.getOrDefault((Object)BuilderStage.OPTIMIZE, List.of())), Driver.assembleFactories(map.getOrDefault((Object)BuilderStage.INTEGRITY, List.of()))));
    }

    private static BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder> assembleFactories(List<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>> list) {
        if (list.isEmpty()) {
            return (c, b) -> b;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        ArrayList<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>> copy = new ArrayList<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>>(list);
        Collections.reverse(copy);
        return (c, builder) -> {
            for (BiFunction fn : copy) {
                builder = (BasicBlockBuilder)fn.apply(c, builder);
            }
            return builder;
        };
    }

    private DefinedTypeDefinition defaultFinder(ClassContext classContext, String name) {
        return this.findClassDefinition(classContext, name, this.bootClassPath);
    }

    private byte[] defaultResourceFinder(ClassContext classContext, String name) {
        return this.findResource(classContext, name, this.bootClassPath);
    }

    private List<byte[]> defaultResourcesFinder(ClassContext classContext, String name) {
        return this.findResources(classContext, name, this.bootClassPath);
    }

    private DefinedTypeDefinition appFinder(ClassContext classContext, String name) {
        DefinedTypeDefinition found = this.getCompilationContext().getBootstrapClassContext().findDefinedType(name);
        if (found == null) {
            found = this.findClassDefinition(classContext, name, this.appClassPath);
        }
        return found;
    }

    private byte[] appResourceFinder(ClassContext classContext, String name) {
        return this.findResource(classContext, name, this.appClassPath);
    }

    private List<byte[]> appResourcesFinder(ClassContext classContext, String name) {
        return this.findResources(classContext, name, this.appClassPath);
    }

    private DefinedTypeDefinition platFinder(ClassContext classContext, String name) {
        DefinedTypeDefinition found = this.getCompilationContext().getBootstrapClassContext().findDefinedType(name);
        if (found == null) {
            // empty if block
        }
        return found;
    }

    private byte[] platResourceFinder(ClassContext classContext, String name) {
        return null;
    }

    private List<byte[]> platResourcesFinder(ClassContext classContext, String name) {
        return List.of();
    }

    private DefinedTypeDefinition findClassDefinition(ClassContext classContext, String name, List<ClassPathItem> classPath) {
        String fileName = name + ".class";
        for (ClassPathItem item : classPath) {
            DefinedTypeDefinition definedTypeDefinition;
            block11: {
                ClassPathElement.Resource resource;
                block10: {
                    resource = item.findResource(fileName);
                    try {
                        if (resource != ClassPathElement.NON_EXISTENT) break block10;
                        if (resource == null) continue;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resource != null) {
                                try {
                                    resource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.warnf((Throwable)e, "An exception was thrown while loading class \"%s\"", (Object)name);
                            classContext.getCompilationContext().warning("Failed to load class \"%s\" due to an exception: %s", new Object[]{name, e});
                            return null;
                        }
                    }
                    resource.close();
                    continue;
                }
                ByteBuffer buffer = resource.getBuffer();
                ClassFile classFile = ClassFile.of((ClassContext)classContext, (ByteBuffer)buffer);
                DefinedTypeDefinition.Builder builder = classContext.newTypeBuilder();
                classFile.accept(builder);
                DefinedTypeDefinition def = builder.build();
                classContext.defineClass(name, def);
                definedTypeDefinition = def;
                if (resource == null) break block11;
                resource.close();
            }
            return definedTypeDefinition;
        }
        return null;
    }

    private byte[] findResource(ClassContext classContext, String name, List<ClassPathItem> classPath) {
        for (ClassPathItem item : classPath) {
            byte[] byArray;
            block11: {
                ClassPathElement.Resource resource;
                block10: {
                    resource = item.findResource(name);
                    try {
                        if (resource != ClassPathElement.NON_EXISTENT) break block10;
                        if (resource == null) continue;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (resource != null) {
                                try {
                                    resource.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            log.warnf((Throwable)e, "An exception was thrown while loading resource \"%s\"", (Object)name);
                            classContext.getCompilationContext().warning("Failed to load resource \"%s\" due to an exception: %s", new Object[]{name, e});
                            return null;
                        }
                    }
                    resource.close();
                    continue;
                }
                ByteBuffer buffer = resource.getBuffer();
                byte[] bytes = new byte[buffer.remaining()];
                buffer.get(bytes);
                byArray = bytes;
                if (resource == null) break block11;
                resource.close();
            }
            return byArray;
        }
        return null;
    }

    private List<byte[]> findResources(ClassContext classContext, String name, List<ClassPathItem> classPath) {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        for (ClassPathItem item : classPath) {
            try {
                ClassPathElement.Resource resource = item.findResource(name);
                try {
                    if (resource == ClassPathElement.NON_EXISTENT) continue;
                    ByteBuffer buffer = resource.getBuffer();
                    byte[] bytes = new byte[buffer.remaining()];
                    buffer.get(bytes);
                    list.add(bytes);
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (Exception e) {
                log.warnf((Throwable)e, "An exception was thrown while loading resource \"%s\"", (Object)name);
                classContext.getCompilationContext().warning("Failed to load resource \"%s\" due to an exception: %s", new Object[]{name, e});
            }
        }
        return List.copyOf(list);
    }

    public CompilationContext getCompilationContext() {
        return this.compilationContext;
    }

    private LoadedTypeDefinition loadBootstrapClass(String name) {
        DefinedTypeDefinition clazz = this.compilationContext.getBootstrapClassContext().findDefinedType(name);
        if (clazz == null) {
            this.compilationContext.error("Required bootstrap class \"%s\" was not found", new Object[]{name});
            return null;
        }
        try {
            return clazz.load();
        }
        catch (Exception ex) {
            log.error((Object)"An exception was thrown while loading a bootstrap class", (Throwable)ex);
            this.compilationContext.error("Failed to load bootstrap class \"%s\": %s", new Object[]{name, ex});
            return null;
        }
    }

    public boolean execute() {
        int threadCnt = (int)Math.max(1.0f, (float)Runtime.getRuntime().availableProcessors() * this.threadsPerCpu);
        this.compilationContext.startThreads(threadCnt, this.stackSize);
        try {
            boolean bl = this.execute0();
            return bl;
        }
        finally {
            this.compilationContext.exitThreads();
        }
    }

    public Consumer<ExecutableElement> constructCopyingStage(Phase phase, Function<BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>>, Consumer<ExecutableElement>> constructor) {
        switch (phase) {
            case ANALYZE: {
                return constructor.apply(this.addToAnalyzeCopiers);
            }
            case LOWER: {
                return constructor.apply(this.analyzeToLowerCopiers);
            }
        }
        throw new IllegalArgumentException();
    }

    boolean execute0() {
        CompilationContextImpl compilationContext = this.compilationContext;
        Phase.ADD.setCurrent(compilationContext);
        for (Consumer<CompilationContext> hook : this.preAddHooks) {
            try {
                compilationContext.runWrappedTask(hook);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a pre-add hook", (Throwable)e);
                compilationContext.error(e, "Pre-add hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        LoadedTypeDefinition stringClass = this.loadBootstrapClass("java/lang/String");
        if (stringClass == null) {
            return false;
        }
        LoadedTypeDefinition threadClass = this.loadBootstrapClass("java/lang/Thread");
        if (threadClass == null) {
            return false;
        }
        for (ExecutableElement executableElement : compilationContext.getEntryPoints()) {
            compilationContext.enqueue(executableElement);
        }
        compilationContext.processQueue();
        if (compilationContext.errors() > 0) {
            return false;
        }
        for (Consumer consumer : this.postAddHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a post-add hook", (Throwable)e);
                compilationContext.error("Post-add hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        if (compilationContext.errors() > 0) {
            return false;
        }
        compilationContext.cyclePhaseAttachments();
        Phase.ANALYZE.setCurrent(compilationContext);
        compilationContext.setBlockFactory(this.analyzeBuilderFactory);
        compilationContext.setCopier(this.addToAnalyzeCopiers);
        compilationContext.setTaskRunner(Consumer::accept);
        for (Consumer consumer : this.preAnalyzeHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a pre-analyze hook", (Throwable)e);
                compilationContext.error("Pre-analyze hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        for (ExecutableElement executableElement : compilationContext.getEntryPoints()) {
            compilationContext.enqueue(executableElement);
        }
        compilationContext.processQueue();
        if (compilationContext.errors() > 0) {
            return false;
        }
        for (Consumer consumer : this.postAnalyzeHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a post-analyze hook", (Throwable)e);
                compilationContext.error("Post-analyze hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        compilationContext.cyclePhaseAttachments();
        Phase.LOWER.setCurrent(compilationContext);
        compilationContext.setBlockFactory(this.lowerBuilderFactory);
        compilationContext.setCopier(this.analyzeToLowerCopiers);
        for (Consumer consumer : this.preLowerHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a pre-lower hook", (Throwable)e);
                compilationContext.error("Pre-lower hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        for (ExecutableElement executableElement : compilationContext.getEntryPoints()) {
            compilationContext.enqueue(executableElement);
        }
        compilationContext.processQueue();
        if (compilationContext.errors() > 0) {
            return false;
        }
        for (Consumer consumer : this.postLowerHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a post-lower hook", (Throwable)e);
                compilationContext.error("Post-lower hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        compilationContext.cyclePhaseAttachments();
        Phase.GENERATE.setCurrent(compilationContext);
        compilationContext.setCopier(null);
        for (Consumer consumer : this.preGenerateHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)"An exception was thrown in a pre-generate hook", (Throwable)e);
                compilationContext.error("Pre-generate hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        for (Consumer consumer : this.postGenerateHooks) {
            try {
                consumer.accept(compilationContext);
            }
            catch (Exception e) {
                log.error((Object)("An exception was thrown in a post-generate hook " + consumer.getClass().getName()), (Throwable)e);
                compilationContext.error("Post-generate hook failed: %s", new Object[]{e});
            }
            if (compilationContext.errors() <= 0) continue;
            return false;
        }
        Phase.complete(compilationContext);
        return compilationContext.errors() == 0;
    }

    @Override
    public void close() {
        for (ClassPathItem item : this.bootClassPath) {
            item.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Iterable<Diagnostic> getDiagnostics() {
        return this.initialContext.getDiagnostics();
    }

    public static final class Builder {
        final List<ClassPathItem> bootClassPath = new ArrayList<ClassPathItem>();
        final List<ClassPathItem> appClassPath = new ArrayList<ClassPathItem>();
        final List<ClassPathItem> appModulePath = new ArrayList<ClassPathItem>();
        final Map<Phase, Map<BuilderStage, List<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>>>> builderFactories = new EnumMap<Phase, Map<BuilderStage, List<BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder>>>>(Phase.class);
        final Map<Phase, List<BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>>>> copyFactories = new EnumMap<Phase, List<BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>>>>(Phase.class);
        final List<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>> typeBuilderFactories = new ArrayList<BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder>>();
        final List<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>> resolverFactories = new ArrayList<BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver>>();
        final Map<Phase, List<Consumer<CompilationContext>>> preHooks = new EnumMap<Phase, List<Consumer<CompilationContext>>>(Phase.class);
        final Map<Phase, List<Consumer<CompilationContext>>> postHooks = new EnumMap<Phase, List<Consumer<CompilationContext>>>(Phase.class);
        final Map<Phase, List<UnaryOperator<BiConsumer<Consumer<CompilationContext>, CompilationContext>>>> taskWrapperFactories = new EnumMap<Phase, List<UnaryOperator<BiConsumer<Consumer<CompilationContext>, CompilationContext>>>>(Phase.class);
        final List<UnaryOperator<NativeMethodConfigurator>> nativeMethodConfiguratorFactories = new ArrayList<UnaryOperator<NativeMethodConfigurator>>();
        Path outputDirectory = Path.of(".", new String[0]);
        BaseDiagnosticContext initialContext;
        Platform targetPlatform;
        TypeSystem typeSystem;
        Function<CompilationContext, Vm> vmFactory;
        CToolChain toolChain;
        LlvmToolChain llvmToolChain;
        ObjectFileProvider objectFileProvider;
        float threadsPerCpu = 2.0f;
        long stackSize = 0x1000000L;
        String mainClass;
        Consumer<ClassContext> classContextListener = Functions.discardingConsumer();

        Builder() {
        }

        public Builder setInitialContext(BaseDiagnosticContext initialContext) {
            this.initialContext = (BaseDiagnosticContext)Assert.checkNotNullParam((String)"initialContext", (Object)initialContext);
            return this;
        }

        public Builder addBootClassPathItem(ClassPathItem item) {
            if (item != null) {
                this.bootClassPath.add(item);
            }
            return this;
        }

        public Builder addAppClassPathItem(ClassPathItem item) {
            if (item != null) {
                this.appClassPath.add(item);
            }
            return this;
        }

        public Builder addAppModulePathItem(ClassPathItem item) {
            if (item != null) {
                this.appModulePath.add(item);
            }
            return this;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Builder setMainClass(String mainClass) {
            this.mainClass = (String)Assert.checkNotNullParam((String)"mainClass", (Object)mainClass);
            return this;
        }

        public Builder addResolverFactory(BiFunction<? super ClassContext, DescriptorTypeResolver, DescriptorTypeResolver> factory) {
            this.resolverFactories.add(factory);
            return this;
        }

        private static <V> EnumMap<BuilderStage, V> newBuilderStageMap(Object key) {
            return new EnumMap(BuilderStage.class);
        }

        private static <E> ArrayList<E> newArrayList(Object key) {
            return new ArrayList();
        }

        public Builder addBuilderFactory(Phase phase, BuilderStage stage, BiFunction<? super BasicBlockBuilder.FactoryContext, BasicBlockBuilder, BasicBlockBuilder> factory) {
            Assert.checkNotNullParam((String)"phase", (Object)((Object)phase));
            Assert.checkNotNullParam((String)"stage", (Object)((Object)stage));
            Assert.checkNotNullParam((String)"factory", factory);
            this.builderFactories.computeIfAbsent(phase, Builder::newBuilderStageMap).computeIfAbsent(stage, Builder::newArrayList).add(factory);
            return this;
        }

        public Builder addCopyFactory(Phase phase, BiFunction<CompilationContext, NodeVisitor<Node.Copier, Value, Node, BasicBlock>, NodeVisitor<Node.Copier, Value, Node, BasicBlock>> factory) {
            Assert.checkNotNullParam((String)"phase", (Object)((Object)phase));
            Assert.checkNotNullParam((String)"factory", factory);
            this.copyFactories.computeIfAbsent(phase, Builder::newArrayList).add(factory);
            return this;
        }

        public Builder addTypeBuilderFactory(BiFunction<? super ClassContext, DefinedTypeDefinition.Builder, DefinedTypeDefinition.Builder> factory) {
            this.typeBuilderFactories.add((BiFunction)Assert.checkNotNullParam((String)"factory", factory));
            return this;
        }

        public Builder addPreHook(Phase phase, Consumer<CompilationContext> hook) {
            if (hook != null) {
                Assert.checkNotNullParam((String)"phase", (Object)((Object)phase));
                this.preHooks.computeIfAbsent(phase, Builder::newArrayList).add(hook);
            }
            return this;
        }

        public Builder addPostHook(Phase phase, Consumer<CompilationContext> hook) {
            if (hook != null) {
                Assert.checkNotNullParam((String)"phase", (Object)((Object)phase));
                this.postHooks.computeIfAbsent(phase, Builder::newArrayList).add(hook);
            }
            return this;
        }

        public Builder addTaskWrapperFactory(Phase phase, UnaryOperator<BiConsumer<Consumer<CompilationContext>, CompilationContext>> factory) {
            if (factory != null) {
                Assert.checkNotNullParam((String)"phase", (Object)((Object)phase));
                this.taskWrapperFactories.computeIfAbsent(phase, Builder::newArrayList).add(factory);
            }
            return this;
        }

        public Path getOutputDirectory() {
            return this.outputDirectory;
        }

        public Builder setOutputDirectory(Path outputDirectory) {
            this.outputDirectory = (Path)Assert.checkNotNullParam((String)"outputDirectory", (Object)outputDirectory);
            return this;
        }

        public Platform getTargetPlatform() {
            return this.targetPlatform;
        }

        public Builder setTargetPlatform(Platform targetPlatform) {
            this.targetPlatform = targetPlatform;
            return this;
        }

        public TypeSystem getTypeSystem() {
            return this.typeSystem;
        }

        public Builder setTypeSystem(TypeSystem typeSystem) {
            this.typeSystem = typeSystem;
            return this;
        }

        public Function<CompilationContext, Vm> getVmFactory() {
            return this.vmFactory;
        }

        public Builder setVmFactory(Function<CompilationContext, Vm> vmFactory) {
            this.vmFactory = vmFactory;
            return this;
        }

        public CToolChain getToolChain() {
            return this.toolChain;
        }

        public Builder setToolChain(CToolChain toolChain) {
            this.toolChain = toolChain;
            return this;
        }

        public LlvmToolChain getLlvmToolChain() {
            return this.llvmToolChain;
        }

        public Builder setLlvmToolChain(LlvmToolChain llvmToolChain) {
            this.llvmToolChain = llvmToolChain;
            return this;
        }

        public ObjectFileProvider getObjectFileProvider() {
            return this.objectFileProvider;
        }

        public Builder setObjectFileProvider(ObjectFileProvider objectFileProvider) {
            this.objectFileProvider = objectFileProvider;
            return this;
        }

        public float getThreadsPerCpu() {
            return this.threadsPerCpu;
        }

        public Builder setThreadsPerCpu(float threadsPerCpu) {
            Assert.checkMinimumParameter((String)"threadsPerCpu", (float)0.0f, (float)threadsPerCpu);
            this.threadsPerCpu = threadsPerCpu;
            return this;
        }

        public long getStackSize() {
            return this.stackSize;
        }

        public Builder setStackSize(long stackSize) {
            Assert.checkMinimumParameter((String)"stackSize", (long)0x100000L, (long)stackSize);
            this.stackSize = stackSize;
            return this;
        }

        public Builder addNativeMethodConfiguratorFactory(UnaryOperator<NativeMethodConfigurator> factory) {
            Assert.checkNotNullParam((String)"factory", factory);
            this.nativeMethodConfiguratorFactories.add(factory);
            return this;
        }

        public Builder setClassContextListener(Consumer<ClassContext> classContextListener) {
            this.classContextListener = (Consumer)Assert.checkNotNullParam((String)"classContextListener", classContextListener);
            return this;
        }

        public Driver build() {
            return new Driver(this);
        }
    }

    record BootModule(ClassPathItem item, ModuleDefinition moduleDefinition) implements Closeable
    {
        BootModule {
            Assert.checkNotNullParam((String)"item", (Object)item);
            Assert.checkNotNullParam((String)"moduleDefinition", (Object)moduleDefinition);
        }

        @Override
        public void close() {
            this.item.close();
        }
    }
}

