/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import java.util.function.Consumer;
import org.qbicc.context.CompilationContext;
import org.qbicc.interpreter.Thrown;
import org.qbicc.interpreter.Vm;
import org.qbicc.interpreter.VmClass;
import org.qbicc.interpreter.VmThrowable;
import org.qbicc.type.definition.element.ExecutableElement;
import org.qbicc.type.definition.element.InitializerElement;

public class ElementInitializer
implements Consumer<ExecutableElement> {
    @Override
    public void accept(ExecutableElement element) {
        if (element instanceof InitializerElement && element.hasNoModifiersOf(0x10000000) && element.hasMethodBody()) {
            Vm vm = Vm.requireCurrent();
            VmClass vmClass = element.getEnclosingType().load().getVmClass();
            try {
                vm.initialize(vmClass);
            }
            catch (Thrown thrown) {
                VmThrowable throwable = thrown.getThrowable();
                String className = throwable.getVmClass().getName();
                String message = throwable.getMessage();
                CompilationContext ctxt = vm.getCompilationContext();
                Object warningMessage = message != null ? String.format("Failed to initialize %s: %s: %s", vmClass.getName(), className, message) : String.format("Failed to initialize %s: %s", vmClass.getName(), className);
                for (VmThrowable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
                    message = cause.getMessage();
                    warningMessage = message != null ? (String)warningMessage + String.format(" caused by %s: %s", cause.getVmClass().getName(), message) : (String)warningMessage + String.format(" caused by %s", cause.getVmClass().getName());
                }
                ctxt.warning((String)warningMessage, new Object[0]);
            }
        }
    }
}

