/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import org.qbicc.driver.GraphGenFilter;
import org.qbicc.driver.Phase;
import org.qbicc.type.definition.element.Element;

public class GraphGenConfig {
    public static final String ALL_METHODS = "all";
    public static final String ALL_PHASES = "all";
    private static final HashSet<String> ALL_METHODS_SET = new HashSet();
    private EnumMap<Phase, HashSet<String>> phaseToMethodsMap = new EnumMap(Phase.class);
    private boolean enabled;

    public void addMethodAndPhase(String method, String phaseString) {
        ArrayList<Phase> phaseList = new ArrayList<Phase>();
        if (phaseString.equalsIgnoreCase("all")) {
            phaseList.addAll(Arrays.asList(Phase.values()));
        } else {
            phaseList.add(Phase.getPhase(phaseString));
        }
        for (Phase p : phaseList) {
            if (method.equalsIgnoreCase("all")) {
                this.phaseToMethodsMap.compute(p, (k, v) -> ALL_METHODS_SET);
                continue;
            }
            StringBuilder internalName = new StringBuilder(method);
            int endOfPackage = internalName.lastIndexOf("/");
            if (endOfPackage != -1) {
                internalName = internalName.replace(endOfPackage, endOfPackage + 1, ".");
            }
            this.phaseToMethodsMap.computeIfAbsent(p, k -> new HashSet()).add(internalName.toString());
        }
    }

    public GraphGenFilter getFilter() {
        return new GraphGenOptionsFilter();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    class GraphGenOptionsFilter
    implements GraphGenFilter {
        GraphGenOptionsFilter() {
        }

        @Override
        public boolean accept(Element element, Phase phase) {
            HashSet<String> methodSet = GraphGenConfig.this.phaseToMethodsMap.get((Object)phase);
            if (methodSet != null) {
                if (methodSet == ALL_METHODS_SET) {
                    return true;
                }
                return methodSet.contains(element.toString());
            }
            return false;
        }
    }
}

