/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.qbicc.driver.ClassPathElement;
import org.qbicc.machine.vfs.VirtualFileSystem;
import org.qbicc.machine.vfs.VirtualPath;

final class JarFileClassPathElement
extends ClassPathElement {
    private final JarFile jarFile;

    JarFileClassPathElement(JarFile jarFile) {
        this.jarFile = jarFile;
    }

    @Override
    public String getName() {
        return this.jarFile.getName();
    }

    @Override
    public ClassPathElement.Resource getResource(String name) {
        JarEntry jarEntry = this.jarFile.getJarEntry(name);
        return jarEntry == null ? NON_EXISTENT : new Resource(jarEntry);
    }

    @Override
    public void mount(VirtualFileSystem vfs, VirtualPath mountPoint) throws IOException {
        Iterator<JarEntry> iterator = this.jarFile.entries().asIterator();
        while (iterator.hasNext()) {
            JarEntry ze = iterator.next();
            VirtualPath vp = mountPoint.resolve(ze.getRealName());
            if (ze.isDirectory()) {
                vfs.mkdirs(vp, 493);
                continue;
            }
            VirtualPath parent = vp.getParent();
            vfs.mkdirs(parent, 493);
            vfs.bindZipEntry(vp, (ZipFile)this.jarFile, (ZipEntry)ze, true);
        }
    }

    @Override
    public void close() throws IOException {
        this.jarFile.close();
    }

    final class Resource
    extends ClassPathElement.Resource {
        private final JarEntry entry;

        Resource(JarEntry entry) {
            this.entry = entry;
        }

        @Override
        public ByteBuffer getBuffer() throws IOException {
            try (InputStream inputStream = this.openStream();){
                ByteBuffer byteBuffer = ByteBuffer.wrap(inputStream.readAllBytes());
                return byteBuffer;
            }
        }

        @Override
        public InputStream openStream() throws IOException {
            return JarFileClassPathElement.this.jarFile.getInputStream(this.entry);
        }

        @Override
        public void close() {
        }
    }
}

