/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.driver;

import org.jboss.logging.Logger;
import org.jboss.logging.MDC;
import org.qbicc.context.CompilationContext;
import org.qbicc.context.PhaseAttachmentKey;

public enum Phase {
    ADD("add"),
    ANALYZE("analyze"),
    LOWER("lower"),
    GENERATE("generate");

    private static final Logger log;
    private final String phase;
    private static final PhaseAttachmentKey<Phase> KEY;

    private Phase(String phase) {
        this.phase = phase;
    }

    public String toString() {
        return this.phase;
    }

    public static Phase getPhase(String phase) {
        if (phase.equalsIgnoreCase("add")) {
            return ADD;
        }
        if (phase.equalsIgnoreCase("analyze")) {
            return ANALYZE;
        }
        if (phase.equalsIgnoreCase("lower")) {
            return LOWER;
        }
        return GENERATE;
    }

    public static Phase getPrevious(CompilationContext ctxt) {
        return (Phase)((Object)ctxt.getPreviousPhaseAttachment(KEY));
    }

    public static Phase getCurrent(CompilationContext ctxt) {
        return (Phase)((Object)ctxt.getAttachment(KEY));
    }

    void setCurrent(CompilationContext ctxt) {
        Phase.complete(ctxt);
        ctxt.putAttachment(KEY, (Object)this);
        MDC.put((String)"phase", (Object)this.name());
        ctxt.runParallelTask(context -> MDC.put((String)"phase", (Object)this.name()));
        log.info((Object)"Entering phase");
    }

    static void complete(CompilationContext ctxt) {
        if (ctxt.getPreviousPhaseAttachment(KEY) != null) {
            log.info((Object)"Phase complete");
        }
        MDC.remove((String)"phase");
    }

    static {
        log = Logger.getLogger((String)"org.qbicc.driver.phase");
        KEY = new PhaseAttachmentKey();
    }
}

