/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.arch;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.qbicc.machine.arch.ArmProfile;
import org.qbicc.machine.arch.Indexer;
import org.qbicc.machine.arch.PlatformComponent;

public final class ArmCpuArch
extends PlatformComponent {
    public static final ArmCpuArch V4 = new ArmCpuArch("v4", ArmProfile.Classic, new ArmCpuArch[0]);
    public static final ArmCpuArch V4T = new ArmCpuArch("v4t", ArmProfile.Classic, V4);
    public static final ArmCpuArch V5TE = new ArmCpuArch("v5te", ArmProfile.Classic, V4T);
    public static final ArmCpuArch V6 = new ArmCpuArch("v6", ArmProfile.Classic, V5TE);
    public static final ArmCpuArch V6_M = new ArmCpuArch("v6-m", ArmProfile.Microcontroller, V5TE);
    public static final ArmCpuArch V7 = new ArmCpuArch("v7", ArmProfile.Application, V6);
    public static final ArmCpuArch V7_M = new ArmCpuArch("v7-m", ArmProfile.Microcontroller, V6_M);
    public static final ArmCpuArch V7E_M = new ArmCpuArch("v7e-m", ArmProfile.Microcontroller, V7_M);
    public static final ArmCpuArch V7_R = new ArmCpuArch("v7-r", ArmProfile.RealTime, V6);
    private final Set<ArmCpuArch> incorporates;
    private final ArmProfile profile;
    private static final Map<String, ArmCpuArch> index = Indexer.index(ArmCpuArch.class);

    ArmCpuArch(String name, ArmProfile profile, ArmCpuArch ... incorporates) {
        super(name);
        this.profile = profile;
        this.incorporates = Set.of(incorporates);
    }

    public boolean incorporates(ArmCpuArch arch) {
        if (this == arch) {
            return true;
        }
        if (this.incorporates.contains(arch)) {
            return true;
        }
        for (ArmCpuArch incorporated : this.incorporates) {
            if (!incorporated.incorporates(arch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.profile == ArmProfile.Application || this.profile == ArmProfile.Classic) {
            return super.getName();
        }
        return super.getName() + "-" + Character.toLowerCase(this.profile.getLetter());
    }

    public ArmProfile getProfile() {
        return this.profile;
    }

    public static ArmCpuArch forName(String name) {
        return index.get(name.toLowerCase(Locale.ROOT));
    }

    public static Set<String> getNames() {
        return index.keySet();
    }
}

