/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.arch;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qbicc.machine.arch.PlatformComponent;

final class Indexer {
    private Indexer() {
    }

    static <T extends PlatformComponent> Map<String, T> index(Class<T> clazz) {
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, PlatformComponent> map = new HashMap<String, PlatformComponent>();
        for (Field field : fields) {
            PlatformComponent item;
            int mods = field.getModifiers();
            if (!Modifier.isStatic(mods) || !Modifier.isFinal(mods) || !Modifier.isPublic(mods) || !clazz.isAssignableFrom(field.getType())) continue;
            try {
                item = (PlatformComponent)clazz.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalAccessError(e.getMessage());
            }
            map.put(item.getName(), item);
            for (String alias : item.getAliases()) {
                map.put(alias, item);
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

