/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.arch;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.qbicc.machine.arch.ABI;
import org.qbicc.machine.arch.ArmCpu;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.Indexer;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.arch.PlatformComponent;

public final class OS
extends PlatformComponent {
    public static final OS UNKNOWN = new OS("unknown", ABI.UNKNOWN, ObjectType.UNKNOWN, new String[0]);
    public static final OS NONE = new OS("none", ABI.UNKNOWN, ObjectType.UNKNOWN, new String[0]);
    public static final OS LINUX = new OS("linux", ABI.GNU, ObjectType.ELF, new String[0]);
    public static final OS WIN32 = new OS("win32", "\\", ";", "\r\n", ABI.WIN32, ObjectType.COFF, "windows", "windows32");
    public static final OS DARWIN = new OS("darwin", ABI.UNKNOWN, ObjectType.MACH_O, "mac os x");
    public static final OS WASI = new OS("wasi", ABI.UNKNOWN, ObjectType.WASM, "wasm");
    private final ABI defaultAbi;
    private final ObjectType defaultObjectType;
    private final String fileSeparator;
    private final String pathSeparator;
    private final String lineSeparator;
    private static final Map<String, OS> index = Indexer.index(OS.class);

    OS(String name, ABI defaultAbi, ObjectType defaultObjectType, String ... aliases) {
        this(name, "/", ":", "\n", defaultAbi, defaultObjectType, aliases);
    }

    OS(String name, String fileSeparator, String pathSeparator, String lineSeparator, ABI defaultAbi, ObjectType defaultObjectType, String ... aliases) {
        super(name, aliases);
        this.defaultAbi = defaultAbi;
        this.defaultObjectType = defaultObjectType;
        this.fileSeparator = fileSeparator;
        this.pathSeparator = pathSeparator;
        this.lineSeparator = lineSeparator;
    }

    public ABI getDefaultAbi(Cpu cpu) {
        return cpu instanceof ArmCpu && this == LINUX ? ABI.GNUEABI : this.defaultAbi;
    }

    public ObjectType getDefaultObjectType(Cpu cpu) {
        return this.defaultObjectType;
    }

    public static OS forName(String name) {
        return index.getOrDefault(name.toLowerCase(Locale.ROOT), UNKNOWN);
    }

    public static Set<String> getNames() {
        return index.keySet();
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }
}

