/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.arch;

import io.smallrye.common.constraint.Assert;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qbicc.machine.arch.ABI;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.OS;
import org.qbicc.machine.arch.ObjectType;

public final class Platform {
    private final Cpu cpu;
    private final OS os;
    private final ABI abi;
    private final ObjectType objectType;
    private final int hashCode;
    private static final Pattern PLATFORM_PATTERN;
    public static final Platform HOST_PLATFORM;

    public Platform(Cpu cpu, OS os, ABI abi, ObjectType objectType) {
        this.cpu = (Cpu)Assert.checkNotNullParam((String)"cpu", (Object)cpu);
        this.os = (OS)Assert.checkNotNullParam((String)"os", (Object)os);
        this.abi = (ABI)Assert.checkNotNullParam((String)"abi", (Object)abi);
        this.objectType = (ObjectType)Assert.checkNotNullParam((String)"objectType", (Object)objectType);
        this.hashCode = Objects.hash(cpu, os, abi, objectType);
    }

    public Platform(Cpu cpu, OS os, ABI abi) {
        this(cpu, os, abi, os.getDefaultObjectType(cpu));
    }

    public Platform(Cpu cpu, OS os) {
        this(cpu, os, os.getDefaultAbi(cpu));
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public OS getOs() {
        return this.os;
    }

    public ABI getAbi() {
        return this.abi;
    }

    public boolean isWasm() {
        return this.cpu == Cpu.WASM32;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String toString() {
        return this.cpu.getSimpleName() + "-" + this.os + "-" + this.abi + "-" + this.objectType;
    }

    public String formatSectionName(String segmentName, String ... simpleNameParts) {
        return this.objectType.formatSectionName(segmentName, simpleNameParts);
    }

    public String formatStartOfSectionSymbolName(String segmentName, String simpleName) {
        return this.objectType.formatStartOfSectionSymbolName(segmentName, simpleName);
    }

    public String formatEndOfSectionSymbolName(String segmentName, String simpleName) {
        return this.objectType.formatEndOfSectionSymbolName(segmentName, simpleName);
    }

    public boolean isSupersetOf(Platform other) {
        return this.cpu.incorporates(other.cpu) && this.os.equals(other.os) && this.abi.equals(other.abi);
    }

    public boolean equals(Object obj) {
        return obj instanceof Platform && this.equals((Platform)obj);
    }

    public boolean equals(Platform obj) {
        return obj == this || obj != null && this.cpu.equals(obj.cpu) && this.os.equals(obj.os) && this.abi.equals(obj.abi);
    }

    private static void appendNameAlt(StringBuilder b, Iterator<String> iterator) {
        if (iterator.hasNext()) {
            String name = iterator.next();
            b.append(Pattern.quote(name));
            while (iterator.hasNext()) {
                b.append('|');
                name = iterator.next();
                b.append(Pattern.quote(name));
            }
        }
    }

    public static Platform parse(String platformString) throws IllegalArgumentException {
        Matcher matcher = PLATFORM_PATTERN.matcher(platformString);
        if (matcher.matches()) {
            String cpu = matcher.group(1);
            String os = matcher.group(2);
            String abi = matcher.group(3);
            if (abi == null) {
                return new Platform(Cpu.forName(cpu), OS.forName(os));
            }
            return new Platform(Cpu.forName(cpu), OS.forName(os), ABI.forName(abi));
        }
        throw new IllegalArgumentException("Invalid platform string (expected \"cpuname-osname[-abiname]\"");
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static Platform detectHostPlatform() {
        String osName = System.getProperty("os.name", "unknown");
        String cpuName = System.getProperty("os.arch", "unknown");
        return new Platform(Cpu.forName(cpuName), OS.forName(osName));
    }

    static {
        StringBuilder b = new StringBuilder(256);
        b.append('(');
        Iterator<String> iterator = Cpu.getNames().iterator();
        Platform.appendNameAlt(b, iterator);
        b.append(')').append('-');
        b.append('(');
        iterator = OS.getNames().iterator();
        Platform.appendNameAlt(b, iterator);
        b.append(')');
        b.append("(?:");
        b.append('-');
        b.append('(');
        iterator = ABI.getNames().iterator();
        Platform.appendNameAlt(b, iterator);
        b.append(')').append(')').append('?');
        PLATFORM_PATTERN = Pattern.compile(b.toString());
        HOST_PLATFORM = Platform.detectHostPlatform();
    }
}

