/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.bin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import org.qbicc.machine.file.bin.BinaryBuffer;

public final class ArrayBinaryBuffer
implements BinaryBuffer {
    private static final int OUTER_BITS = 13;
    private static final int INNER_SIZE = 8192;
    private static final int INNER_MASK = 8191;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private long size;
    private byte[][] arrays;

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    @Override
    public ByteOrder setByteOrder(ByteOrder newOrder) {
        ByteOrder oldOrder = this.byteOrder;
        this.byteOrder = newOrder;
        return oldOrder;
    }

    private byte[] getOrCreate(long position) {
        int outerIdx = Math.toIntExact(position >> 13);
        Object arrays = this.arrays;
        if (arrays == null) {
            byte[][] byArrayArray = new byte[Math.max(8, outerIdx)][];
            arrays = byArrayArray;
            this.arrays = byArrayArray;
        }
        return arrays[outerIdx];
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long growBy(long amount) {
        this.getOrCreate(this.size + amount - 1L);
        return this.size;
    }

    @Override
    public void growTo(long newSize) {
        this.getOrCreate(newSize - 1L);
    }

    @Override
    public int getInt(long offset) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return this.getShortUnsigned(offset) | this.getShortUnsigned(offset + 2L) << 16;
        }
        return this.getShortUnsigned(offset) << 16 | this.getShortUnsigned(offset + 2L);
    }

    @Override
    public void putInt(long offset, int value) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putShort(offset, (short)value);
            this.putShort(offset + 2L, value >>> 16);
        } else {
            this.putShort(offset, value >>> 16);
            this.putShort(offset + 2L, (short)value);
        }
    }

    @Override
    public short getShort(long offset) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return (short)(this.getByteUnsigned(offset) | this.getByteUnsigned(offset + 1L) << 8);
        }
        return (short)(this.getByteUnsigned(offset) << 8 | this.getByteUnsigned(offset + 1L));
    }

    @Override
    public void putShort(long offset, short value) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putByte(offset, (byte)value);
            this.putByte(offset + 1L, value >>> 8);
        } else {
            this.putByte(offset, value >>> 8);
            this.putByte(offset + 1L, (byte)value);
        }
    }

    @Override
    public byte getByte(long offset) {
        return this.getOrCreate(offset)[(int)(offset & 0x1FFFL)];
    }

    @Override
    public void putByte(long offset, byte value) {
        this.getOrCreate((long)offset)[(int)(offset & 0x1FFFL)] = value;
        if (offset >= this.size) {
            this.size = offset + 1L;
        }
    }

    @Override
    public long getLong(long offset) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            return this.getIntUnsigned(offset) | this.getIntUnsigned(offset + 4L) << 32;
        }
        return this.getIntUnsigned(offset) << 32 | this.getIntUnsigned(offset + 2L);
    }

    @Override
    public void putLong(long offset, long value) {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            this.putInt(offset, (int)value);
            this.putInt(offset + 4L, value >>> 32);
        } else {
            this.putInt(offset, value >>> 32);
            this.putInt(offset + 4L, (int)value);
        }
    }

    @Override
    public void getBytes(long offset, byte[] b, int off, int len) {
        while (len > 0) {
            byte[] src = this.getOrCreate(offset);
            int srcOffs = len & 0x1FFF;
            int cnt = Math.min(len, 8192 - srcOffs);
            System.arraycopy(src, srcOffs, b, off, cnt);
            off += cnt;
            len -= cnt;
            offset += (long)cnt;
        }
    }

    @Override
    public void putBytes(long offset, byte[] b, int off, int len) {
        while (len > 0) {
            byte[] dst = this.getOrCreate(offset);
            int dstOffs = len & 0x1FFF;
            int cnt = Math.min(len, 8192 - dstOffs);
            System.arraycopy(b, off, dst, dstOffs, cnt);
            off += cnt;
            len -= cnt;
            offset += (long)cnt;
        }
    }

    @Override
    public void putBytes(long position, BinaryBuffer buf, long offset, long size) {
        while (size > 0L) {
            byte[] dst = this.getOrCreate(offset);
            int cnt = (int)Math.min(size, 8192L - offset);
            buf.getBytes(offset, dst, 0, cnt);
            size -= (long)cnt;
            position += (long)cnt;
            offset += (long)cnt;
        }
    }

    @Override
    public void writeTo(long offset, ByteBuffer byteBuffer) {
        int rem;
        while ((rem = byteBuffer.remaining()) > 0) {
            byte[] src = this.getOrCreate(offset);
            int io = (int)(offset & 0x1FFFL);
            byteBuffer.put(src, io, Math.min(rem, 8192 - io));
        }
    }

    @Override
    public void writeTo(GatheringByteChannel channel) throws IOException {
        this.writeTo(channel, 0L, this.size());
    }

    @Override
    public void writeTo(GatheringByteChannel fc, long offset, long cnt) throws IOException {
        while (cnt > 0L) {
            byte[] b = this.getOrCreate(offset);
            int wcnt = (int)(offset & 0x1FFFL);
            fc.write(ByteBuffer.wrap(b, 0, wcnt));
            offset += (long)wcnt;
            cnt -= (long)wcnt;
        }
    }

    @Override
    public ByteBuffer getBuffer(long offset, long size) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
    }
}

