/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.bin;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.qbicc.machine.file.bin.BufferBinaryBuffer;
import org.qbicc.machine.file.bin.MappedBinaryBuffer;
import org.qbicc.machine.file.bin.Utils;

public interface BinaryBuffer
extends AutoCloseable {
    public static BinaryBuffer openRead(Path path) throws IOException {
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            long s = channel.size();
            if (s > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Large files not yet supported");
            }
            BinaryBuffer binaryBuffer = BinaryBuffer.overBuffer(channel.map(FileChannel.MapMode.READ_ONLY, 0L, s));
            return binaryBuffer;
        }
    }

    public static BinaryBuffer overBuffer(ByteBuffer buf) {
        if (buf instanceof MappedByteBuffer) {
            return BinaryBuffer.overBuffer((MappedByteBuffer)buf);
        }
        return new BufferBinaryBuffer(buf);
    }

    public static BinaryBuffer overBuffer(MappedByteBuffer buf) {
        return new MappedBinaryBuffer(buf);
    }

    public ByteOrder getByteOrder();

    public ByteOrder setByteOrder(ByteOrder var1);

    public long size();

    public long growBy(long var1);

    public void growTo(long var1);

    public int getInt(long var1);

    default public long getIntUnsigned(long offset) {
        return (long)this.getInt(offset) & 0xFFFFFFFFL;
    }

    public void putInt(long var1, int var3);

    default public void putInt(long offset, long value) {
        Utils.rangeCheck32(value);
        this.putInt(offset, (int)value);
    }

    public short getShort(long var1);

    default public int getShortUnsigned(long offset) {
        return this.getShort(offset) & 0xFFFF;
    }

    public void putShort(long var1, short var3);

    default public void putShort(long offset, int value) {
        Utils.rangeCheck16(value);
        this.putShort(offset, (short)value);
    }

    default public void putShort(long offset, long value) {
        Utils.rangeCheck16(value);
        this.putShort(offset, (short)value);
    }

    public byte getByte(long var1);

    default public short getByteUnsigned(long offset) {
        return (short)(this.getByte(offset) & 0xFF);
    }

    public void putByte(long var1, byte var3);

    default public void putByte(long offset, int value) {
        Utils.rangeCheck8(value);
        this.putByte(offset, (byte)value);
    }

    default public void putByte(long offset, long value) {
        Utils.rangeCheck8(value);
        this.putByte(offset, (byte)value);
    }

    public long getLong(long var1);

    public void putLong(long var1, long var3);

    public void getBytes(long var1, byte[] var3, int var4, int var5);

    default public void getBytes(long offset, byte[] b) {
        this.getBytes(offset, b, 0, b.length);
    }

    public void putBytes(long var1, byte[] var3, int var4, int var5);

    default public void putBytes(long offset, byte[] b) {
        this.putBytes(offset, b, 0, b.length);
    }

    public void putBytes(long var1, BinaryBuffer var3, long var4, long var6);

    default public WritingIterator writingIterator(long position) {
        return new WritingIterator(this, position, false);
    }

    default public WritingIterator appendingIterator() {
        return new WritingIterator(this, this.size(), true);
    }

    default public ReadingIterator readingIterator(long position) {
        return new ReadingIterator(this, position);
    }

    public void writeTo(long var1, ByteBuffer var3);

    public void writeTo(GatheringByteChannel var1) throws IOException;

    @Override
    public void close();

    public void writeTo(GatheringByteChannel var1, long var2, long var4) throws IOException;

    public ByteBuffer getBuffer(long var1, long var3);

    public static final class WritingIterator
    extends BufferIterator {
        private final boolean appending;

        WritingIterator(BinaryBuffer backingBuffer, long position, boolean appending) {
            super(backingBuffer, position);
            this.appending = appending;
        }

        public boolean isAppending() {
            return this.appending;
        }

        public void putByte(long value) {
            long position = this.position;
            this.backingBuffer.putByte(position, value);
            this.position = position + 1L;
        }

        public void putByte(int value) {
            long position = this.position;
            this.backingBuffer.putByte(position, value);
            this.position = position + 1L;
        }

        public void putByte(byte value) {
            long position = this.position;
            this.backingBuffer.putByte(position, value);
            this.position = position + 1L;
        }

        public void putShort(long value) {
            long position = this.position;
            this.backingBuffer.putShort(position, value);
            this.position = position + 2L;
        }

        public void putShort(int value) {
            long position = this.position;
            this.backingBuffer.putShort(position, value);
            this.position = position + 2L;
        }

        public void putShort(short value) {
            long position = this.position;
            this.backingBuffer.putShort(position, value);
            this.position = position + 2L;
        }

        public void putInt(int value) {
            long position = this.position;
            this.backingBuffer.putInt(position, value);
            this.position = position + 4L;
        }

        public void putInt(long value) {
            long position = this.position;
            this.backingBuffer.putInt(position, value);
            this.position = position + 4L;
        }

        public void putLong(long value) {
            long position = this.position;
            this.backingBuffer.putLong(position, value);
            this.position = position + 8L;
        }

        public void putBytes(byte[] b, int off, int len) {
            long position = this.position;
            this.backingBuffer.putBytes(position, b, off, len);
            this.position = position + (long)len;
        }

        public void putBytes(byte[] b) {
            this.putBytes(b, 0, b.length);
        }

        public void putBytes(BinaryBuffer buf, long pos, long size) {
            long position = this.position;
            this.backingBuffer.putBytes(position, buf, pos, size);
            this.position = position + size;
        }

        public void putCodePoint(int codePoint, boolean encodeZero) {
            long position = this.position;
            BinaryBuffer bb = this.backingBuffer;
            if (codePoint == 0 && !encodeZero || 0 < codePoint && codePoint < 128) {
                bb.putByte(position, codePoint);
                this.position = position + 1L;
            } else if (codePoint < 2048) {
                bb.putByte(position + 1L, codePoint & 0x3F | 0x80);
                bb.putByte(position, codePoint >>> 6 | 0xC0);
                this.position = position + 2L;
            } else if (codePoint < 65536) {
                bb.putByte(position + 2L, codePoint & 0x3F | 0x80);
                bb.putByte(position + 1L, codePoint >>> 6 & 0x3F | 0x80);
                bb.putByte(position, codePoint >>> 12 | 0xE0);
                this.position = position + 3L;
            } else if (codePoint < 0x110000) {
                bb.putByte(position + 3L, codePoint & 0x3F | 0x80);
                bb.putByte(position + 2L, codePoint >>> 6 & 0x3F | 0x80);
                bb.putByte(position + 1L, codePoint >>> 12 & 0x3F | 0x80);
                bb.putByte(position, codePoint >>> 18 | 0xF0);
                this.position = position + 4L;
            } else {
                this.putCodePoint(65533, false);
            }
        }

        @Override
        public void close() {
        }
    }

    public static final class ReadingIterator
    extends BufferIterator {
        ReadingIterator(BinaryBuffer backingBuffer, long position) {
            super(backingBuffer, position);
        }

        public byte getByte() {
            long position = this.position;
            byte val = this.backingBuffer.getByte(position);
            this.position = position + 1L;
            return val;
        }

        public byte peekByte() {
            return this.backingBuffer.getByte(this.position);
        }

        public short getByteUnsigned() {
            long position = this.position;
            short val = this.backingBuffer.getByteUnsigned(position);
            this.position = position + 1L;
            return val;
        }

        public short peekByteUnsigned() {
            return this.backingBuffer.getByteUnsigned(this.position);
        }

        public short getShort() {
            long position = this.position;
            short val = this.backingBuffer.getShort(position);
            this.position = position + 1L;
            return val;
        }

        public short peekShort() {
            return this.backingBuffer.getShort(this.position);
        }

        public int getShortUnsigned() {
            long position = this.position;
            int val = this.backingBuffer.getShortUnsigned(position);
            this.position = position + 1L;
            return val;
        }

        public int peekShortUnsigned() {
            return this.backingBuffer.getShortUnsigned(this.position);
        }

        public int getInt() {
            long position = this.position;
            int val = this.backingBuffer.getInt(position);
            this.position = position + 1L;
            return val;
        }

        public int peekInt() {
            return this.backingBuffer.getInt(this.position);
        }

        public long getIntUnsigned() {
            long position = this.position;
            long val = this.backingBuffer.getIntUnsigned(position);
            this.position = position + 1L;
            return val;
        }

        public long peekIntUnsigned() {
            return this.backingBuffer.getIntUnsigned(this.position);
        }

        public long getLong() {
            long position = this.position;
            long val = this.backingBuffer.getLong(position);
            this.position = position + 1L;
            return val;
        }

        public long peekLong() {
            return this.backingBuffer.getLong(this.position);
        }

        public void getBytes(byte[] b, int off, int len) {
            long position = this.position;
            this.backingBuffer.getBytes(position, b, off, len);
            this.position = position + (long)len;
        }

        public void getBytes(byte[] b) {
            this.getBytes(b, 0, b.length);
        }

        public int getCodePoint() {
            BinaryBuffer bb = this.backingBuffer;
            long position = this.position;
            short a = bb.getByteUnsigned(position);
            if (a < 128) {
                this.position = position + 1L;
                return a;
            }
            if (a < 192 || 248 <= a) {
                this.position = position + 1L;
                return 65533;
            }
            short b = bb.getByteUnsigned(position + 1L);
            if (b < 192 || 224 <= b) {
                this.position = position + 1L;
                return 65533;
            }
            if (a < 224) {
                this.position = position + 2L;
                return (a & 0x1F) << 6 | b & 0x3F;
            }
            short c = bb.getByteUnsigned(position + 2L);
            if (c < 192 || 224 <= c) {
                this.position = position + 1L;
                return 65533;
            }
            if (a < 240) {
                this.position = position + 3L;
                return (a & 0xF) << 12 | (b & 0x3F) << 6 | c & 0x3F;
            }
            short d = bb.getByteUnsigned(position + 3L);
            if (d < 192 || 224 <= d) {
                this.position = position + 1L;
                return 65533;
            }
            this.position = position + 4L;
            return (a & 7) << 18 | (b & 0x3F) << 12 | (c & 0x3F) << 6 | d & 0x3F;
        }

        @Override
        public void close() {
        }
    }

    public static abstract class BufferIterator
    implements AutoCloseable {
        final BinaryBuffer backingBuffer;
        long position;

        BufferIterator(BinaryBuffer backingBuffer, long position) {
            this.backingBuffer = backingBuffer;
            this.position = position;
        }

        public BinaryBuffer getBackingBuffer() {
            return this.backingBuffer;
        }

        public long position() {
            return this.position;
        }

        @Override
        public abstract void close();

        public void skip(long count) {
            this.position += count;
        }

        public void alignTo(int alignment) {
            if (Integer.bitCount(alignment) != 1) {
                throw new IllegalArgumentException("Invalid alignment");
            }
            int mask = alignment - 1;
            int offs = (int)(this.position & (long)mask);
            if (offs > 0) {
                this.skip(mask - offs + 1);
            }
        }
    }
}

