/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.bin;

public final class Utils {
    private Utils() {
    }

    public static void rangeCheck32(long value) {
        if (value > 0xFFFFFFFFL || value < Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Value is out of range for a 32-bit number: 0x" + Long.toHexString(value));
        }
    }

    public static void rangeCheck16(long value) {
        if (value > 65535L || value < -32768L) {
            throw new IllegalArgumentException("Value is out of range for a 16-bit number: 0x" + Long.toHexString(value));
        }
    }

    public static void rangeCheck16(int value) {
        if (value > 65535 || value < Short.MIN_VALUE) {
            throw new IllegalArgumentException("Value is out of range for a 16-bit number: 0x" + Integer.toHexString(value));
        }
    }

    public static void rangeCheck8(long value) {
        if (value > 255L || value < -128L) {
            throw new IllegalArgumentException("Value is out of range for an 8-bit number: 0x" + Long.toHexString(value));
        }
    }

    public static void rangeCheck8(int value) {
        if (value > 255 || value < -128) {
            throw new IllegalArgumentException("Value is out of range for an 8-bit number: 0x" + Integer.toHexString(value));
        }
    }
}

