/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import java.nio.ByteOrder;
import java.util.Objects;
import org.qbicc.machine.arch.Cpu;

public final class Elf {
    private Elf() {
    }

    static <T extends NumericEnumeration & Comparable<T>> T binarySearch(int value, T[] sortedItems) {
        int low = 0;
        int high = sortedItems.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T item = sortedItems[mid];
            int val = item.getValue();
            if (val < value) {
                low = mid + 1;
                continue;
            }
            if (val > value) {
                high = mid - 1;
                continue;
            }
            return item;
        }
        return null;
    }

    public static interface NumericEnumeration {
        public int getValue();
    }

    public static final class Symbol {
        private Symbol() {
        }

        public static interface Visibility
        extends NumericEnumeration {
            public static Visibility forValue(int value) {
                Std visibility = Std.forValue(value);
                return visibility == null ? Visibility.unknown(value) : visibility;
            }

            public static Visibility unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Visibility
            {
                DEFAULT(0),
                INTERNAL(1),
                HIDDEN(2),
                PROTECTED(3);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }
        }

        public static interface Type
        extends NumericEnumeration {
            public static Type forValue(int value) {
                Std type = Std.forValue(value);
                return type == null ? Type.unknown(value) : type;
            }

            public static Type unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Type
            {
                NO_TYPE(0),
                OBJECT(1),
                FUNC(2),
                SECTION(3),
                FILE(4),
                COMMON(5),
                TLS(6);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }
        }

        public static interface Binding
        extends NumericEnumeration {
            public static Binding forValue(int value) {
                Enum binding = Std.forValue(value);
                if (binding == null) {
                    binding = Gnu.forValue(value);
                }
                return binding == null ? Binding.unknown(value) : binding;
            }

            public static Binding unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Binding
            {
                LOCAL(0),
                GLOBAL(1),
                WEAK(2);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }

            public static enum Gnu implements Binding
            {
                UNIQUE(10);

                private static final Gnu[] VALUES;
                private final int value;

                public static Gnu forValue(int value) {
                    return (Gnu)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Gnu(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Gnu.values();
                }
            }
        }
    }

    public static final class Section {
        private Section() {
        }

        public static interface Flag
        extends NumericEnumeration {
            public static final int OS_SPECIFIC = 20;
            public static final int CPU_SPECIFIC = 28;

            public static Flag forValue(int value) {
                Std type = Std.forValue(value);
                return type == null ? Flag.unknown(value) : type;
            }

            public static Flag unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Flag
            {
                WRITE(0),
                ALLOC(1),
                EXEC_INSTR(2),
                MERGE(4),
                STRINGS(5),
                INFO_LINK(6),
                LINK_ORDER(7),
                OS_NONCONFORMING(8),
                GROUP(9),
                TLS(10),
                COMPRESSED(11);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }

            public static enum Arm implements Flag
            {
                PURE_CODE(28);

                private static final Arm[] VALUES;
                private final int value;

                public static Arm forValue(int value) {
                    return (Arm)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Arm(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Arm.values();
                }
            }
        }

        public static interface Type
        extends NumericEnumeration {
            public static Type forValue(int value) {
                Std type = Std.forValue(value);
                return type == null ? Type.unknown(value) : type;
            }

            public static Type unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Type
            {
                NULL(0),
                PROG_BITS(1),
                SYM_TAB(2),
                STR_TAB(3),
                REL_A(4),
                HASH(5),
                DYNAMIC(6),
                NOTE(7),
                NO_BITS(8),
                REL(9),
                SHLIB(10),
                DYN_SYM(11),
                INIT_ARRAY(14),
                FINI_ARRAY(15),
                PREINIT_ARRAY(16),
                GROUP(17),
                SYM_TAB_SHNDX(18),
                NUM(19);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }

            public static enum Arm implements Type
            {
                EX_IDX(0x70000001),
                PREEMPT_MAP(0x70000002),
                ATTRIBUTES(0x70000003),
                DEBUG_OVERLAY(0x70000004),
                OVERLAY_SECTION(0x70000005);

                private static final Arm[] VALUES;
                private final int value;

                public static Arm forValue(int value) {
                    return (Arm)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Arm(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Arm.values();
                }
            }

            public static enum Sun implements Type
            {
                MOVE(0x6FFFFFFA),
                COM_DAT(0x6FFFFFFB),
                SYM_INFO(0x6FFFFFFC);

                private static final Sun[] VALUES;
                private final int value;

                public static Sun forValue(int value) {
                    return (Sun)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Sun(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Sun.values();
                }
            }

            public static enum Gnu implements Type
            {
                ATTRIBUTES(0x6FFFFFF5),
                HASH(0x6FFFFFF6),
                LIB_LIST(0x6FFFFFF7),
                CHECKSUM(0x6FFFFFF8),
                VERSION_DEF(0x6FFFFFFD),
                VERSION_NEEDS(0x6FFFFFFE),
                VERSION_SYM(0x6FFFFFFF);

                private static final Gnu[] VALUES;
                private final int value;

                public static Gnu forValue(int value) {
                    return (Gnu)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Gnu(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Gnu.values();
                }
            }
        }

        public static final class Index {
            public static final int UNDEF = 0;
            public static final int ABSOLUTE = 65521;
            public static final int COMMON = 65522;
            public static final int EXTENDED = 65535;

            private Index() {
            }
        }
    }

    public static final class Relocation {
        private Relocation() {
        }

        public static interface Type
        extends NumericEnumeration {
            public static Type unknown(int value) {
                return () -> value;
            }

            public static enum Arm implements Type
            {
                NONE(0),
                PC24(1),
                ABS32(2),
                REL32(3),
                LDR_PC_G0(4),
                ABS16(5),
                ABS12(6),
                THM_ABS5(7),
                ABS8(8),
                SBREL32(9),
                THM_CALL(10),
                THM_PC8(11),
                BREL_ADJ(12),
                TLS_DESC(13),
                TLS_DTPMOD32(17),
                TLS_DTPOFF32(18),
                TLS_TPOFF32(19),
                COPY(20),
                GLOB_DAT(21),
                JUMP_SLOT(22),
                RELATIVE(23),
                GOTOFF32(24),
                BASE_PREL(25),
                GOT_BREL(26),
                PLT32(27),
                CALL(28),
                JUMP24(29),
                THM_JUMP24(30),
                BASE_ABS(31),
                LDR_SBREL_11_0_NC(35),
                ALU_SBREL_19_12_NC(36),
                ALU_SBREL_27_20_CK(37),
                TARGET1(38),
                SBREL31(39),
                V4BX(40),
                TARGET2(41),
                PREL31(42),
                MOVW_ABS_NC(43),
                MOVT_ABS(44),
                MOVW_PREL_NC(45),
                MOVT_PREL(46),
                THM_MOVW_ABS_NC(47),
                THM_MOVT_ABS(48),
                THM_MOVW_PREL_NC(49),
                THM_MOVT_PREL(50),
                THM_JUMP19(51),
                THM_JUMP6(52),
                THM_ALU_PREL_11_0(53),
                THM_PC12(54),
                ABS32_NOI(55),
                REL32_NOI(56),
                ALU_PC_G0_NC(57),
                ALU_PC_G0(58),
                ALU_PC_G1_NC(59),
                ALU_PC_G1(60),
                ALU_PC_G2(61),
                LDR_PC_G1(62),
                LDR_PC_G2(63),
                LDRS_PC_G0(64),
                LDRS_PC_G1(65),
                LDRS_PC_G2(66),
                LDC_PC_G0(67),
                LDC_PC_G1(68),
                LDC_PC_G2(69),
                ALU_SB_G0_NC(70),
                ALU_SB_G0(71),
                ALU_SB_G1_NC(72),
                ALU_SB_G1(73),
                ALU_SB_G2(74),
                LDR_SB_G0(75),
                LDR_SB_G1(76),
                LDR_SB_G2(77),
                LDRS_SB_G0(78),
                LDRS_SB_G1(79),
                LDRS_SB_G2(80),
                LDC_SB_G0(81),
                LDC_SB_G1(82),
                LDC_SB_G2(83),
                MOVW_BREL_NC(84),
                MOVT_BREL(85),
                MOVW_BREL(86),
                THM_MOVW_BREL_NC(87),
                THM_MOVT_BREL(88),
                THM_MOVW_BREL(89),
                TLS_GOTDESC(90),
                TLS_CALL(91),
                TLS_DESCSEQ(92),
                THM_TLS_CALL(93),
                PLT32_ABS(94),
                GOT_ABS(95),
                GOT_PREL(96),
                GOT_BREL12(97),
                GOTOFF12(98),
                GOTRELAX(99),
                GNU_VTENTRY(100),
                GNU_VTINHERIT(101),
                THM_JUMP11(102),
                THM_JUMP8(103),
                TLS_GD32(104),
                TLS_LDM32(105),
                TLS_LDO32(106),
                TLS_IE32(107),
                TLS_LE32(108),
                TLS_LDO12(109),
                TLS_LE12(110),
                TLS_IE12GP(111),
                THM_TLS_DESCSEQ16(129),
                THM_TLS_DESCSEQ32(130),
                THM_GOT_BREL12(131),
                THM_ALU_ABS_G0_NC(132),
                THM_ALU_ABS_G1_NC(133),
                THM_ALU_ABS_G2_NC(134),
                THM_ALU_ABS_G3(135),
                THM_BF16(136),
                THM_BF12(137),
                THM_BF18(138);

                private static final Arm[] VALUES;
                private final int value;

                public static Arm forValue(int value) {
                    return (Arm)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Arm(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Arm.values();
                }
            }
        }
    }

    public static final class Program {
        private Program() {
        }

        public static interface Type
        extends NumericEnumeration {
            public static Type forValue(int value) {
                Enum programType = Std.forValue(value);
                if (programType == null) {
                    programType = Gnu.forValue(value);
                }
                if (programType == null) {
                    programType = SunW.forValue(value);
                }
                return programType == null ? Type.unknown(value) : programType;
            }

            public static Type unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Type
            {
                NULL(0),
                LOAD(1),
                DYNAMIC(2),
                INTERP(3),
                NOTE(4),
                PHDR(6),
                TLS(7),
                NUM(8);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }

            public static enum Gnu implements Type
            {
                EH_FRAME(1685382480),
                STACK(1685382481),
                REL_RDONLY(105375058);

                private static final Gnu[] VALUES;
                private final int value;

                public static Gnu forValue(int value) {
                    return (Gnu)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Gnu(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Gnu.values();
                }
            }

            public static enum SunW implements Type
            {
                BSS(0x6FFFFFFA),
                STACK(0x6FFFFFFB);

                private static final SunW[] VALUES;
                private final int value;

                public static SunW forValue(int value) {
                    return (SunW)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private SunW(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = SunW.values();
                }
            }
        }

        public static interface Flag
        extends NumericEnumeration {
            public static Flag forValue(int value) {
                Std flag = Std.forValue(value);
                return flag == null ? Flag.unknown(value) : flag;
            }

            public static Flag unknown(int value) {
                return () -> value;
            }

            public static enum Std implements Flag
            {
                EXEC(1),
                WRITE(2),
                READ(3);

                private static final Std[] VALUES;
                private final int value;

                public static Std forValue(int value) {
                    return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
                }

                private Std(int value) {
                    this.value = value;
                }

                @Override
                public int getValue() {
                    return this.value;
                }

                static {
                    VALUES = Std.values();
                }
            }
        }
    }

    public static interface Machine
    extends NumericEnumeration {
        public static Machine forValue(int value) {
            Std machine = Std.forValue(value);
            return machine == null ? Machine.unknown(value) : machine;
        }

        public static Machine unknown(int value) {
            return () -> value;
        }

        default public long maskFlags(long original) {
            return original;
        }

        default public Flag decodeFlag(int value) {
            return Flag.unknown(value);
        }

        default public Section.Type decodeSectionType(int value) {
            return Section.Type.forValue(value);
        }

        default public Section.Flag decodeSectionFlag(int value) {
            return Section.Flag.forValue(value);
        }

        default public int getSpecificValue(long value) {
            return 0;
        }

        default public long mergeSpecificValue(long value, int specificValue) {
            return value;
        }

        default public Relocation.Type decodeRelocationType(int rawType) {
            return Relocation.Type.unknown(rawType);
        }

        default public Cpu toCpu() {
            return Cpu.UNKNOWN;
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         */
        public static enum Std implements Machine
        {
            NONE(0, Cpu.UNKNOWN),
            M32(1, Cpu.UNKNOWN),
            SPARC(2, Cpu.UNKNOWN),
            X86(3, Cpu.X86),
            _68K(4, Cpu.UNKNOWN),
            _88K(5, Cpu.UNKNOWN),
            IA_MCU(6, Cpu.UNKNOWN),
            _860(7, Cpu.UNKNOWN),
            MIPS(8, Cpu.UNKNOWN),
            S370(9, Cpu.UNKNOWN),
            MIPS_RS3_LE(10, Cpu.UNKNOWN),
            PARISC(15, Cpu.UNKNOWN),
            VPP500(17, Cpu.UNKNOWN),
            SPARC32PLUS(18, Cpu.UNKNOWN),
            _960(19, Cpu.UNKNOWN),
            PPC(20, Cpu.PPC32),
            PPC64(21, Cpu.PPC64),
            S390(22, Cpu.UNKNOWN),
            ARM(40, Cpu.ARM){

                @Override
                public long maskFlags(long original) {
                    return original & 0xFFFFFFL;
                }

                @Override
                public Flag decodeFlag(int value) {
                    return Flag.Arm.forValue(value);
                }

                @Override
                public Section.Type decodeSectionType(int value) {
                    Section.Type.Arm type = Section.Type.Arm.forValue(value);
                    return type == null ? super.decodeSectionType(value) : type;
                }

                @Override
                public Section.Flag decodeSectionFlag(int value) {
                    Section.Flag.Arm flag = Section.Flag.Arm.forValue(value);
                    return flag == null ? super.decodeSectionFlag(value) : flag;
                }

                @Override
                public Relocation.Type decodeRelocationType(int rawType) {
                    return Relocation.Type.Arm.forValue(rawType);
                }

                @Override
                public int getSpecificValue(long value) {
                    return (int)value >>> 24;
                }

                @Override
                public long mergeSpecificValue(long value, int specificValue) {
                    return (long)((specificValue & 0xFF) << 24) | value & 0xFFFFFFL;
                }
            }
            ,
            SUPER_H(42, Cpu.UNKNOWN),
            SPARCV9(43, Cpu.UNKNOWN),
            IA_64(50, Cpu.UNKNOWN),
            X86_64(62, Cpu.X86_64),
            OPENRISC(92, Cpu.UNKNOWN),
            AARCH64(183, Cpu.AARCH64),
            CUDA(190, Cpu.UNKNOWN),
            RISC_V(243, Cpu.UNKNOWN);

            private static final Std[] VALUES;
            private final int value;
            private final Cpu cpu;

            public static Std forValue(int value) {
                return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            @Override
            public Cpu toCpu() {
                return this.cpu;
            }

            private Std(int value, Cpu cpu) {
                this.value = value;
                this.cpu = cpu;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Std.values();
            }
        }
    }

    public static interface Type
    extends NumericEnumeration {
        public static Type forValue(int value) {
            Std type = Std.forValue(value);
            return type == null ? Type.unknown(value) : type;
        }

        public static Type unknown(int value) {
            return () -> value;
        }

        public static enum Std implements Type
        {
            NONE(0),
            REL(1),
            EXEC(2),
            DYN(3),
            CORE(4);

            private static final Std[] VALUES;
            private final int value;

            public static Std forValue(int value) {
                return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            private Std(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Std.values();
            }
        }
    }

    public static interface OsAbi
    extends NumericEnumeration {
        public static OsAbi forValue(int value) {
            Std osAbi = Std.forValue(value);
            return osAbi == null ? OsAbi.unknown(value) : osAbi;
        }

        public static OsAbi unknown(int value) {
            return () -> value;
        }

        public static enum Std implements OsAbi
        {
            SYSV(0),
            HPUX(1),
            NETBSD(2),
            LINUX(3),
            GNU_HURD(4),
            SOLARIS(6),
            AIX(7),
            IRIX(8),
            FREEBSD(9),
            TRU64(10),
            NOVELL_MODESTO(11),
            OPENBSD(12),
            OPENVMS(13),
            NONSTOP_KERNEL(14),
            AROS(15),
            FENIX_OS(16),
            CLOUDABI(17);

            private static final Std[] VALUES;
            private final int value;

            public static Std forValue(int value) {
                return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            private Std(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Std.values();
            }
        }
    }

    public static interface Data
    extends NumericEnumeration {
        default public ByteOrder byteOrder() {
            throw new IllegalArgumentException("No known byte order for elf data " + this);
        }

        public static Data forValue(int value) {
            Std elfData = Std.forValue(value);
            return elfData == null ? Data.unknown(value) : elfData;
        }

        public static Data forByteOrder(ByteOrder bo) {
            Objects.requireNonNull(bo);
            if (!1.$assertionsDisabled && bo != ByteOrder.BIG_ENDIAN && bo != ByteOrder.LITTLE_ENDIAN) {
                throw new AssertionError();
            }
            return bo == ByteOrder.BIG_ENDIAN ? Std.BE : Std.LE;
        }

        public static Data unknown(int value) {
            return () -> value;
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }

        public static enum Std implements Data
        {
            NONE(0),
            LE(1),
            BE(2);

            private static final Std[] VALUES;
            private final int value;

            public static Std forValue(int value) {
                return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            private Std(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            @Override
            public ByteOrder byteOrder() {
                return this == LE ? ByteOrder.LITTLE_ENDIAN : (this == BE ? ByteOrder.BIG_ENDIAN : Data.super.byteOrder());
            }

            static {
                VALUES = Std.values();
            }
        }
    }

    public static interface Class
    extends NumericEnumeration {
        public static Class forValue(int value) {
            Std elfClass = Std.forValue(value);
            return elfClass == null ? Class.unknown(value) : elfClass;
        }

        public static Class unknown(int value) {
            return () -> value;
        }

        public static enum Std implements Class
        {
            NONE(0),
            _32(1),
            _64(2);

            private static final Std[] VALUES;
            private final int value;

            public static Std forValue(int value) {
                return (Std)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            private Std(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Std.values();
            }
        }
    }

    public static interface Flag
    extends NumericEnumeration {
        public static Flag forValue(int value) {
            return Flag.unknown(value);
        }

        public static Flag unknown(int value) {
            return () -> value;
        }

        public static enum Arm implements Flag
        {
            REL_EXEC(0),
            HAS_ENTRY(1),
            INTERWORK(2),
            APCS_26(3),
            APCS_FLOAT(4),
            PIC(5),
            ALIGN8(6),
            NEW_ABI(7),
            OLD_ABI(8),
            SOFT_FLOAT(9),
            VFP_FLOAT(10),
            MAVERICK_FLOAT(11),
            LE8(22),
            BE8(23);

            private static final Arm[] VALUES;
            private final int value;

            public static Arm forValue(int value) {
                return (Arm)Elf.binarySearch((int)value, (NumericEnumeration[])VALUES);
            }

            private Arm(int value) {
                this.value = value;
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Arm.values();
            }
        }
    }
}

