/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.MappedBitSet;

public abstract class ElfProgramHeaderEntry {
    final BinaryBuffer backingBuffer;
    final long position;
    final MappedBitSet<Elf.Program.Flag> flags;

    ElfProgramHeaderEntry(BinaryBuffer backingBuffer, long position, MappedBitSet<Elf.Program.Flag> flags) {
        this.backingBuffer = backingBuffer;
        this.position = position;
        this.flags = flags;
    }

    public BinaryBuffer getBackingBuffer() {
        return this.backingBuffer;
    }

    public long getPosition() {
        return this.position;
    }

    public Elf.Program.Type getType() {
        return Elf.Program.Type.forValue(this.backingBuffer.getInt(this.position));
    }

    public void setType(Elf.Program.Type type) {
        this.backingBuffer.putInt(this.position, type.getValue());
    }

    public MappedBitSet<Elf.Program.Flag> getFlags() {
        return this.flags;
    }

    public abstract long getOffset();

    public abstract void setOffset(long var1);

    public abstract long getVirtualAddress();

    public abstract void setVirtualAddress(long var1);

    public abstract long getPhysicalAddress();

    public abstract void setPhysicalAddress(long var1);

    public abstract long getFileSize();

    public abstract void setFileSize(long var1);

    public abstract long getMemorySize();

    public abstract void setMemorySize(long var1);

    public abstract long getAlignment();

    public abstract int getEntrySize();

    public void setAlignment(long alignment) {
        if (alignment != 0L && Long.bitCount(alignment) != 1) {
            throw new IllegalArgumentException("Alignment value must be zero or have exactly one bit set");
        }
        this.setAlignmentUnchecked(alignment);
    }

    abstract void setAlignmentUnchecked(long var1);

    static final class _64
    extends ElfProgramHeaderEntry {
        _64(BinaryBuffer backingBuffer, long position) {
            super(backingBuffer, position, MappedBitSet.map32Bits(backingBuffer, position + 4L, Elf.Program.Flag.class, Elf.Program.Flag::forValue));
        }

        @Override
        public long getOffset() {
            return this.backingBuffer.getLong(this.position + 8L);
        }

        @Override
        public void setOffset(long offset) {
            this.backingBuffer.putLong(this.position + 8L, offset);
        }

        @Override
        public long getVirtualAddress() {
            return this.backingBuffer.getLong(this.position + 16L);
        }

        @Override
        public void setVirtualAddress(long vAddr) {
            this.backingBuffer.putLong(this.position + 16L, vAddr);
        }

        @Override
        public long getPhysicalAddress() {
            return this.backingBuffer.getLong(this.position + 24L);
        }

        @Override
        public void setPhysicalAddress(long pAddr) {
            this.backingBuffer.putLong(this.position + 24L, pAddr);
        }

        @Override
        public long getFileSize() {
            return this.backingBuffer.getLong(this.position + 32L);
        }

        @Override
        public void setFileSize(long size) {
            this.backingBuffer.putLong(this.position + 32L, size);
        }

        @Override
        public long getMemorySize() {
            return this.backingBuffer.getLong(this.position + 40L);
        }

        @Override
        public void setMemorySize(long size) {
            this.backingBuffer.putLong(this.position + 40L, size);
        }

        @Override
        public long getAlignment() {
            return this.backingBuffer.getLong(this.position + 48L);
        }

        @Override
        void setAlignmentUnchecked(long alignment) {
            this.backingBuffer.putLong(this.position + 48L, alignment);
        }

        @Override
        public int getEntrySize() {
            return 56;
        }
    }

    static final class _32
    extends ElfProgramHeaderEntry {
        _32(BinaryBuffer backingBuffer, long position) {
            super(backingBuffer, position, MappedBitSet.map32Bits(backingBuffer, position + 24L, Elf.Program.Flag.class, Elf.Program.Flag::forValue));
        }

        @Override
        public long getOffset() {
            return this.backingBuffer.getIntUnsigned(this.position + 4L);
        }

        @Override
        public void setOffset(long offset) {
            this.backingBuffer.putInt(this.position + 4L, offset);
        }

        @Override
        public long getVirtualAddress() {
            return this.backingBuffer.getIntUnsigned(this.position + 8L);
        }

        @Override
        public void setVirtualAddress(long vAddr) {
            this.backingBuffer.putInt(this.position + 8L, vAddr);
        }

        @Override
        public long getPhysicalAddress() {
            return this.backingBuffer.getIntUnsigned(this.position + 12L);
        }

        @Override
        public void setPhysicalAddress(long pAddr) {
            this.backingBuffer.putInt(this.position + 12L, pAddr);
        }

        @Override
        public long getFileSize() {
            return this.backingBuffer.getIntUnsigned(this.position + 16L);
        }

        @Override
        public void setFileSize(long size) {
            this.backingBuffer.putInt(this.position + 16L, size);
        }

        @Override
        public long getMemorySize() {
            return this.backingBuffer.getIntUnsigned(this.position + 20L);
        }

        @Override
        public void setMemorySize(long size) {
            this.backingBuffer.putInt(this.position + 20L, size);
        }

        @Override
        public long getAlignment() {
            return this.backingBuffer.getIntUnsigned(this.position + 28L);
        }

        @Override
        void setAlignmentUnchecked(long alignment) {
            this.backingBuffer.putInt(this.position + 28L, alignment);
        }

        @Override
        public int getEntrySize() {
            return 32;
        }
    }
}

