/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;
import org.qbicc.machine.file.elf.ElfHeader;
import org.qbicc.machine.file.elf.ElfSectionHeaderEntry;

public abstract class ElfSymbolTableEntry {
    final ElfSectionHeaderEntry sectionHeaderEntry;
    final long position;
    String name;

    ElfSymbolTableEntry(ElfSectionHeaderEntry sectionHeaderEntry, long position) {
        this.sectionHeaderEntry = sectionHeaderEntry;
        this.position = position;
    }

    public ElfSectionHeaderEntry getSectionHeaderEntry() {
        return this.sectionHeaderEntry;
    }

    public ElfHeader getElfHeader() {
        return this.getSectionHeaderEntry().getElfHeader();
    }

    public BinaryBuffer getBackingBuffer() {
        return this.sectionHeaderEntry.getBackingBuffer();
    }

    public long getPosition() {
        return this.position;
    }

    public int getNameIndex() {
        return this.getBackingBuffer().getInt(this.position);
    }

    public void setNameIndex(int index) {
        this.getBackingBuffer().putInt(this.position, index);
    }

    public String getName() {
        String name = this.name;
        if (name == null) {
            int stringSection = this.getSectionHeaderEntry().getLinkedSectionIndex();
            this.name = name = this.getElfHeader().getStringFromSection(stringSection, this.getNameIndex());
        }
        return name;
    }

    public boolean nameEquals(String symbolName) {
        int stringSection = this.getSectionHeaderEntry().getLinkedSectionIndex();
        return this.getElfHeader().stringEquals(stringSection, this.getNameIndex(), symbolName);
    }

    public abstract long getValueSize();

    public abstract void setValueSize(long var1);

    public abstract long getValue();

    public abstract void setValue(long var1);

    abstract int getRawInfo();

    abstract void setRawInfo(int var1);

    public Elf.Symbol.Binding getBinding() {
        return Elf.Symbol.Binding.forValue(this.getRawInfo() >>> 4);
    }

    public void setBinding(Elf.Symbol.Binding binding) {
        this.setRawInfo(this.getRawInfo() & 0xF | binding.getValue() << 4);
    }

    public Elf.Symbol.Type getType() {
        return Elf.Symbol.Type.forValue(this.getRawInfo() & 0xF);
    }

    public void setType(Elf.Symbol.Type type) {
        this.setRawInfo(this.getRawInfo() & 0xFFFFFFF0 | type.getValue() & 0xF);
    }

    public void setInfo(Elf.Symbol.Binding binding, Elf.Symbol.Type type) {
        this.setRawInfo(binding.getValue() << 4 | type.getValue());
    }

    abstract int getRawOther();

    abstract void setRawOther(int var1);

    public Elf.Symbol.Visibility getVisibility() {
        return Elf.Symbol.Visibility.forValue(this.getRawOther() & 3);
    }

    public void setOther(Elf.Symbol.Visibility visibility) {
        this.setRawOther(visibility.getValue() & 3);
    }

    public abstract int getLinkedSectionIndex();

    public abstract void setLinkedSectionIndex(int var1);

    static final class _64
    extends ElfSymbolTableEntry {
        _64(ElfSectionHeaderEntry sectionHeaderEntry, long position) {
            super(sectionHeaderEntry, position);
        }

        @Override
        public long getValueSize() {
            return this.getBackingBuffer().getLong(this.position + 16L);
        }

        @Override
        public void setValueSize(long size) {
            this.getBackingBuffer().putLong(this.position + 16L, size);
        }

        @Override
        public long getValue() {
            return this.getBackingBuffer().getLong(this.position + 8L);
        }

        @Override
        public void setValue(long value) {
            this.getBackingBuffer().putLong(this.position + 8L, value);
        }

        @Override
        int getRawInfo() {
            return this.getBackingBuffer().getByteUnsigned(this.position + 4L);
        }

        @Override
        void setRawInfo(int value) {
            this.getBackingBuffer().putByte(this.position + 4L, value);
        }

        @Override
        int getRawOther() {
            return this.getBackingBuffer().getByteUnsigned(this.position + 5L);
        }

        @Override
        void setRawOther(int value) {
            this.getBackingBuffer().putByte(this.position + 5L, value);
        }

        @Override
        public int getLinkedSectionIndex() {
            return this.getBackingBuffer().getShortUnsigned(this.position + 6L);
        }

        @Override
        public void setLinkedSectionIndex(int index) {
            this.getBackingBuffer().putShort(this.position + 6L, index);
        }
    }

    static final class _32
    extends ElfSymbolTableEntry {
        _32(ElfSectionHeaderEntry sectionHeaderEntry, long position) {
            super(sectionHeaderEntry, position);
        }

        @Override
        public long getValueSize() {
            return this.getBackingBuffer().getIntUnsigned(this.position + 8L);
        }

        @Override
        public void setValueSize(long size) {
            this.getBackingBuffer().putInt(this.position + 8L, size);
        }

        @Override
        public long getValue() {
            return this.getBackingBuffer().getIntUnsigned(this.position + 4L);
        }

        @Override
        public void setValue(long value) {
            this.getBackingBuffer().putInt(this.position + 4L, value);
        }

        @Override
        int getRawInfo() {
            return this.getBackingBuffer().getByteUnsigned(this.position + 12L);
        }

        @Override
        void setRawInfo(int value) {
            this.getBackingBuffer().putByte(this.position + 12L, value);
        }

        @Override
        int getRawOther() {
            return this.getBackingBuffer().getByteUnsigned(this.position + 13L);
        }

        @Override
        void setRawOther(int value) {
            this.getBackingBuffer().putByte(this.position + 13L, value);
        }

        @Override
        public int getLinkedSectionIndex() {
            return this.getBackingBuffer().getShortUnsigned(this.position + 14L);
        }

        @Override
        public void setLinkedSectionIndex(int index) {
            this.getBackingBuffer().putShort(this.position + 14L, index);
        }
    }
}

