/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.elf;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.elf.Elf;

public abstract class MappedBitSet<E extends Elf.NumericEnumeration>
extends AbstractSet<E> {
    final BinaryBuffer backingBuffer;
    final long position;
    private final IntFunction<E> decoder;
    private final Class<E> type;
    final LongUnaryOperator mask;

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map8Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder, LongUnaryOperator mask) {
        return new _8<E>(backingBuffer, position, decoder, type, mask);
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map8Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder) {
        return MappedBitSet.map8Bits(backingBuffer, position, type, decoder, LongUnaryOperator.identity());
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map16Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder, LongUnaryOperator mask) {
        return new _16<E>(backingBuffer, position, decoder, type, mask);
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map16Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder) {
        return MappedBitSet.map16Bits(backingBuffer, position, type, decoder, LongUnaryOperator.identity());
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map32Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder, LongUnaryOperator mask) {
        return new _32<E>(backingBuffer, position, decoder, type, mask);
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map32Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder) {
        return new _32<E>(backingBuffer, position, decoder, type, LongUnaryOperator.identity());
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map64Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder, LongUnaryOperator mask) {
        return new _64<E>(backingBuffer, position, decoder, type, mask);
    }

    public static <E extends Elf.NumericEnumeration> MappedBitSet<E> map64Bits(BinaryBuffer backingBuffer, long position, Class<E> type, IntFunction<E> decoder) {
        return new _64<E>(backingBuffer, position, decoder, type, LongUnaryOperator.identity());
    }

    MappedBitSet(BinaryBuffer backingBuffer, long position, IntFunction<E> decoder, Class<E> type, LongUnaryOperator mask) {
        this.backingBuffer = backingBuffer;
        this.position = position;
        this.decoder = decoder;
        this.type = type;
        this.mask = mask;
    }

    final long getValue() {
        return this.mask.applyAsLong(this.getRawValue());
    }

    public abstract long getRawValue();

    final void setValue(long value) {
        this.setRawValue(this.mask.applyAsLong(value));
    }

    public abstract void setRawValue(long var1);

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            long v;
            {
                this.v = MappedBitSet.this.getValue();
            }

            @Override
            public boolean hasNext() {
                return this.v != 0L;
            }

            @Override
            public E next() {
                long lob = Long.lowestOneBit(this.v);
                if (lob == 0L) {
                    throw new NoSuchElementException();
                }
                this.v ^= lob;
                return (Elf.NumericEnumeration)MappedBitSet.this.decoder.apply(Long.numberOfTrailingZeros(lob));
            }
        };
    }

    @Override
    public int size() {
        return Long.bitCount(this.getValue());
    }

    @Override
    public boolean isEmpty() {
        return this.getValue() == 0L;
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        long lob;
        for (long v = this.getValue(); v != 0L; v ^= lob) {
            lob = Long.lowestOneBit(v);
            action.accept(this.decoder.apply(Long.numberOfTrailingZeros(lob)));
        }
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        long orig;
        long lob;
        long remove = 0L;
        for (long v = orig = this.getValue(); v != 0L; v ^= lob) {
            lob = Long.lowestOneBit(v);
            if (!filter.test(this.decoder.apply(Long.numberOfTrailingZeros(lob)))) continue;
            remove |= lob;
        }
        if (remove == 0L) {
            return false;
        }
        this.setValue(orig & (remove ^ 0xFFFFFFFFFFFFFFFFL));
        return true;
    }

    @Override
    public boolean add(E e) {
        this.type.cast(e);
        int val = e.getValue();
        long value = this.getValue();
        long bit = 1L << val;
        if ((value & bit) == 1L) {
            return false;
        }
        this.setValue(value | bit);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (this.type.isInstance(o)) {
            long bit;
            Elf.NumericEnumeration ne = (Elf.NumericEnumeration)this.type.cast(o);
            int val = ne.getValue();
            long value = this.getValue();
            if ((value & (bit = 1L << val)) == 0L) {
                return false;
            }
            this.setValue(value & (bit ^ 0xFFFFFFFFFFFFFFFFL));
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.setValue(0L);
    }

    @Override
    public boolean contains(Object o) {
        if (this.type.isInstance(o)) {
            long bit;
            Elf.NumericEnumeration ne = (Elf.NumericEnumeration)this.type.cast(o);
            int val = ne.getValue();
            long value = this.getValue();
            return (value & (bit = 1L << val)) != 0L;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        long remove = 0L;
        if (c instanceof MappedBitSet && ((MappedBitSet)c).type == this.type) {
            remove = ((MappedBitSet)c).getValue();
        } else {
            for (Object o : c) {
                if (!this.type.isInstance(o)) continue;
                remove |= 1L << ((Elf.NumericEnumeration)this.type.cast(o)).getValue();
            }
        }
        if (remove == 0L) {
            return false;
        }
        long old = this.getValue();
        if ((old & remove) == 0L) {
            return false;
        }
        this.setValue(old & (remove ^ 0xFFFFFFFFFFFFFFFFL));
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        long add = 0L;
        if (c instanceof MappedBitSet && ((MappedBitSet)c).type == this.type) {
            add = ((MappedBitSet)c).getValue();
        } else {
            for (Elf.NumericEnumeration e : c) {
                add |= 1L << e.getValue();
            }
        }
        if (add == 0L) {
            return false;
        }
        long old = this.getValue();
        if ((old & add) == add) {
            return false;
        }
        this.setValue(old | add);
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        long retain = 0L;
        if (c instanceof MappedBitSet && ((MappedBitSet)c).type == this.type) {
            retain = ((MappedBitSet)c).getValue();
        } else {
            for (Object o : c) {
                if (!this.type.isInstance(o)) continue;
                retain |= 1L << ((Elf.NumericEnumeration)this.type.cast(o)).getValue();
            }
        }
        long old = this.getValue();
        if ((old & (retain ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) {
            return false;
        }
        this.setValue(old & retain);
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        long find = 0L;
        if (c instanceof MappedBitSet && ((MappedBitSet)c).type == this.type) {
            find = ((MappedBitSet)c).getValue();
        } else {
            for (Object o : c) {
                if (!this.type.isInstance(o)) {
                    return false;
                }
                find |= 1L << ((Elf.NumericEnumeration)this.type.cast(o)).getValue();
            }
        }
        return (this.getValue() & find) == find;
    }

    static final class _8<E extends Elf.NumericEnumeration>
    extends MappedBitSet<E> {
        _8(BinaryBuffer backingBuffer, long position, IntFunction<E> decoder, Class<E> type, LongUnaryOperator mask) {
            super(backingBuffer, position, decoder, type, mask);
        }

        @Override
        public long getRawValue() {
            return this.backingBuffer.getByteUnsigned(this.position);
        }

        @Override
        public void setRawValue(long value) {
            this.backingBuffer.putByte(this.position, value);
        }
    }

    static final class _16<E extends Elf.NumericEnumeration>
    extends MappedBitSet<E> {
        _16(BinaryBuffer backingBuffer, long position, IntFunction<E> decoder, Class<E> type, LongUnaryOperator mask) {
            super(backingBuffer, position, decoder, type, mask);
        }

        @Override
        public long getRawValue() {
            return this.backingBuffer.getShortUnsigned(this.position);
        }

        @Override
        public void setRawValue(long value) {
            this.backingBuffer.putShort(this.position, value);
        }
    }

    static final class _32<E extends Elf.NumericEnumeration>
    extends MappedBitSet<E> {
        _32(BinaryBuffer backingBuffer, long position, IntFunction<E> decoder, Class<E> type, LongUnaryOperator mask) {
            super(backingBuffer, position, decoder, type, mask);
        }

        @Override
        public long getRawValue() {
            return this.backingBuffer.getIntUnsigned(this.position);
        }

        @Override
        public void setRawValue(long value) {
            this.backingBuffer.putInt(this.position, value);
        }
    }

    static final class _64<E extends Elf.NumericEnumeration>
    extends MappedBitSet<E> {
        _64(BinaryBuffer backingBuffer, long position, IntFunction<E> decoder, Class<E> type, LongUnaryOperator mask) {
            super(backingBuffer, position, decoder, type, mask);
        }

        @Override
        public long getRawValue() {
            return this.backingBuffer.getLong(this.position);
        }

        @Override
        public void setRawValue(long value) {
            this.backingBuffer.putLong(this.position, value);
        }
    }
}

