/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.macho;

import org.qbicc.machine.arch.Cpu;

public final class MachO {
    public static final int MH_MAGIC_32 = -17958194;
    public static final int MH_CIGAM_32 = Integer.reverseBytes(-17958194);
    public static final int MH_MAGIC_64 = -17958193;
    public static final int MH_CIGAM_64 = Integer.reverseBytes(-17958193);
    public static final int CPU_ARCH_ABI64 = 0x1000000;

    private MachO() {
    }

    static <T extends NumericEnumeration & Comparable<T>> T binarySearch(int value, T[] sortedItems, T defVal) {
        int low = 0;
        int high = sortedItems.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            T item = sortedItems[mid];
            int val = item.getValue();
            if (val < value) {
                low = mid + 1;
                continue;
            }
            if (val > value) {
                high = mid - 1;
                continue;
            }
            return item;
        }
        return defVal;
    }

    static interface NumericEnumeration {
        public int getValue();
    }

    public static interface NList {

        public static enum Type implements NumericEnumeration
        {
            UNDEF(0),
            ABS(1),
            TEXT(2),
            DATA(3),
            BSS(4),
            INDR(5),
            COMM(6),
            SECT(7),
            FILE_NAME(15);

            private final int value;
            private static final Type[] VALUES;

            private Type(int value) {
                this.value = value;
            }

            public static Type forValue(int value) {
                return (Type)MachO.binarySearch((int)value, (NumericEnumeration[])VALUES, (NumericEnumeration)UNDEF);
            }

            @Override
            public int getValue() {
                return this.value;
            }

            static {
                VALUES = Type.values();
            }
        }
    }

    public static enum LoadCommand implements NumericEnumeration
    {
        LC_UNKNOWN(0),
        LC_SEGMENT(1),
        LC_SYMTAB(2),
        LC_SYMSEG(3),
        LC_THREAD(4),
        LC_UNIXTHREAD(5),
        LC_LOADFVMLIB(6),
        LC_IDFVMLIB(7),
        LC_IDENT(8),
        LC_FVMFILE(9),
        LC_PREPAGE(10),
        LC_DYSYMTAB(11),
        LC_LOAD_DYLIB(12),
        LC_ID_DYLIB(13),
        LC_LOAD_DYLINKER(14),
        LC_ID_DYLINKER(15),
        LC_PREBOUND_DYLIB(16),
        LC_ROUTINES(17),
        LC_SUB_FRAMEWORK(18),
        LC_SUB_UMBRELLA(19),
        LC_SUB_CLIENT(20),
        LC_SUB_LIBRARY(21),
        LC_TWOLEVEL_HINTS(22),
        LC_PREBIND_CKSUM(23),
        LC_LOAD_WEAK_DYLIB(24),
        LC_SEGMENT_64(25),
        LC_ROUTINES_64(26),
        LC_UUID(27),
        LC_RPATH(28),
        LC_CODE_SIGNATURE(29),
        LC_SEGMENT_SPLIT_INFO(30),
        LC_REEXPORT_DYLIB(31),
        LC_LAZY_LOAD_DYLIB(32),
        LC_ENCRYPTION_INFO(33),
        LC_DYLD_INFO(34),
        LC_LOAD_UPWARD_DYLIB(35),
        LC_VERSION_MIN_MACOSX(36),
        LC_VERSION_MIN_IPHONEOS(37),
        LC_FUNCTION_STARTS(38),
        LC_DYLD_ENVIRONMENT(39),
        LC_MAIN(40),
        LC_DATA_IN_CODE(41),
        LC_SOURCE_VERSION(42),
        LC_DYLIB_CODE_SIGN_DRS(43),
        LC_ENCRYPTION_INFO_64(44),
        LC_LINKER_OPTION(45),
        LC_LINKER_OPTIMIZATION_HINT(46),
        LC_VERSION_MIN_TVOS(47),
        LC_VERSION_MIN_WATCHOS(48),
        LC_NOTE(49),
        LC_BUILD_VERSION(50);

        private final int value;
        private static final LoadCommand[] VALUES;

        private LoadCommand(int value) {
            this.value = value;
        }

        public static LoadCommand forValue(int value) {
            return (LoadCommand)MachO.binarySearch((int)value, (NumericEnumeration[])VALUES, (NumericEnumeration)LC_UNKNOWN);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static {
            VALUES = LoadCommand.values();
        }
    }

    public static enum Flag implements NumericEnumeration
    {
        MH_NOUNDEFS(0),
        MH_INCRLINK(1),
        MH_DYLDLINK(2),
        MH_BINDATLOAD(3),
        MH_PREBOUND(4),
        MH_SPLIT_SEGS(5),
        MH_LAZY_INIT(6),
        MH_TWOLEVEL(7),
        MH_FORCE_FLAT(8),
        MH_NOMULTIDEFS(9),
        MH_NOFIXPREBINDING(10),
        MH_PREBINDABLE(11),
        MH_ALLMODSBOUND(12),
        MH_SUBSECTIONS_VIA_SYMBOLS(13),
        MH_CANONICAL(14),
        MH_WEAK_DEFINES(15),
        MH_BINDS_TO_WEAK(16),
        MH_ALLOW_STACK_EXECUTION(17),
        MH_ROOT_SAFE(18),
        MH_SETUID_SAFE(19),
        MH_NO_REEXPORTED_DYLIBS(20),
        MH_PIE(21),
        MH_DEAD_STRIPPABLE_DYLIB(22),
        MH_HAS_TLV_DESCRIPTORS(23),
        MH_NO_HEAP_EXECUTION(24),
        MH_APP_EXTENSION_SAFE(25),
        MP_NLIST_OUTOFSYNC_WITH_DYLDINFO(26);

        private final int value;
        private static final Flag[] VALUES;

        private Flag(int value) {
            this.value = value;
        }

        public static Flag forValue(int value) {
            return (Flag)MachO.binarySearch((int)value, (NumericEnumeration[])VALUES, null);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static {
            VALUES = Flag.values();
        }
    }

    public static enum CpuType implements NumericEnumeration
    {
        CPU_TYPE_UNKNOWN(0, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_VAX(1, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_MC680x0(6, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_X86(7, Cpu.X86, Cpu.X86_64),
        CPU_TYPE_MIPS(8, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_MC98000(10, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_HPPA(11, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_ARM(12, Cpu.ARM, Cpu.AARCH64),
        CPU_TYPE_MC88000(13, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_SPARC(14, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_I860(15, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_ALPHA(16, Cpu.UNKNOWN, Cpu.UNKNOWN),
        CPU_TYPE_POWERPC(18, Cpu.PPC32, Cpu.PPC64);

        private final int value;
        private final Cpu cpu32;
        private final Cpu cpu64;
        private static final CpuType[] VALUES;

        private CpuType(int value, Cpu cpu32, Cpu cpu64) {
            this.value = value;
            this.cpu32 = cpu32;
            this.cpu64 = cpu64;
        }

        public static CpuType forValue(int value) {
            return (CpuType)MachO.binarySearch((int)value, (NumericEnumeration[])VALUES, (NumericEnumeration)CPU_TYPE_UNKNOWN);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public Cpu toCpu(boolean is64) {
            return is64 ? this.cpu64 : this.cpu32;
        }

        static {
            VALUES = CpuType.values();
        }
    }

    public static enum FileType implements NumericEnumeration
    {
        MH_UNKNOWN(-1),
        MH_OBJECT(1),
        MH_EXECUTE(2),
        MH_FVMLIB(3),
        MH_CORE(4),
        MH_PRELOAD(5),
        MH_DYLIB(6),
        MH_DYLINKER(7),
        MH_BUNDLE(8),
        MH_DYLIB_STUB(9),
        MH_DSYM(10),
        MH_KEXT_BUNDLE(11);

        private final int value;
        private static final FileType[] VALUES;

        private FileType(int value) {
            this.value = value;
        }

        public static FileType forValue(int value) {
            return (FileType)MachO.binarySearch((int)value, (NumericEnumeration[])VALUES, (NumericEnumeration)MH_UNKNOWN);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        static {
            VALUES = FileType.values();
        }
    }
}

