/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.macho;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import org.qbicc.machine.arch.Cpu;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.file.bin.BinaryBuffer;
import org.qbicc.machine.file.macho.MachO;
import org.qbicc.machine.object.ObjectFile;

public final class MachOObjectFile
implements ObjectFile {
    private final BinaryBuffer buffer;
    private final Header header;
    private final EnumMap<MachO.LoadCommand, List<LoadCommand>> commands;
    private final List<SymTab> symTabs = new ArrayList<SymTab>();
    private final Map<String, NList> syms = new HashMap<String, NList>();
    private final Map<String, Map<String, Section>> segmentsAndSections = new HashMap<String, Map<String, Section>>();
    private final List<Section> sections = new ArrayList<Section>();

    public MachOObjectFile(BinaryBuffer buffer) throws IOException {
        int magic = buffer.getInt(0L);
        if (magic == MachO.MH_CIGAM_32 || magic == MachO.MH_CIGAM_64) {
            buffer.setByteOrder(MachOObjectFile.opposite(buffer.getByteOrder()));
            magic = buffer.getInt(0L);
        } else if (magic != -17958194 && magic != -17958193) {
            throw new IOException("Invalid magic number");
        }
        this.buffer = buffer;
        this.header = new Header(buffer);
        this.commands = new EnumMap(MachO.LoadCommand.class);
        long offs = magic == -17958194 ? 28L : 32L;
        ArrayList<Segment> segments = new ArrayList<Segment>();
        for (int i = 0; i < this.header.nCmds; ++i) {
            LoadCommand cmd = new LoadCommand(buffer, offs);
            this.commands.computeIfAbsent(cmd.command, c -> new ArrayList()).add(cmd);
            if (cmd.command == MachO.LoadCommand.LC_SYMTAB) {
                this.symTabs.add(new SymTab(buffer, cmd));
            } else if (cmd.command == MachO.LoadCommand.LC_SEGMENT) {
                segment = new Segment(buffer, offs + 8L, false);
                segments.add(segment);
                subMap = this.segmentsAndSections.computeIfAbsent(segment.name, n -> new HashMap());
                subOffs = offs + 56L;
                j = 0;
                while ((long)j < segment.numSections) {
                    section = new Section(buffer, subOffs, false);
                    subMap.put(section.name, section);
                    this.sections.add(section);
                    subOffs += 68L;
                    ++j;
                }
            } else if (cmd.command == MachO.LoadCommand.LC_SEGMENT_64) {
                segment = new Segment(buffer, offs + 8L, true);
                segments.add(segment);
                subMap = this.segmentsAndSections.computeIfAbsent(segment.name, n -> new HashMap());
                subOffs = offs + 72L;
                j = 0;
                while ((long)j < segment.numSections) {
                    section = new Section(buffer, subOffs, true);
                    subMap.put(section.name, section);
                    this.sections.add(section);
                    subOffs += 80L;
                    ++j;
                }
            }
            offs += cmd.size;
        }
        for (SymTab symTab : this.symTabs) {
            long nSyms = symTab.nSyms;
            long offset = symTab.offset;
            long strOff = symTab.strOff;
            long strSize = symTab.strSize;
            for (long i = 0L; i < nSyms; ++i) {
                NList nlist = new NList(buffer, offset, this.header.abi64);
                long sti = nlist.stringTableIndex;
                if (sti != 0L) {
                    BinaryBuffer.ReadingIterator iter = buffer.readingIterator(strOff + sti);
                    StringBuilder b = new StringBuilder();
                    int cp = iter.getCodePoint();
                    if (cp == 95) {
                        cp = iter.getCodePoint();
                    } else if (cp == 0) continue;
                    do {
                        b.appendCodePoint(cp);
                    } while ((cp = iter.getCodePoint()) != 0);
                    this.syms.put(b.toString(), nlist);
                }
                offset += (long)nlist.size;
            }
        }
    }

    public int getSymbolValueAsByte(String name) {
        NList symbol = this.requireSymbol(name);
        long value = symbol.value;
        if (symbol.type == MachO.NList.Type.BSS) {
            return 0;
        }
        if (symbol.type == MachO.NList.Type.SECT) {
            Section section = this.sections.get(symbol.section - 1);
            if (section.name.equals("__common")) {
                return 0;
            }
            return this.buffer.getByteUnsigned(section.fileOffset + symbol.value);
        }
        throw new IllegalArgumentException("Unexpected symbol type " + symbol.type);
    }

    public int getSymbolValueAsInt(String name) {
        NList symbol = this.requireSymbol(name);
        long value = symbol.value;
        if (symbol.type == MachO.NList.Type.BSS) {
            return 0;
        }
        if (symbol.type == MachO.NList.Type.SECT) {
            Section section = this.sections.get(symbol.section - 1);
            if (section.name.equals("__common")) {
                return 0;
            }
            return this.buffer.getInt(section.fileOffset + symbol.value);
        }
        throw new IllegalArgumentException("Unexpected symbol type " + symbol.type);
    }

    public long getSymbolValueAsLong(String name) {
        NList symbol = this.requireSymbol(name);
        long value = symbol.value;
        if (symbol.type == MachO.NList.Type.BSS) {
            return 0L;
        }
        if (symbol.type == MachO.NList.Type.SECT) {
            Section section = this.sections.get(symbol.section - 1);
            if (section.name.equals("__common")) {
                return 0L;
            }
            return this.buffer.getLong(section.fileOffset + symbol.value);
        }
        throw new IllegalArgumentException("Unexpected symbol type " + symbol.type);
    }

    public byte[] getSymbolAsBytes(String name, int size) {
        byte[] array = new byte[size];
        NList symbol = this.requireSymbol(name);
        long value = symbol.value;
        if (symbol.type == MachO.NList.Type.BSS) {
            return array;
        }
        if (symbol.type == MachO.NList.Type.SECT) {
            Section section = this.sections.get(symbol.section - 1);
            if (section.name.equals("__common")) {
                return array;
            }
            this.buffer.getBytes(section.fileOffset + symbol.value, array);
            return array;
        }
        throw new IllegalArgumentException("Unexpected symbol type " + symbol.type);
    }

    public String getSymbolValueAsUtfString(String name, int nbytes) {
        NList symbol = this.requireSymbol(name);
        long value = symbol.value;
        if (symbol.type == MachO.NList.Type.BSS) {
            return "";
        }
        if (symbol.type == MachO.NList.Type.SECT) {
            Section section = this.sections.get(symbol.section - 1);
            if (section.name.equals("__common")) {
                return "";
            }
            byte[] array = new byte[nbytes];
            this.buffer.getBytes(section.fileOffset + symbol.value, array);
            return new String(array, StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Unexpected symbol type " + symbol.type);
    }

    public long getSymbolSize(String name) {
        return this.requireSymbol((String)name).size;
    }

    NList requireSymbol(String name) {
        NList nList = this.syms.get(name);
        if (nList == null) {
            throw new IllegalArgumentException("No symbol named `" + name + "` found");
        }
        return nList;
    }

    Section requireSection(String segmentName, String sectionName) {
        Section section = (Section)this.segmentsAndSections.getOrDefault(segmentName, Map.of()).get(sectionName);
        if (section == null) {
            throw new IllegalArgumentException("No section named `" + sectionName + "` in segment `" + segmentName + "` found");
        }
        return section;
    }

    public ByteOrder getByteOrder() {
        return this.buffer.getByteOrder();
    }

    public Cpu getCpu() {
        return this.header.cpuType.toCpu(this.header.abi64);
    }

    public ObjectType getObjectType() {
        return ObjectType.MACH_O;
    }

    public org.qbicc.machine.object.Section getSection(final String name) {
        final Section section = this.sections.stream().filter(s -> s.name.equals(name)).findFirst().orElse(null);
        if (section == null) {
            return null;
        }
        return new org.qbicc.machine.object.Section(){

            public String getName() {
                return name;
            }

            public ByteBuffer getSectionContent() {
                return MachOObjectFile.this.buffer.getBuffer(section.fileOffset, section.size);
            }
        };
    }

    public String getRelocationSymbolForSymbolValue(String symbol) {
        return null;
    }

    public String getStackMapSectionName() {
        return "__llvm_stackmaps";
    }

    public void close() {
        this.buffer.close();
    }

    static ByteOrder opposite(ByteOrder order) {
        return order == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    static int indexOf(byte[] b, int val) {
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != val) continue;
            return i;
        }
        return -1;
    }

    static String fromBytes(BinaryBuffer buffer, long offset, int size) {
        byte[] bytes = new byte[size];
        buffer.getBytes(offset, bytes);
        return MachOObjectFile.fromBytes(bytes);
    }

    static String fromBytes(byte[] bytes) {
        int len = MachOObjectFile.indexOf(bytes, 0);
        if (len == -1) {
            len = 16;
        }
        return new String(bytes, 0, len, StandardCharsets.UTF_8);
    }

    static <E extends Enum<E>> EnumSet<E> setOfBits(Class<E> type, long bits, IntFunction<E> decoder) {
        EnumSet<Enum> set = EnumSet.noneOf(type);
        while (bits != 0L) {
            long lob = Long.lowestOneBit(bits);
            bits &= lob ^ 0xFFFFFFFFFFFFFFFFL;
            set.add((Enum)decoder.apply(Long.numberOfTrailingZeros(lob)));
        }
        return set;
    }

    static final class Header {
        final MachO.CpuType cpuType;
        final boolean abi64;
        final MachO.FileType fileType;
        final int nCmds;
        final int sizeOfCmds;
        final Set<MachO.Flag> flags;

        Header(BinaryBuffer buffer) {
            int cpuTypeInt = buffer.getInt(4L);
            this.abi64 = (cpuTypeInt & 0x1000000) != 0;
            this.cpuType = MachO.CpuType.forValue(cpuTypeInt & 0xFFFFFF);
            this.fileType = MachO.FileType.forValue(buffer.getInt(16L));
            this.nCmds = buffer.getInt(16L);
            this.sizeOfCmds = buffer.getInt(20L);
            this.flags = MachOObjectFile.setOfBits(MachO.Flag.class, buffer.getIntUnsigned(24L), MachO.Flag::forValue);
        }
    }

    static final class LoadCommand {
        final long offset;
        final MachO.LoadCommand command;
        final long size;

        LoadCommand(BinaryBuffer buffer, long offset) {
            this.offset = offset;
            this.command = MachO.LoadCommand.forValue(buffer.getInt(offset));
            this.size = buffer.getIntUnsigned(offset + 4L);
        }
    }

    static final class SymTab {
        final long offset;
        final long nSyms;
        final long strOff;
        final long strSize;

        SymTab(BinaryBuffer buffer, LoadCommand cmd) {
            this.offset = buffer.getIntUnsigned(cmd.offset + 8L);
            this.nSyms = buffer.getIntUnsigned(cmd.offset + 12L);
            this.strOff = buffer.getIntUnsigned(cmd.offset + 16L);
            this.strSize = buffer.getIntUnsigned(cmd.offset + 20L);
        }
    }

    static final class Segment {
        final String name;
        final long address;
        final long segmentSize;
        final long segmentOffset;
        final long fileSize;
        final long numSections;

        Segment(BinaryBuffer buffer, long offset, boolean is64) {
            this.name = MachOObjectFile.fromBytes(buffer, offset, 16);
            this.address = is64 ? buffer.getLong(offset + 16L) : buffer.getIntUnsigned(offset + 16L);
            this.segmentSize = is64 ? buffer.getLong(offset + 24L) : buffer.getIntUnsigned(offset + 20L);
            this.segmentOffset = is64 ? buffer.getLong(offset + 32L) : buffer.getIntUnsigned(offset + 24L);
            this.fileSize = is64 ? buffer.getLong(offset + 40L) : buffer.getIntUnsigned(offset + 28L);
            this.numSections = is64 ? buffer.getIntUnsigned(offset + 56L) : buffer.getIntUnsigned(offset + 36L);
        }
    }

    static final class Section {
        final String name;
        final long address;
        final long size;
        final long fileOffset;
        final long align;
        final long relOff;

        Section(BinaryBuffer buffer, long offset, boolean is64) {
            this.name = MachOObjectFile.fromBytes(buffer, offset, 16);
            this.address = is64 ? buffer.getLong(offset + 32L) : buffer.getIntUnsigned(offset + 32L);
            this.size = is64 ? buffer.getLong(offset + 40L) : buffer.getIntUnsigned(offset + 36L);
            this.fileOffset = is64 ? buffer.getIntUnsigned(offset + 48L) : buffer.getIntUnsigned(offset + 40L);
            this.align = is64 ? buffer.getIntUnsigned(offset + 52L) : buffer.getIntUnsigned(offset + 44L);
            this.relOff = is64 ? buffer.getIntUnsigned(offset + 56L) : buffer.getIntUnsigned(offset + 48L);
        }
    }

    static final class NList {
        final long offset;
        final int size;
        final long stringTableIndex;
        final boolean privateExtern;
        final boolean external;
        final boolean stab;
        final MachO.NList.Type type;
        final int section;
        final boolean weakRef;
        final boolean weakDef;
        final long value;

        NList(BinaryBuffer buffer, long offset, boolean is64) {
            this.offset = offset;
            this.size = is64 ? 16 : 12;
            this.stringTableIndex = buffer.getIntUnsigned(offset);
            short n_type = buffer.getByteUnsigned(offset + 4L);
            this.privateExtern = (n_type & 0x10) != 0;
            this.external = (n_type & 1) != 0;
            this.stab = (n_type & 0xE0) != 0;
            this.type = this.stab ? MachO.NList.Type.UNDEF : MachO.NList.Type.forValue(n_type >> 1 & 7);
            this.section = buffer.getByteUnsigned(offset + 5L);
            int n_desc = buffer.getShortUnsigned(offset + 6L);
            this.weakRef = (n_desc & 0x40) != 0;
            this.weakDef = (n_desc & 0x80) != 0;
            this.value = is64 ? buffer.getLong(offset + 8L) : buffer.getIntUnsigned(offset + 8L);
        }
    }
}

