/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.object;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.qbicc.machine.arch.ObjectType;
import org.qbicc.machine.object.ObjectFile;

public interface ObjectFileProvider {
    public ObjectFile openObjectFile(Path var1) throws IOException;

    public ObjectType getObjectType();

    public static Optional<ObjectFileProvider> findProvider(ObjectType objectType, ClassLoader searchLoader) {
        Assert.checkNotNullParam((String)"objectType", (Object)objectType);
        Assert.checkNotNullParam((String)"searchLoader", (Object)searchLoader);
        ServiceLoader<ObjectFileProvider> loader = ServiceLoader.load(ObjectFileProvider.class, searchLoader);
        Iterator<ObjectFileProvider> iterator = loader.iterator();
        while (true) {
            try {
                ObjectFileProvider next;
                do {
                    if (iterator.hasNext()) continue;
                    return Optional.empty();
                } while ((next = iterator.next()).getObjectType() != objectType);
                return Optional.of(next);
            }
            catch (RuntimeException | ServiceConfigurationError ignored) {
                ignored.printStackTrace();
                continue;
            }
            break;
        }
    }
}

