/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.file.wasm.kaitai;

import io.kaitai.struct.ByteBufferKaitaiStream;
import io.kaitai.struct.KaitaiStream;
import io.kaitai.struct.KaitaiStruct;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.qbicc.machine.file.wasm.kaitai.VlqBase128Le;

public class Webassembly
extends KaitaiStruct {
    private byte[] magic;
    private long version;
    private Sections sections;
    private Webassembly _root;
    private KaitaiStruct _parent;

    public static Webassembly fromFile(String fileName) throws IOException {
        return new Webassembly((KaitaiStream)new ByteBufferKaitaiStream(fileName));
    }

    public Webassembly(KaitaiStream _io) {
        this(_io, null, null);
    }

    public Webassembly(KaitaiStream _io, KaitaiStruct _parent) {
        this(_io, _parent, null);
    }

    public Webassembly(KaitaiStream _io, KaitaiStruct _parent, Webassembly _root) {
        super(_io);
        this._parent = _parent;
        this._root = _root == null ? this : _root;
        this._read();
    }

    private void _read() {
        this.magic = this._io.readBytes(4L);
        if (!Arrays.equals(this.magic(), new byte[]{0, 97, 115, 109})) {
            throw new KaitaiStream.ValidationNotEqualError(new byte[]{0, 97, 115, 109}, this.magic(), this._io(), "/seq/0");
        }
        this.version = this._io.readU4le();
        this.sections = new Sections(this._io, this, this._root);
    }

    public byte[] magic() {
        return this.magic;
    }

    public long version() {
        return this.version;
    }

    public Sections sections() {
        return this.sections;
    }

    public Webassembly _root() {
        return this._root;
    }

    public KaitaiStruct _parent() {
        return this._parent;
    }

    public static class Sections
    extends KaitaiStruct {
        private ArrayList<Section> sections;
        private Webassembly _root;
        private Webassembly _parent;

        public static Sections fromFile(String fileName) throws IOException {
            return new Sections((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public Sections(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Sections(KaitaiStream _io, Webassembly _parent) {
            this(_io, _parent, null);
        }

        public Sections(KaitaiStream _io, Webassembly _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.sections = new ArrayList();
            int i = 0;
            while (!this._io.isEof()) {
                this.sections.add(new Section(this._io, this, this._root));
                ++i;
            }
        }

        public ArrayList<Section> sections() {
            return this.sections;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Webassembly _parent() {
            return this._parent;
        }
    }

    public static class GlobalType
    extends KaitaiStruct {
        private ValueType contentType;
        private MutabilityFlag mutability;
        private Webassembly _root;
        private KaitaiStruct _parent;

        public static GlobalType fromFile(String fileName) throws IOException {
            return new GlobalType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public GlobalType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public GlobalType(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public GlobalType(KaitaiStream _io, KaitaiStruct _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.contentType = ValueType.byId(this._io.readU1());
            this.mutability = MutabilityFlag.byId(this._io.readU1());
        }

        public ValueType contentType() {
            return this.contentType;
        }

        public MutabilityFlag mutability() {
            return this.mutability;
        }

        public Webassembly _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static class UnimplementedSection
    extends KaitaiStruct {
        private VlqBase128Le nameLen;
        private String name;
        private ArrayList<LinkingCustomType> linking;
        private ArrayList<Integer> raw;
        private Webassembly _root;
        private Section _parent;

        public static UnimplementedSection fromFile(String fileName) throws IOException {
            return new UnimplementedSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public UnimplementedSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public UnimplementedSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public UnimplementedSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            int i;
            this.nameLen = new VlqBase128Le(this._io);
            this.name = new String(this._io.readBytes((long)this.nameLen().value().intValue()), Charset.forName("UTF-8"));
            if (this.name().equals("linking")) {
                this.linking = new ArrayList();
                i = 0;
                while (!this._io.isEof()) {
                    this.linking.add(new LinkingCustomType(this._io, this, this._root));
                    ++i;
                }
            }
            if (!this.name().equals("linking")) {
                this.raw = new ArrayList(this._parent().header().payloadLen().value() - this.nameLen().value() - this.nameLen().len());
                for (i = 0; i < this._parent().header().payloadLen().value() - this.nameLen().value() - this.nameLen().len(); ++i) {
                    this.raw.add(this._io.readU1());
                }
            }
        }

        public VlqBase128Le nameLen() {
            return this.nameLen;
        }

        public String name() {
            return this.name;
        }

        public ArrayList<LinkingCustomType> linking() {
            return this.linking;
        }

        public ArrayList<Integer> raw() {
            return this.raw;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class MemorySection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<MemoryType> entries;
        private Webassembly _root;
        private Section _parent;

        public static MemorySection fromFile(String fileName) throws IOException {
            return new MemorySection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public MemorySection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public MemorySection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public MemorySection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.entries = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.entries.add(new MemoryType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<MemoryType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class ElemSegmentType
    extends KaitaiStruct {
        private VlqBase128Le index;
        private ArrayList<Integer> offset;
        private VlqBase128Le numElem;
        private ArrayList<VlqBase128Le> elems;
        private Webassembly _root;
        private ElementSection _parent;

        public static ElemSegmentType fromFile(String fileName) throws IOException {
            return new ElemSegmentType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ElemSegmentType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ElemSegmentType(KaitaiStream _io, ElementSection _parent) {
            this(_io, _parent, null);
        }

        public ElemSegmentType(KaitaiStream _io, ElementSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            int _it;
            this.index = new VlqBase128Le(this._io);
            this.offset = new ArrayList();
            int i = 0;
            do {
                _it = this._io.readU1();
                this.offset.add(_it);
                ++i;
            } while (_it != 11);
            this.numElem = new VlqBase128Le(this._io);
            this.elems = new ArrayList(this.numElem().value());
            for (int i2 = 0; i2 < this.numElem().value(); ++i2) {
                this.elems.add(new VlqBase128Le(this._io));
            }
        }

        public VlqBase128Le index() {
            return this.index;
        }

        public ArrayList<Integer> offset() {
            return this.offset;
        }

        public VlqBase128Le numElem() {
            return this.numElem;
        }

        public ArrayList<VlqBase128Le> elems() {
            return this.elems;
        }

        public Webassembly _root() {
            return this._root;
        }

        public ElementSection _parent() {
            return this._parent;
        }
    }

    public static class ResizableLimitsType
    extends KaitaiStruct {
        private int flags;
        private VlqBase128Le initial;
        private VlqBase128Le maximum;
        private Webassembly _root;
        private KaitaiStruct _parent;

        public static ResizableLimitsType fromFile(String fileName) throws IOException {
            return new ResizableLimitsType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ResizableLimitsType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ResizableLimitsType(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public ResizableLimitsType(KaitaiStream _io, KaitaiStruct _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.flags = this._io.readU1();
            this.initial = new VlqBase128Le(this._io);
            if (this.flags() == 1) {
                this.maximum = new VlqBase128Le(this._io);
            }
        }

        public int flags() {
            return this.flags;
        }

        public VlqBase128Le initial() {
            return this.initial;
        }

        public VlqBase128Le maximum() {
            return this.maximum;
        }

        public Webassembly _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static class FunctionSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<VlqBase128Le> types;
        private Webassembly _root;
        private Section _parent;

        public static FunctionSection fromFile(String fileName) throws IOException {
            return new FunctionSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public FunctionSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public FunctionSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public FunctionSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.types = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.types.add(new VlqBase128Le(this._io));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<VlqBase128Le> types() {
            return this.types;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class SyminfoSection
    extends KaitaiStruct {
        private VlqBase128Le section;
        private Webassembly _root;
        private SyminfoType _parent;

        public static SyminfoSection fromFile(String fileName) throws IOException {
            return new SyminfoSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SyminfoSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SyminfoSection(KaitaiStream _io, SyminfoType _parent) {
            this(_io, _parent, null);
        }

        public SyminfoSection(KaitaiStream _io, SyminfoType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.section = new VlqBase128Le(this._io);
        }

        public VlqBase128Le section() {
            return this.section;
        }

        public Webassembly _root() {
            return this._root;
        }

        public SyminfoType _parent() {
            return this._parent;
        }
    }

    public static class TableType
    extends KaitaiStruct {
        private ElemType elementType;
        private ResizableLimitsType limits;
        private Webassembly _root;
        private KaitaiStruct _parent;

        public static TableType fromFile(String fileName) throws IOException {
            return new TableType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public TableType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TableType(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public TableType(KaitaiStream _io, KaitaiStruct _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.elementType = ElemType.byId(this._io.readU1());
            this.limits = new ResizableLimitsType(this._io, this, this._root);
        }

        public ElemType elementType() {
            return this.elementType;
        }

        public ResizableLimitsType limits() {
            return this.limits;
        }

        public Webassembly _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static class StartSection
    extends KaitaiStruct {
        private VlqBase128Le index;
        private Webassembly _root;
        private Section _parent;

        public static StartSection fromFile(String fileName) throws IOException {
            return new StartSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public StartSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public StartSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public StartSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.index = new VlqBase128Le(this._io);
        }

        public VlqBase128Le index() {
            return this.index;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class SyminfoExt
    extends KaitaiStruct {
        private VlqBase128Le index;
        private VlqBase128Le nameLen;
        private String nameData;
        private Webassembly _root;
        private SyminfoType _parent;

        public static SyminfoExt fromFile(String fileName) throws IOException {
            return new SyminfoExt((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SyminfoExt(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SyminfoExt(KaitaiStream _io, SyminfoType _parent) {
            this(_io, _parent, null);
        }

        public SyminfoExt(KaitaiStream _io, SyminfoType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.index = new VlqBase128Le(this._io);
            if (((long)this._parent().flags().value().intValue() & Symflag.UNDEFINED.id()) == 0L) {
                this.nameLen = new VlqBase128Le(this._io);
            }
            if (((long)this._parent().flags().value().intValue() & Symflag.UNDEFINED.id()) == 0L) {
                this.nameData = new String(this._io.readBytes((long)this.nameLen().value().intValue()), Charset.forName("UTF-8"));
            }
        }

        public VlqBase128Le index() {
            return this.index;
        }

        public VlqBase128Le nameLen() {
            return this.nameLen;
        }

        public String nameData() {
            return this.nameData;
        }

        public Webassembly _root() {
            return this._root;
        }

        public SyminfoType _parent() {
            return this._parent;
        }
    }

    public static class GlobalVariableType
    extends KaitaiStruct {
        private GlobalType type;
        private ArrayList<Integer> init;
        private Webassembly _root;
        private GlobalSection _parent;

        public static GlobalVariableType fromFile(String fileName) throws IOException {
            return new GlobalVariableType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public GlobalVariableType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public GlobalVariableType(KaitaiStream _io, GlobalSection _parent) {
            this(_io, _parent, null);
        }

        public GlobalVariableType(KaitaiStream _io, GlobalSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            int _it;
            this.type = new GlobalType(this._io, this, this._root);
            this.init = new ArrayList();
            int i = 0;
            do {
                _it = this._io.readU1();
                this.init.add(_it);
                ++i;
            } while (_it != 11);
        }

        public GlobalType type() {
            return this.type;
        }

        public ArrayList<Integer> init() {
            return this.init;
        }

        public Webassembly _root() {
            return this._root;
        }

        public GlobalSection _parent() {
            return this._parent;
        }
    }

    public static class ImportSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<ImportEntry> entries;
        private Webassembly _root;
        private Section _parent;

        public static ImportSection fromFile(String fileName) throws IOException {
            return new ImportSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ImportSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ImportSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public ImportSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            if (this.count().value() > 0) {
                this.entries = new ArrayList(this.count().value());
                for (int i = 0; i < this.count().value(); ++i) {
                    this.entries.add(new ImportEntry(this._io, this, this._root));
                }
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<ImportEntry> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class DataCountSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private Webassembly _root;
        private Section _parent;

        public static DataCountSection fromFile(String fileName) throws IOException {
            return new DataCountSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DataCountSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DataCountSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public DataCountSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class LocalEntryType
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ValueType type;
        private Webassembly _root;
        private FunctionBodyDataType _parent;

        public static LocalEntryType fromFile(String fileName) throws IOException {
            return new LocalEntryType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public LocalEntryType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public LocalEntryType(KaitaiStream _io, FunctionBodyDataType _parent) {
            this(_io, _parent, null);
        }

        public LocalEntryType(KaitaiStream _io, FunctionBodyDataType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.type = ValueType.byId(this._io.readU1());
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ValueType type() {
            return this.type;
        }

        public Webassembly _root() {
            return this._root;
        }

        public FunctionBodyDataType _parent() {
            return this._parent;
        }
    }

    public static class FunctionBodyType
    extends KaitaiStruct {
        private VlqBase128Le bodySize;
        private FunctionBodyDataType data;
        private Webassembly _root;
        private CodeSection _parent;
        private byte[] _raw_data;

        public static FunctionBodyType fromFile(String fileName) throws IOException {
            return new FunctionBodyType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public FunctionBodyType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public FunctionBodyType(KaitaiStream _io, CodeSection _parent) {
            this(_io, _parent, null);
        }

        public FunctionBodyType(KaitaiStream _io, CodeSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.bodySize = new VlqBase128Le(this._io);
            this._raw_data = this._io.readBytes((long)this.bodySize().value().intValue());
            ByteBufferKaitaiStream _io__raw_data = new ByteBufferKaitaiStream(this._raw_data);
            this.data = new FunctionBodyDataType((KaitaiStream)_io__raw_data, this, this._root);
        }

        public VlqBase128Le bodySize() {
            return this.bodySize;
        }

        public FunctionBodyDataType data() {
            return this.data;
        }

        public Webassembly _root() {
            return this._root;
        }

        public CodeSection _parent() {
            return this._parent;
        }

        public byte[] _raw_data() {
            return this._raw_data;
        }
    }

    public static class LinkingCustomSubsectionType
    extends KaitaiStruct {
        private int type;
        private VlqBase128Le payloadLen;
        private SymbolTableType symbolTable;
        private ArrayList<Integer> payloadData;
        private Webassembly _root;
        private LinkingCustomType _parent;
        private byte[] _raw_symbolTable;

        public static LinkingCustomSubsectionType fromFile(String fileName) throws IOException {
            return new LinkingCustomSubsectionType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public LinkingCustomSubsectionType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public LinkingCustomSubsectionType(KaitaiStream _io, LinkingCustomType _parent) {
            this(_io, _parent, null);
        }

        public LinkingCustomSubsectionType(KaitaiStream _io, LinkingCustomType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.type = this._io.readU1();
            this.payloadLen = new VlqBase128Le(this._io);
            if ((long)this.type() == LinkingMetadataPayloadType.SYMBOL_TABLE.id()) {
                this._raw_symbolTable = this._io.readBytes((long)this.payloadLen().value().intValue());
                ByteBufferKaitaiStream _io__raw_symbolTable = new ByteBufferKaitaiStream(this._raw_symbolTable);
                this.symbolTable = new SymbolTableType((KaitaiStream)_io__raw_symbolTable, this, this._root);
            }
            if ((long)this.type() != LinkingMetadataPayloadType.SYMBOL_TABLE.id()) {
                this.payloadData = new ArrayList(this.payloadLen().value());
                for (int i = 0; i < this.payloadLen().value(); ++i) {
                    this.payloadData.add(this._io.readU1());
                }
            }
        }

        public int type() {
            return this.type;
        }

        public VlqBase128Le payloadLen() {
            return this.payloadLen;
        }

        public SymbolTableType symbolTable() {
            return this.symbolTable;
        }

        public ArrayList<Integer> payloadData() {
            return this.payloadData;
        }

        public Webassembly _root() {
            return this._root;
        }

        public LinkingCustomType _parent() {
            return this._parent;
        }

        public byte[] _raw_symbolTable() {
            return this._raw_symbolTable;
        }
    }

    public static class TypeSection
    extends KaitaiStruct {
        private int count;
        private ArrayList<FuncType> entries;
        private Webassembly _root;
        private Section _parent;

        public static TypeSection fromFile(String fileName) throws IOException {
            return new TypeSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public TypeSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TypeSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public TypeSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = this._io.readU1();
            this.entries = new ArrayList(this.count());
            for (int i = 0; i < this.count(); ++i) {
                this.entries.add(new FuncType(this._io, this, this._root));
            }
        }

        public int count() {
            return this.count;
        }

        public ArrayList<FuncType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class ElementSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<ElemSegmentType> entries;
        private Webassembly _root;
        private Section _parent;

        public static ElementSection fromFile(String fileName) throws IOException {
            return new ElementSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ElementSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ElementSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public ElementSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.entries = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.entries.add(new ElemSegmentType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<ElemSegmentType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class GlobalSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<GlobalVariableType> globals;
        private Webassembly _root;
        private Section _parent;

        public static GlobalSection fromFile(String fileName) throws IOException {
            return new GlobalSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public GlobalSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public GlobalSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public GlobalSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.globals = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.globals.add(new GlobalVariableType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<GlobalVariableType> globals() {
            return this.globals;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class SymbolTableType
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<SyminfoType> infos;
        private Webassembly _root;
        private LinkingCustomSubsectionType _parent;

        public static SymbolTableType fromFile(String fileName) throws IOException {
            return new SymbolTableType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SymbolTableType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SymbolTableType(KaitaiStream _io, LinkingCustomSubsectionType _parent) {
            this(_io, _parent, null);
        }

        public SymbolTableType(KaitaiStream _io, LinkingCustomSubsectionType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.infos = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.infos.add(new SyminfoType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<SyminfoType> infos() {
            return this.infos;
        }

        public Webassembly _root() {
            return this._root;
        }

        public LinkingCustomSubsectionType _parent() {
            return this._parent;
        }
    }

    public static class LinkingCustomType
    extends KaitaiStruct {
        private VlqBase128Le version;
        private ArrayList<LinkingCustomSubsectionType> subsections;
        private Webassembly _root;
        private UnimplementedSection _parent;

        public static LinkingCustomType fromFile(String fileName) throws IOException {
            return new LinkingCustomType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public LinkingCustomType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public LinkingCustomType(KaitaiStream _io, UnimplementedSection _parent) {
            this(_io, _parent, null);
        }

        public LinkingCustomType(KaitaiStream _io, UnimplementedSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.version = new VlqBase128Le(this._io);
            this.subsections = new ArrayList();
            int i = 0;
            while (!this._io.isEof()) {
                this.subsections.add(new LinkingCustomSubsectionType(this._io, this, this._root));
                ++i;
            }
        }

        public VlqBase128Le version() {
            return this.version;
        }

        public ArrayList<LinkingCustomSubsectionType> subsections() {
            return this.subsections;
        }

        public Webassembly _root() {
            return this._root;
        }

        public UnimplementedSection _parent() {
            return this._parent;
        }
    }

    public static class FunctionBodyDataType
    extends KaitaiStruct {
        private VlqBase128Le localCount;
        private ArrayList<LocalEntryType> locals;
        private byte[] code;
        private Webassembly _root;
        private FunctionBodyType _parent;

        public static FunctionBodyDataType fromFile(String fileName) throws IOException {
            return new FunctionBodyDataType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public FunctionBodyDataType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public FunctionBodyDataType(KaitaiStream _io, FunctionBodyType _parent) {
            this(_io, _parent, null);
        }

        public FunctionBodyDataType(KaitaiStream _io, FunctionBodyType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.localCount = new VlqBase128Le(this._io);
            this.locals = new ArrayList(this.localCount().value());
            for (int i = 0; i < this.localCount().value(); ++i) {
                this.locals.add(new LocalEntryType(this._io, this, this._root));
            }
            this.code = this._io.readBytesFull();
        }

        public VlqBase128Le localCount() {
            return this.localCount;
        }

        public ArrayList<LocalEntryType> locals() {
            return this.locals;
        }

        public byte[] code() {
            return this.code;
        }

        public Webassembly _root() {
            return this._root;
        }

        public FunctionBodyType _parent() {
            return this._parent;
        }
    }

    public static class ExportEntryType
    extends KaitaiStruct {
        private VlqBase128Le fieldLen;
        private String fieldStr;
        private KindType kind;
        private VlqBase128Le index;
        private Webassembly _root;
        private ExportSection _parent;

        public static ExportEntryType fromFile(String fileName) throws IOException {
            return new ExportEntryType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ExportEntryType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ExportEntryType(KaitaiStream _io, ExportSection _parent) {
            this(_io, _parent, null);
        }

        public ExportEntryType(KaitaiStream _io, ExportSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.fieldLen = new VlqBase128Le(this._io);
            this.fieldStr = new String(this._io.readBytes((long)this.fieldLen().value().intValue()), Charset.forName("UTF-8"));
            this.kind = KindType.byId(this._io.readU1());
            this.index = new VlqBase128Le(this._io);
        }

        public VlqBase128Le fieldLen() {
            return this.fieldLen;
        }

        public String fieldStr() {
            return this.fieldStr;
        }

        public KindType kind() {
            return this.kind;
        }

        public VlqBase128Le index() {
            return this.index;
        }

        public Webassembly _root() {
            return this._root;
        }

        public ExportSection _parent() {
            return this._parent;
        }
    }

    public static class DataSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<DataSegmentType> entries;
        private Webassembly _root;
        private Section _parent;

        public static DataSection fromFile(String fileName) throws IOException {
            return new DataSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DataSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DataSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public DataSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.entries = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.entries.add(new DataSegmentType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<DataSegmentType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class Section
    extends KaitaiStruct {
        private SectionHeader header;
        private KaitaiStruct payloadData;
        private Webassembly _root;
        private Sections _parent;

        public static Section fromFile(String fileName) throws IOException {
            return new Section((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public Section(KaitaiStream _io) {
            this(_io, null, null);
        }

        public Section(KaitaiStream _io, Sections _parent) {
            this(_io, _parent, null);
        }

        public Section(KaitaiStream _io, Sections _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.header = new SectionHeader(this._io, this, this._root);
            PayloadType on = this.header().id();
            if (on != null) {
                switch (this.header().id()) {
                    case START_PAYLOAD: {
                        this.payloadData = new StartSection(this._io, this, this._root);
                        break;
                    }
                    case TYPE_PAYLOAD: {
                        this.payloadData = new TypeSection(this._io, this, this._root);
                        break;
                    }
                    case IMPORT_PAYLOAD: {
                        this.payloadData = new ImportSection(this._io, this, this._root);
                        break;
                    }
                    case TABLE_PAYLOAD: {
                        this.payloadData = new TableSection(this._io, this, this._root);
                        break;
                    }
                    case GLOBAL_PAYLOAD: {
                        this.payloadData = new GlobalSection(this._io, this, this._root);
                        break;
                    }
                    case FUNCTION_PAYLOAD: {
                        this.payloadData = new FunctionSection(this._io, this, this._root);
                        break;
                    }
                    case ELEMENT_PAYLOAD: {
                        this.payloadData = new ElementSection(this._io, this, this._root);
                        break;
                    }
                    case DATA_COUNT_PAYLOAD: {
                        this.payloadData = new DataCountSection(this._io, this, this._root);
                        break;
                    }
                    case EXPORT_PAYLOAD: {
                        this.payloadData = new ExportSection(this._io, this, this._root);
                        break;
                    }
                    case MEMORY_PAYLOAD: {
                        this.payloadData = new MemorySection(this._io, this, this._root);
                        break;
                    }
                    case CODE_PAYLOAD: {
                        this.payloadData = new CodeSection(this._io, this, this._root);
                        break;
                    }
                    case DATA_PAYLOAD: {
                        this.payloadData = new DataSection(this._io, this, this._root);
                        break;
                    }
                    case CUSTOM_PAYLOAD: {
                        this.payloadData = new UnimplementedSection(this._io, this, this._root);
                    }
                }
            }
        }

        public SectionHeader header() {
            return this.header;
        }

        public KaitaiStruct payloadData() {
            return this.payloadData;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Sections _parent() {
            return this._parent;
        }
    }

    public static class SectionHeader
    extends KaitaiStruct {
        private PayloadType id;
        private VlqBase128Le payloadLen;
        private Webassembly _root;
        private Section _parent;

        public static SectionHeader fromFile(String fileName) throws IOException {
            return new SectionHeader((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SectionHeader(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SectionHeader(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public SectionHeader(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.id = PayloadType.byId(this._io.readU1());
            this.payloadLen = new VlqBase128Le(this._io);
        }

        public PayloadType id() {
            return this.id;
        }

        public VlqBase128Le payloadLen() {
            return this.payloadLen;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class TableSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<TableType> entries;
        private Webassembly _root;
        private Section _parent;

        public static TableSection fromFile(String fileName) throws IOException {
            return new TableSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public TableSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public TableSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public TableSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.entries = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.entries.add(new TableType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<TableType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class FuncType
    extends KaitaiStruct {
        private ConstructorType form;
        private int paramCount;
        private ArrayList<ValueType> paramTypes;
        private int returnCount;
        private ValueType returnType;
        private Webassembly _root;
        private TypeSection _parent;

        public static FuncType fromFile(String fileName) throws IOException {
            return new FuncType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public FuncType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public FuncType(KaitaiStream _io, TypeSection _parent) {
            this(_io, _parent, null);
        }

        public FuncType(KaitaiStream _io, TypeSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.form = ConstructorType.byId(this._io.readU1());
            this.paramCount = this._io.readU1();
            if (this.paramCount() > 0) {
                this.paramTypes = new ArrayList(this.paramCount());
                for (int i = 0; i < this.paramCount(); ++i) {
                    this.paramTypes.add(ValueType.byId(this._io.readU1()));
                }
            }
            this.returnCount = this._io.readU1();
            if (this.returnCount() == 1) {
                this.returnType = ValueType.byId(this._io.readU1());
            }
        }

        public ConstructorType form() {
            return this.form;
        }

        public int paramCount() {
            return this.paramCount;
        }

        public ArrayList<ValueType> paramTypes() {
            return this.paramTypes;
        }

        public int returnCount() {
            return this.returnCount;
        }

        public ValueType returnType() {
            return this.returnType;
        }

        public Webassembly _root() {
            return this._root;
        }

        public TypeSection _parent() {
            return this._parent;
        }
    }

    public static class SyminfoType
    extends KaitaiStruct {
        private Symtab kind;
        private VlqBase128Le flags;
        private SyminfoData data;
        private SyminfoExt ext;
        private SyminfoSection section;
        private Webassembly _root;
        private SymbolTableType _parent;

        public static SyminfoType fromFile(String fileName) throws IOException {
            return new SyminfoType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SyminfoType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SyminfoType(KaitaiStream _io, SymbolTableType _parent) {
            this(_io, _parent, null);
        }

        public SyminfoType(KaitaiStream _io, SymbolTableType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.kind = Symtab.byId(this._io.readU1());
            this.flags = new VlqBase128Le(this._io);
            if (this.kind() == Symtab.DATA) {
                this.data = new SyminfoData(this._io, this, this._root);
            }
            if (this.kind() == Symtab.FUNCTION || this.kind() == Symtab.GLOBAL || this.kind() == Symtab.EVENT || this.kind() == Symtab.TABLE) {
                this.ext = new SyminfoExt(this._io, this, this._root);
            }
            if (this.kind() == Symtab.SECTION) {
                this.section = new SyminfoSection(this._io, this, this._root);
            }
        }

        public Symtab kind() {
            return this.kind;
        }

        public VlqBase128Le flags() {
            return this.flags;
        }

        public SyminfoData data() {
            return this.data;
        }

        public SyminfoExt ext() {
            return this.ext;
        }

        public SyminfoSection section() {
            return this.section;
        }

        public Webassembly _root() {
            return this._root;
        }

        public SymbolTableType _parent() {
            return this._parent;
        }
    }

    public static class SyminfoData
    extends KaitaiStruct {
        private VlqBase128Le nameLen;
        private String nameData;
        private VlqBase128Le index;
        private VlqBase128Le offset;
        private VlqBase128Le size;
        private Webassembly _root;
        private SyminfoType _parent;

        public static SyminfoData fromFile(String fileName) throws IOException {
            return new SyminfoData((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public SyminfoData(KaitaiStream _io) {
            this(_io, null, null);
        }

        public SyminfoData(KaitaiStream _io, SyminfoType _parent) {
            this(_io, _parent, null);
        }

        public SyminfoData(KaitaiStream _io, SyminfoType _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.nameLen = new VlqBase128Le(this._io);
            this.nameData = new String(this._io.readBytes((long)this.nameLen().value().intValue()), Charset.forName("UTF-8"));
            if (((long)this._parent().flags().value().intValue() & Symflag.UNDEFINED.id()) == 0L) {
                this.index = new VlqBase128Le(this._io);
            }
            if (((long)this._parent().flags().value().intValue() & Symflag.UNDEFINED.id()) == 0L) {
                this.offset = new VlqBase128Le(this._io);
            }
            if (((long)this._parent().flags().value().intValue() & Symflag.UNDEFINED.id()) == 0L) {
                this.size = new VlqBase128Le(this._io);
            }
        }

        public VlqBase128Le nameLen() {
            return this.nameLen;
        }

        public String nameData() {
            return this.nameData;
        }

        public VlqBase128Le index() {
            return this.index;
        }

        public VlqBase128Le offset() {
            return this.offset;
        }

        public VlqBase128Le size() {
            return this.size;
        }

        public Webassembly _root() {
            return this._root;
        }

        public SyminfoType _parent() {
            return this._parent;
        }
    }

    public static class MemoryType
    extends KaitaiStruct {
        private ResizableLimitsType limits;
        private Webassembly _root;
        private KaitaiStruct _parent;

        public static MemoryType fromFile(String fileName) throws IOException {
            return new MemoryType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public MemoryType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public MemoryType(KaitaiStream _io, KaitaiStruct _parent) {
            this(_io, _parent, null);
        }

        public MemoryType(KaitaiStream _io, KaitaiStruct _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.limits = new ResizableLimitsType(this._io, this, this._root);
        }

        public ResizableLimitsType limits() {
            return this.limits;
        }

        public Webassembly _root() {
            return this._root;
        }

        public KaitaiStruct _parent() {
            return this._parent;
        }
    }

    public static class ExportSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<ExportEntryType> entries;
        private Webassembly _root;
        private Section _parent;

        public static ExportSection fromFile(String fileName) throws IOException {
            return new ExportSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ExportSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ExportSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public ExportSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.entries = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.entries.add(new ExportEntryType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<ExportEntryType> entries() {
            return this.entries;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class ImportEntry
    extends KaitaiStruct {
        private VlqBase128Le moduleLen;
        private String moduleStr;
        private VlqBase128Le fieldLen;
        private String fieldStr;
        private KindType kind;
        private KaitaiStruct type;
        private Webassembly _root;
        private ImportSection _parent;

        public static ImportEntry fromFile(String fileName) throws IOException {
            return new ImportEntry((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public ImportEntry(KaitaiStream _io) {
            this(_io, null, null);
        }

        public ImportEntry(KaitaiStream _io, ImportSection _parent) {
            this(_io, _parent, null);
        }

        public ImportEntry(KaitaiStream _io, ImportSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.moduleLen = new VlqBase128Le(this._io);
            this.moduleStr = new String(this._io.readBytes((long)this.moduleLen().value().intValue()), Charset.forName("UTF-8"));
            this.fieldLen = new VlqBase128Le(this._io);
            this.fieldStr = new String(this._io.readBytes((long)this.fieldLen().value().intValue()), Charset.forName("UTF-8"));
            this.kind = KindType.byId(this._io.readU1());
            KindType on = this.kind();
            if (on != null) {
                switch (this.kind()) {
                    case FUNCTION_KIND: {
                        this.type = new VlqBase128Le(this._io);
                        break;
                    }
                    case TABLE_KIND: {
                        this.type = new TableType(this._io, this, this._root);
                        break;
                    }
                    case MEMORY_KIND: {
                        this.type = new MemoryType(this._io, this, this._root);
                        break;
                    }
                    case GLOBAL_KIND: {
                        this.type = new GlobalType(this._io, this, this._root);
                    }
                }
            }
        }

        public VlqBase128Le moduleLen() {
            return this.moduleLen;
        }

        public String moduleStr() {
            return this.moduleStr;
        }

        public VlqBase128Le fieldLen() {
            return this.fieldLen;
        }

        public String fieldStr() {
            return this.fieldStr;
        }

        public KindType kind() {
            return this.kind;
        }

        public KaitaiStruct type() {
            return this.type;
        }

        public Webassembly _root() {
            return this._root;
        }

        public ImportSection _parent() {
            return this._parent;
        }
    }

    public static class CodeSection
    extends KaitaiStruct {
        private VlqBase128Le count;
        private ArrayList<FunctionBodyType> bodies;
        private Webassembly _root;
        private Section _parent;

        public static CodeSection fromFile(String fileName) throws IOException {
            return new CodeSection((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public CodeSection(KaitaiStream _io) {
            this(_io, null, null);
        }

        public CodeSection(KaitaiStream _io, Section _parent) {
            this(_io, _parent, null);
        }

        public CodeSection(KaitaiStream _io, Section _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.count = new VlqBase128Le(this._io);
            this.bodies = new ArrayList(this.count().value());
            for (int i = 0; i < this.count().value(); ++i) {
                this.bodies.add(new FunctionBodyType(this._io, this, this._root));
            }
        }

        public VlqBase128Le count() {
            return this.count;
        }

        public ArrayList<FunctionBodyType> bodies() {
            return this.bodies;
        }

        public Webassembly _root() {
            return this._root;
        }

        public Section _parent() {
            return this._parent;
        }
    }

    public static class DataSegmentType
    extends KaitaiStruct {
        private VlqBase128Le type;
        private int offsetExprOpcode;
        private VlqBase128Le offsetExprArg;
        private byte[] terminator;
        private VlqBase128Le size;
        private ArrayList<Integer> data;
        private Webassembly _root;
        private DataSection _parent;

        public static DataSegmentType fromFile(String fileName) throws IOException {
            return new DataSegmentType((KaitaiStream)new ByteBufferKaitaiStream(fileName));
        }

        public DataSegmentType(KaitaiStream _io) {
            this(_io, null, null);
        }

        public DataSegmentType(KaitaiStream _io, DataSection _parent) {
            this(_io, _parent, null);
        }

        public DataSegmentType(KaitaiStream _io, DataSection _parent, Webassembly _root) {
            super(_io);
            this._parent = _parent;
            this._root = _root;
            this._read();
        }

        private void _read() {
            this.type = new VlqBase128Le(this._io);
            this.offsetExprOpcode = this._io.readU1();
            this.offsetExprArg = new VlqBase128Le(this._io);
            this.terminator = this._io.readBytes(1L);
            if (!Arrays.equals(this.terminator(), new byte[]{11})) {
                throw new KaitaiStream.ValidationNotEqualError(new byte[]{11}, this.terminator(), this._io(), "/types/data_segment_type/seq/3");
            }
            this.size = new VlqBase128Le(this._io);
            this.data = new ArrayList(this.size().value());
            for (int i = 0; i < this.size().value(); ++i) {
                this.data.add(this._io.readU1());
            }
        }

        public VlqBase128Le type() {
            return this.type;
        }

        public int offsetExprOpcode() {
            return this.offsetExprOpcode;
        }

        public VlqBase128Le offsetExprArg() {
            return this.offsetExprArg;
        }

        public byte[] terminator() {
            return this.terminator;
        }

        public VlqBase128Le size() {
            return this.size;
        }

        public ArrayList<Integer> data() {
            return this.data;
        }

        public Webassembly _root() {
            return this._root;
        }

        public DataSection _parent() {
            return this._parent;
        }
    }

    public static enum Symtab {
        FUNCTION(0L),
        DATA(1L),
        GLOBAL(2L),
        SECTION(3L),
        EVENT(4L),
        TABLE(5L);

        private final long id;
        private static final Map<Long, Symtab> byId;

        private Symtab(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static Symtab byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, Symtab>(6);
            for (Symtab e : Symtab.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum PayloadType {
        CUSTOM_PAYLOAD(0L),
        TYPE_PAYLOAD(1L),
        IMPORT_PAYLOAD(2L),
        FUNCTION_PAYLOAD(3L),
        TABLE_PAYLOAD(4L),
        MEMORY_PAYLOAD(5L),
        GLOBAL_PAYLOAD(6L),
        EXPORT_PAYLOAD(7L),
        START_PAYLOAD(8L),
        ELEMENT_PAYLOAD(9L),
        CODE_PAYLOAD(10L),
        DATA_PAYLOAD(11L),
        DATA_COUNT_PAYLOAD(12L);

        private final long id;
        private static final Map<Long, PayloadType> byId;

        private PayloadType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static PayloadType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, PayloadType>(13);
            for (PayloadType e : PayloadType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum MutabilityFlag {
        IMMUTABLE(0L),
        MUTABLE(1L);

        private final long id;
        private static final Map<Long, MutabilityFlag> byId;

        private MutabilityFlag(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static MutabilityFlag byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, MutabilityFlag>(2);
            for (MutabilityFlag e : MutabilityFlag.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum KindType {
        FUNCTION_KIND(0L),
        TABLE_KIND(1L),
        MEMORY_KIND(2L),
        GLOBAL_KIND(3L);

        private final long id;
        private static final Map<Long, KindType> byId;

        private KindType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static KindType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, KindType>(4);
            for (KindType e : KindType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum Symflag {
        BINDING_WEAK(1L),
        BINDING_LOCAL(2L),
        VISIBILITY_HIDDEN(4L),
        UNDEFINED(16L),
        EXPORTED(32L),
        EXPLICIT_NAME(64L),
        NO_STRIP(128L);

        private final long id;
        private static final Map<Long, Symflag> byId;

        private Symflag(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static Symflag byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, Symflag>(7);
            for (Symflag e : Symflag.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum ConstructorType {
        EMPTY_BLOCK(64L),
        FUNC(96L),
        ANYFUNC(112L),
        F64(124L),
        F32(125L),
        I64(126L),
        I32(127L);

        private final long id;
        private static final Map<Long, ConstructorType> byId;

        private ConstructorType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static ConstructorType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, ConstructorType>(7);
            for (ConstructorType e : ConstructorType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum LinkingMetadataPayloadType {
        SEGMENT_INFO(5L),
        INIT_FUNCS(6L),
        COMDAT_INFO(7L),
        SYMBOL_TABLE(8L);

        private final long id;
        private static final Map<Long, LinkingMetadataPayloadType> byId;

        private LinkingMetadataPayloadType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static LinkingMetadataPayloadType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, LinkingMetadataPayloadType>(4);
            for (LinkingMetadataPayloadType e : LinkingMetadataPayloadType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum ValueType {
        F64(124L),
        F32(125L),
        I64(126L),
        I32(127L);

        private final long id;
        private static final Map<Long, ValueType> byId;

        private ValueType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static ValueType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, ValueType>(4);
            for (ValueType e : ValueType.values()) {
                byId.put(e.id(), e);
            }
        }
    }

    public static enum ElemType {
        ANYFUNC(112L);

        private final long id;
        private static final Map<Long, ElemType> byId;

        private ElemType(long id) {
            this.id = id;
        }

        public long id() {
            return this.id;
        }

        public static ElemType byId(long id) {
            return byId.get(id);
        }

        static {
            byId = new HashMap<Long, ElemType>(1);
            for (ElemType e : ElemType.values()) {
                byId.put(e.id(), e);
            }
        }
    }
}

