/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.Commentable;
import org.qbicc.machine.llvm.impl.AbstractEmittable;

abstract class AbstractCommentable
extends AbstractEmittable
implements Commentable {
    Comment lastComment;

    AbstractCommentable() {
    }

    @Override
    public Commentable comment(String comment) {
        Assert.checkNotNullParam((String)"comment", (Object)comment);
        if (comment.indexOf(10) != -1 || comment.indexOf(13) != -1) {
            throw new IllegalArgumentException("Multi-line comments not supported");
        }
        this.lastComment = new Comment(this.lastComment, comment);
        return this;
    }

    Appendable appendTrailer(Appendable target) throws IOException {
        return this.appendComment(target);
    }

    Appendable appendComment(Appendable target) throws IOException {
        Comment item = this.lastComment;
        if (item != null) {
            item.appendTo(target);
        }
        return target;
    }

    private static final class Comment
    extends AbstractEmittable {
        final Comment prev;
        final String text;

        Comment(Comment prev, String text) {
            this.prev = prev;
            this.text = text;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
                target.append(System.lineSeparator());
                target.append(' ').append(' ').append(' ');
            }
            target.append(' ').append(';').append(' ').append(this.text);
            return target;
        }
    }
}

