/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOError;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DISPFlags;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.Emittable;

abstract class AbstractEmittable
implements Emittable {
    AbstractEmittable() {
    }

    @Override
    public abstract Appendable appendTo(Appendable var1) throws IOException;

    static Appendable appendValue(Appendable target, LLValue value) throws IOException {
        return ((AbstractValue)value).appendTo(target);
    }

    public final StringBuilder toString(StringBuilder b) {
        try {
            this.appendTo(b);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return b;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    static char hexDigit(int val) {
        if ((val &= 0xF) <= 9) {
            return (char)(48 + val);
        }
        return (char)(55 + val);
    }

    static <A extends Appendable> A appendHex(A target, int val) throws IOException {
        char v = AbstractEmittable.hexDigit(val >>> 28);
        if (v != '0') {
            target.append(v);
            target.append(AbstractEmittable.hexDigit(val >>> 24));
            target.append(AbstractEmittable.hexDigit(val >>> 20));
            target.append(AbstractEmittable.hexDigit(val >>> 16));
            target.append(AbstractEmittable.hexDigit(val >>> 12));
            target.append(AbstractEmittable.hexDigit(val >>> 8));
            target.append(AbstractEmittable.hexDigit(val >>> 4));
            target.append(AbstractEmittable.hexDigit(val >>> 0));
        } else {
            v = AbstractEmittable.hexDigit(val >>> 24);
            if (v != '0') {
                target.append(v);
                target.append(AbstractEmittable.hexDigit(val >>> 20));
                target.append(AbstractEmittable.hexDigit(val >>> 16));
                target.append(AbstractEmittable.hexDigit(val >>> 12));
                target.append(AbstractEmittable.hexDigit(val >>> 8));
                target.append(AbstractEmittable.hexDigit(val >>> 4));
                target.append(AbstractEmittable.hexDigit(val >>> 0));
            } else {
                v = AbstractEmittable.hexDigit(val >>> 20);
                if (v != '0') {
                    target.append(v);
                    target.append(AbstractEmittable.hexDigit(val >>> 16));
                    target.append(AbstractEmittable.hexDigit(val >>> 12));
                    target.append(AbstractEmittable.hexDigit(val >>> 8));
                    target.append(AbstractEmittable.hexDigit(val >>> 4));
                    target.append(AbstractEmittable.hexDigit(val >>> 0));
                } else {
                    v = AbstractEmittable.hexDigit(val >>> 16);
                    if (v != '0') {
                        target.append(v);
                        target.append(AbstractEmittable.hexDigit(val >>> 12));
                        target.append(AbstractEmittable.hexDigit(val >>> 8));
                        target.append(AbstractEmittable.hexDigit(val >>> 4));
                        target.append(AbstractEmittable.hexDigit(val >>> 0));
                    } else {
                        v = AbstractEmittable.hexDigit(val >>> 12);
                        if (v != '0') {
                            target.append(v);
                            target.append(AbstractEmittable.hexDigit(val >>> 8));
                            target.append(AbstractEmittable.hexDigit(val >>> 4));
                            target.append(AbstractEmittable.hexDigit(val >>> 0));
                        } else {
                            v = AbstractEmittable.hexDigit(val >>> 8);
                            if (v != '0') {
                                target.append(v);
                                target.append(AbstractEmittable.hexDigit(val >>> 4));
                                target.append(AbstractEmittable.hexDigit(val >>> 0));
                            } else {
                                v = AbstractEmittable.hexDigit(val >>> 4);
                                if (v != '0') {
                                    target.append(v);
                                    target.append(AbstractEmittable.hexDigit(val >>> 0));
                                } else {
                                    target.append(AbstractEmittable.hexDigit(val));
                                }
                            }
                        }
                    }
                }
            }
        }
        return target;
    }

    static <A extends Appendable> A appendDecimal(A target, long val) throws IOException {
        target.append(Long.toString(val));
        return target;
    }

    static <A extends Appendable> A appendHex(A target, double val) throws IOException {
        target.append("0x" + Long.toHexString(Double.doubleToRawLongBits(val)));
        return target;
    }

    static <A extends Appendable> A appendHex(A target, float val) throws IOException {
        return AbstractEmittable.appendHex(target, (double)val);
    }

    static <A extends Appendable> A appendEscapedString(A target, String val) throws IOException {
        byte[] valBytes = val.getBytes(StandardCharsets.UTF_8);
        target.append('\"');
        for (byte b : valBytes) {
            if (b < 32 || b > 126 || b == 34 || b == 92) {
                target.append('\\');
                target.append(AbstractEmittable.hexDigit(b >>> 4));
                target.append(AbstractEmittable.hexDigit(b & 0xF));
                continue;
            }
            target.append((char)b);
        }
        target.append('\"');
        return target;
    }

    static <A extends Appendable> A appendDiFlags(A target, EnumSet<DIFlags> flags) throws IOException {
        if (flags.isEmpty()) {
            target.append("DIFlagZero");
        } else {
            boolean first = true;
            for (DIFlags flag : flags) {
                if (first) {
                    first = false;
                } else {
                    target.append(" | ");
                }
                target.append(flag.name);
            }
        }
        return target;
    }

    static <A extends Appendable> A appendDiSpFlags(A target, EnumSet<DISPFlags> flags) throws IOException {
        if (flags.isEmpty()) {
            target.append("DISPFlagZero");
        } else {
            boolean first = true;
            for (DISPFlags flag : flags) {
                if (first) {
                    first = false;
                } else {
                    target.append(" | ");
                }
                target.append(flag.name);
            }
        }
        return target;
    }
}

