/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Metable;
import org.qbicc.machine.llvm.impl.AbstractCommentable;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;

abstract class AbstractMetable
extends AbstractCommentable
implements Metable {
    MetaItem lastMetaItem;
    boolean metaHasComma;

    AbstractMetable() {
    }

    @Override
    public Metable meta(String name, LLValue data) {
        Assert.checkNotNullParam((String)"name", (Object)name);
        Assert.checkNotNullParam((String)"data", (Object)data);
        this.lastMetaItem = new MetaItem(this, this.lastMetaItem, name, (AbstractValue)data);
        return this;
    }

    @Override
    public Metable comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    Appendable appendTrailer(Appendable target) throws IOException {
        this.appendMeta(target);
        return super.appendTrailer(target);
    }

    Appendable appendMeta(Appendable target) throws IOException {
        MetaItem item = this.lastMetaItem;
        if (item != null) {
            item.appendTo(target);
        }
        return target;
    }

    static final class MetaItem
    extends AbstractEmittable {
        final AbstractMetable parent;
        final MetaItem prev;
        final String name;
        final AbstractValue metaValue;

        MetaItem(AbstractMetable parent, MetaItem prev, String name, AbstractValue metaValue) {
            this.parent = parent;
            this.prev = prev;
            this.name = name;
            this.metaValue = metaValue;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
            }
            if (this.parent.metaHasComma) {
                target.append(',');
            }
            target.append(' ').append('!').append(this.name).append(' ');
            this.metaValue.appendTo(target);
            return target;
        }
    }
}

