/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.qbicc.machine.llvm.FunctionDefinition;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.FunctionDefinitionImpl;

final class BasicBlockImpl
extends AbstractEmittable
implements LLBasicBlock {
    final BasicBlockImpl prev;
    final FunctionDefinitionImpl func;
    final List<AbstractEmittable> phis = new ArrayList<AbstractEmittable>();
    final List<AbstractEmittable> items = new ArrayList<AbstractEmittable>();
    AbstractEmittable terminator;
    String name;

    BasicBlockImpl(BasicBlockImpl prev, FunctionDefinitionImpl func) {
        this.prev = prev;
        this.func = func;
    }

    @Override
    public LLBasicBlock name(String name) {
        this.name = (String)Assert.checkNotNullParam((String)"name", (Object)name);
        return this;
    }

    @Override
    public FunctionDefinition functionDefinition() {
        return this.func;
    }

    Appendable appendAsBlockTo(Appendable target) throws IOException {
        BasicBlockImpl prev = this.prev;
        if (prev != null) {
            prev.appendAsBlockTo(target);
        }
        if (this.phis.isEmpty() && this.items.isEmpty() && this.terminator == null) {
            return target;
        }
        if (this.terminator == null) {
            throw new IllegalStateException("Basic block not terminated");
        }
        if (this != this.func.rootBlock) {
            if (this.name == null) {
                this.func.assignName(this);
            }
            target.append(this.name).append(':').append(System.lineSeparator());
        }
        for (List<AbstractEmittable> list : List.of(this.phis, this.items)) {
            for (AbstractEmittable item : list) {
                target.append("  ");
                item.appendTo(target);
                target.append(System.lineSeparator());
            }
        }
        target.append("  ");
        this.terminator.appendTo(target);
        target.append(System.lineSeparator());
        return target;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append('%');
        if (this == this.func.rootBlock) {
            target.append('0');
        } else {
            if (this.name == null) {
                this.func.assignName(this);
            }
            target.append(this.name);
        }
        return target;
    }
}

