/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class ByteArrayImpl
extends AbstractValue {
    final byte[] contents;

    ByteArrayImpl(byte[] contents) {
        this.contents = contents;
    }

    private static char hex(int v) {
        if ((v &= 0xF) <= 9) {
            return (char)(48 + v);
        }
        return (char)(65 + v - 10);
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append('c').append('\"');
        for (int i = 0; i < this.contents.length; ++i) {
            int ch = this.contents[i] & 0xFF;
            if (32 <= ch && ch <= 126 && ch != 92 && ch != 34) {
                target.append((char)ch);
                continue;
            }
            target.append('\\').append(ByteArrayImpl.hex(ch >> 4)).append(ByteArrayImpl.hex(ch));
        }
        target.append('\"');
        return target;
    }
}

