/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.EnumSet;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.debuginfo.DICompositeType;
import org.qbicc.machine.llvm.debuginfo.DIFlags;
import org.qbicc.machine.llvm.debuginfo.DITag;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

public class DICompositeTypeImpl
extends AbstractMetadataNode
implements DICompositeType {
    private final DITag tag;
    private final long size;
    private final int align;
    private AbstractValue elements;
    private AbstractValue baseType;
    private String name;
    private EnumSet<DIFlags> flags = EnumSet.noneOf(DIFlags.class);
    private AbstractValue file;
    private int line;

    DICompositeTypeImpl(int index, DITag tag, long size, int align) {
        super(index);
        this.tag = tag;
        this.size = size;
        this.align = align;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("!DICompositeType(tag: ");
        target.append(this.tag.name);
        target.append(", size: ");
        DICompositeTypeImpl.appendDecimal(target, this.size);
        target.append(", align: ");
        DICompositeTypeImpl.appendDecimal(target, this.align);
        target.append(", elements: ");
        if (this.elements != null) {
            this.elements.appendTo(target);
        } else {
            target.append("null");
        }
        if (this.baseType != null) {
            target.append(", baseType: ");
            this.baseType.appendTo(target);
        }
        if (this.name != null) {
            target.append(", name: ");
            DICompositeTypeImpl.appendEscapedString(target, this.name);
        }
        if (!this.flags.isEmpty()) {
            target.append(", flags: ");
            DICompositeTypeImpl.appendDiFlags(target, this.flags);
        }
        if (this.file != null) {
            target.append(", file: ");
            this.file.appendTo(target);
            target.append(", line: ");
            DICompositeTypeImpl.appendDecimal(target, this.line);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DICompositeType elements(LLValue elements) {
        this.elements = (AbstractValue)elements;
        return this;
    }

    @Override
    public DICompositeType baseType(LLValue baseType) {
        this.baseType = (AbstractValue)baseType;
        return this;
    }

    @Override
    public DICompositeType name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DICompositeType flags(EnumSet<DIFlags> flags) {
        Assert.checkNotNullParam((String)"flags", flags);
        this.flags = flags;
        return this;
    }

    @Override
    public DICompositeType location(LLValue file, int line) {
        this.file = (AbstractValue)file;
        this.line = line;
        return this;
    }

    @Override
    public DICompositeType comment(String comment) {
        return (DICompositeType)super.comment(comment);
    }
}

