/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.debuginfo.DILocation;
import org.qbicc.machine.llvm.impl.AbstractMetadataNode;
import org.qbicc.machine.llvm.impl.AbstractValue;

public class DILocationImpl
extends AbstractMetadataNode
implements DILocation {
    private final int line;
    private final int column;
    private final AbstractValue scope;
    private final AbstractValue inlinedAt;
    private boolean distinct;

    DILocationImpl(int index, int line, int column, AbstractValue scope, AbstractValue inlinedAt) {
        super(index);
        this.line = line;
        this.column = column;
        this.scope = scope;
        this.inlinedAt = inlinedAt;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        if (this.distinct) {
            target.append("distinct ");
        }
        target.append("!DILocation(line: ");
        DILocationImpl.appendDecimal(target, this.line);
        target.append(", column: ");
        DILocationImpl.appendDecimal(target, this.column);
        target.append(", scope: ");
        this.scope.appendTo(target);
        if (this.inlinedAt != null) {
            target.append(", inlinedAt: ");
            this.inlinedAt.appendTo(target);
        }
        target.append(')');
        return this.appendTrailer(target);
    }

    @Override
    public DILocation comment(String comment) {
        return (DILocation)super.comment(comment);
    }

    @Override
    public DILocation distinct(boolean distinct) {
        this.distinct = distinct;
        return this;
    }
}

