/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractBranch;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.Emittable;
import org.qbicc.machine.llvm.op.IndirectBranch;

final class IndirectBranchImpl
extends AbstractBranch
implements IndirectBranch {
    final AbstractValue address;
    Target last;

    IndirectBranchImpl(AbstractValue address) {
        this.address = address;
    }

    @Override
    public IndirectBranch meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public IndirectBranch comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public IndirectBranch possibleTarget(LLBasicBlock target) {
        this.last = new Target((BasicBlockImpl)Assert.checkNotNullParam((String)"target", (Object)((BasicBlockImpl)target)), this.last);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        target.append("indirect");
        super.appendTo(target);
        target.append(' ');
        target.append("ptr");
        target.append(' ');
        this.address.appendTo(target);
        target.append(',');
        target.append(' ');
        target.append('[');
        Target last = this.last;
        if (last != null) {
            target.append(' ');
            last.appendTo(target);
            target.append(' ');
        }
        target.append(']');
        return target;
    }

    static class Target
    implements Emittable {
        final BasicBlockImpl block;
        final Target prev;

        Target(BasicBlockImpl block, Target prev) {
            this.block = block;
            this.prev = prev;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
                target.append(',');
                target.append(' ');
            }
            target.append("label");
            target.append(' ');
            this.block.appendTo(target);
            return target;
        }
    }
}

