/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.ExtractValue;

final class InsertValueImpl
extends AbstractYieldingInstruction
implements ExtractValue {
    private final AbstractValue aggregateType;
    private final AbstractValue aggregate;
    private final AbstractValue insertType;
    private final AbstractValue insert;
    ArgImpl lastArg;

    InsertValueImpl(BasicBlockImpl basicBlock, AbstractValue aggregateType, AbstractValue aggregate, AbstractValue insertType, AbstractValue insert) {
        super(basicBlock);
        this.aggregateType = aggregateType;
        this.aggregate = aggregate;
        this.insertType = insertType;
        this.insert = insert;
    }

    @Override
    public ExtractValue comment(String comment) {
        return (ExtractValue)super.comment(comment);
    }

    @Override
    public ExtractValue meta(String name, LLValue data) {
        return (ExtractValue)super.meta(name, data);
    }

    @Override
    public ExtractValue arg(LLValue index) {
        Assert.checkNotNullParam((String)"index", (Object)index);
        this.lastArg = new ArgImpl((AbstractValue)index, this.lastArg);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("insertvalue");
        target.append(' ');
        this.aggregateType.appendTo(target);
        target.append(' ');
        this.aggregate.appendTo(target);
        target.append(',');
        target.append(' ');
        this.insertType.appendTo(target);
        target.append(' ');
        this.insert.appendTo(target);
        ArgImpl lastArg = this.lastArg;
        if (lastArg != null) {
            lastArg.appendTo(target);
        }
        return target;
    }

    static final class ArgImpl
    extends AbstractEmittable {
        final AbstractValue index;
        final ArgImpl prev;

        ArgImpl(AbstractValue index, ArgImpl prev) {
            this.index = index;
            this.prev = prev;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            ArgImpl prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
            }
            target.append(',');
            target.append(' ');
            this.index.appendTo(target);
            return target;
        }
    }
}

