/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.qbicc.machine.llvm.Array;
import org.qbicc.machine.llvm.AsmFlag;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLBuilder;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.Module;
import org.qbicc.machine.llvm.Struct;
import org.qbicc.machine.llvm.StructType;
import org.qbicc.machine.llvm.debuginfo.DIExpression;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AddrspacecastConstant;
import org.qbicc.machine.llvm.impl.ArgumentAttribute;
import org.qbicc.machine.llvm.impl.ArrayImpl;
import org.qbicc.machine.llvm.impl.ArrayType;
import org.qbicc.machine.llvm.impl.AsmExpression;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.impl.BitcastConstant;
import org.qbicc.machine.llvm.impl.BuilderImpl;
import org.qbicc.machine.llvm.impl.ByteArrayImpl;
import org.qbicc.machine.llvm.impl.DIExpressionImpl;
import org.qbicc.machine.llvm.impl.DoubleConstant;
import org.qbicc.machine.llvm.impl.FloatConstant;
import org.qbicc.machine.llvm.impl.FunctionType;
import org.qbicc.machine.llvm.impl.GetElementPtrConstant;
import org.qbicc.machine.llvm.impl.IntConstant;
import org.qbicc.machine.llvm.impl.IntToPtrConstant;
import org.qbicc.machine.llvm.impl.LongConstant;
import org.qbicc.machine.llvm.impl.MetadataString;
import org.qbicc.machine.llvm.impl.MetadataType;
import org.qbicc.machine.llvm.impl.ModuleImpl;
import org.qbicc.machine.llvm.impl.NamedGlobalValueOf;
import org.qbicc.machine.llvm.impl.NamedLocalValueOf;
import org.qbicc.machine.llvm.impl.OpaquePointer;
import org.qbicc.machine.llvm.impl.PointerTo;
import org.qbicc.machine.llvm.impl.PtrToIntConstant;
import org.qbicc.machine.llvm.impl.ShortArrayImpl;
import org.qbicc.machine.llvm.impl.SingleWord;
import org.qbicc.machine.llvm.impl.StructImpl;
import org.qbicc.machine.llvm.impl.StructTypeImpl;
import org.qbicc.machine.llvm.impl.VectorOf;

public final class LLVM {
    public static final LLValue i1 = new SingleWord("i1");
    public static final LLValue i8 = new SingleWord("i8");
    public static final LLValue i16 = new SingleWord("i16");
    public static final LLValue i24 = new SingleWord("i24");
    public static final LLValue i32 = new SingleWord("i32");
    public static final LLValue i64 = new SingleWord("i64");
    public static final LLValue i128 = new SingleWord("i128");
    public static final LLValue float16 = new SingleWord("half");
    public static final LLValue float32 = new SingleWord("float");
    public static final LLValue float64 = new SingleWord("double");
    public static final LLValue float128 = new SingleWord("fp128");
    public static final LLValue void_ = new SingleWord("void");
    public static final LLValue token = new SingleWord("token");
    public static final LLValue metadata = new MetadataType(null);
    public static final LLValue label = new SingleWord("label");
    public static final LLValue ZERO = new IntConstant(0);
    public static final LLValue ONE = new IntConstant(1);
    public static final LLValue FALSE = new SingleWord("false");
    public static final LLValue TRUE = new SingleWord("true");
    public static final LLValue NULL = new SingleWord("null");
    public static final LLValue UNDEF = new SingleWord("undef");
    public static final LLValue zeroinitializer = new SingleWord("zeroinitializer");
    public static final LLValue ptr = new OpaquePointer(0);

    private LLVM() {
    }

    public static Module newModule() {
        return new ModuleImpl();
    }

    public static LLValue ptr(int addrSpace) {
        return new OpaquePointer(addrSpace);
    }

    public static LLValue ptrTo(LLValue type, int addrSpace) {
        return new PointerTo((AbstractValue)type, addrSpace);
    }

    public static LLValue metadata(LLValue type) {
        return type == null ? metadata : new MetadataType((AbstractValue)type);
    }

    public static LLValue arrayType(int dimension, LLValue elementType) {
        return new ArrayType(dimension, (AbstractValue)elementType);
    }

    public static LLValue vector(boolean vscale, int dimension, LLValue elementType) {
        return new VectorOf(dimension, (AbstractValue)elementType, vscale);
    }

    public static LLValue intConstant(int val) {
        return new IntConstant(val);
    }

    public static LLValue intConstant(long val) {
        return new LongConstant(val);
    }

    public static LLValue floatConstant(float val) {
        return new FloatConstant(val);
    }

    public static LLValue floatConstant(double val) {
        return new DoubleConstant(val);
    }

    public static LLValue bitcastConstant(LLValue val, LLValue fromType, LLValue toType) {
        return new BitcastConstant(val, fromType, toType);
    }

    public static LLValue addrspacecastConstant(LLValue val, LLValue fromType, LLValue toType) {
        return new AddrspacecastConstant(val, fromType, toType);
    }

    public static LLValue inttoptrConstant(LLValue val, LLValue fromType, LLValue toType) {
        return new IntToPtrConstant(val, fromType, toType);
    }

    public static LLValue ptrtointConstant(LLValue val, LLValue fromType, LLValue toType) {
        return new PtrToIntConstant(val, fromType, toType);
    }

    public static DIExpression diExpression() {
        return new DIExpressionImpl();
    }

    public static Array array(LLValue elementType) {
        return new ArrayImpl(elementType);
    }

    public static LLValue array(LLValue elementType, short[] values) {
        return new ShortArrayImpl((AbstractValue)elementType, values);
    }

    public static LLValue global(String name) {
        return new NamedGlobalValueOf(name);
    }

    public static LLValue local(String name) {
        return new NamedLocalValueOf(null, name);
    }

    public static LLValue function(LLValue returnType, List<LLValue> argTypes, boolean variadic) {
        return new FunctionType(returnType, argTypes, variadic);
    }

    public static StructType structType(boolean isIdentified) {
        return new StructTypeImpl(isIdentified);
    }

    public static Struct struct() {
        return new StructImpl();
    }

    public static LLValue metadataString(String value) {
        return new MetadataString(value);
    }

    public static LLBuilder newBuilder(LLBasicBlock block) {
        return new BuilderImpl((BasicBlockImpl)block);
    }

    public static LLValue byteArray(byte[] contents) {
        return new ByteArrayImpl(contents);
    }

    public static String quoteString(String str) {
        try {
            return AbstractEmittable.appendEscapedString(new StringBuilder(), str).toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static LLValue flagAttribute(String attribute) {
        return new SingleWord(attribute);
    }

    public static LLValue valueAttribute(String attribute, String value) {
        return new SingleWord(attribute + "=" + value);
    }

    public static LLValue argumentAttribute(String attribute, LLValue value) {
        return new ArgumentAttribute(attribute, value);
    }

    public static LLValue gepConstant(LLValue type, LLValue ptrType, LLValue pointer, LLValue ... args) {
        return new GetElementPtrConstant(type, ptrType, pointer, args);
    }

    public static LLValue asm(String instruction, String constraints, Set<AsmFlag> flags) {
        return new AsmExpression(instruction, constraints, flags);
    }

    public static boolean needsQuotes(String name) {
        char c = name.charAt(0);
        if (c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '.' || c == '_') {
            for (int i = 1; i < name.length(); ++i) {
                c = name.charAt(i);
                if (c == '-' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '.' || c == '_' || '0' <= c && c <= '9') continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }
}

