/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.LandingPad;

final class LandingPadImpl
extends AbstractYieldingInstruction
implements LandingPad {
    private final AbstractValue resultType;
    boolean cleanup;
    Clause last;

    LandingPadImpl(BasicBlockImpl block, AbstractValue resultType) {
        super(block);
        this.resultType = resultType;
    }

    @Override
    public LandingPad cleanup() {
        this.cleanup = true;
        return this;
    }

    @Override
    public LandingPad catch_(LLValue type, LLValue value) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.last = new Catch(this.last, (AbstractValue)type, (AbstractValue)value);
        return this;
    }

    @Override
    public LandingPad filter(LLValue type, LLValue value) {
        Assert.checkNotNullParam((String)"type", (Object)type);
        Assert.checkNotNullParam((String)"value", (Object)value);
        this.last = new Filter(this.last, (AbstractValue)type, (AbstractValue)value);
        return this;
    }

    @Override
    public LandingPad comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public LandingPad meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        Clause last;
        super.appendTo(target);
        target.append("landingpad");
        target.append(' ');
        this.resultType.appendTo(target);
        if (this.cleanup) {
            target.append(' ');
            target.append("cleanup");
        }
        if ((last = this.last) != null) {
            last.appendTo(target);
        }
        return target;
    }

    static final class Catch
    extends Clause {
        Catch(Clause prev, AbstractValue type, AbstractValue value) {
            super(prev, type, value);
        }

        @Override
        String keyword() {
            return "catch";
        }
    }

    static abstract class Clause
    extends AbstractEmittable {
        private final Clause prev;
        private final AbstractValue type;
        private final AbstractValue value;

        Clause(Clause prev, AbstractValue type, AbstractValue value) {
            this.prev = prev;
            this.type = type;
            this.value = value;
        }

        abstract String keyword();

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            Clause prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
            }
            target.append(' ');
            target.append(this.keyword());
            target.append(' ');
            this.type.appendTo(target);
            target.append(' ');
            this.value.appendTo(target);
            return target;
        }
    }

    static final class Filter
    extends Clause {
        Filter(Clause prev, AbstractValue type, AbstractValue value) {
            super(prev, type, value);
        }

        @Override
        String keyword() {
            return "filter";
        }
    }
}

