/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.qbicc.machine.llvm.FastMathFlag;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.AbstractYieldingInstruction;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.Phi;

final class PhiImpl
extends AbstractYieldingInstruction
implements Phi {
    private final AbstractValue type;
    private Set<FastMathFlag> mathFlags = Collections.emptySet();
    private Item lastItem;

    PhiImpl(BasicBlockImpl block, AbstractValue type) {
        super(block);
        this.type = type;
    }

    @Override
    public Phi meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Phi comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Phi item(LLValue data, LLBasicBlock incoming) {
        Assert.checkNotNullParam((String)"data", (Object)data);
        Assert.checkNotNullParam((String)"incoming", (Object)incoming);
        this.lastItem = new Item(this.lastItem, (AbstractValue)data, (BasicBlockImpl)incoming);
        return this;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        Item lastItem = this.lastItem;
        if (lastItem != null) {
            target.append("phi");
            Set<FastMathFlag> mathFlags = this.mathFlags;
            for (FastMathFlag mathFlag : mathFlags) {
                target.append(' ').append(mathFlag.name());
            }
            target.append(' ');
            this.type.appendTo(target);
            target.append(' ');
            lastItem.appendTo(target);
        } else {
            target.append("select").append(' ');
            target.append("i1").append(' ').append("true").append(',').append(' ');
            this.type.appendTo(target);
            target.append(' ').append("undef").append(',').append(' ');
            this.type.appendTo(target);
            target.append(' ').append("undef");
        }
        return this.appendTrailer(target);
    }

    static final class Item
    extends AbstractEmittable {
        private final Item prev;
        private final AbstractValue data;
        private final BasicBlockImpl incoming;

        Item(Item prev, AbstractValue data, BasicBlockImpl incoming) {
            this.prev = prev;
            this.incoming = incoming;
            this.data = data;
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            Item prev = this.prev;
            if (prev != null) {
                prev.appendTo(target);
                target.append(',').append(' ');
            }
            target.append('[').append(' ');
            this.data.appendTo(target);
            target.append(',').append(' ');
            this.incoming.appendTo(target);
            return target.append(' ').append(']');
        }
    }
}

