/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import java.util.Objects;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class PointerTo
extends AbstractValue {
    private final AbstractValue type;
    private final int addrSpace;

    PointerTo(AbstractValue type, int addrSpace) {
        this.type = type;
        this.addrSpace = addrSpace;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        this.type.appendTo(target);
        if (this.addrSpace != 0) {
            target.append(' ').append("addrspace").append('(');
            target.append(Integer.toString(this.addrSpace));
            target.append(')');
        }
        return target.append('*');
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PointerTo pointerTo = (PointerTo)o;
        return this.addrSpace == pointerTo.addrSpace && this.type.equals(pointerTo.type);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.addrSpace);
    }
}

