/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class ShortArrayImpl
extends AbstractValue {
    final AbstractValue elementType;
    final short[] contents;

    ShortArrayImpl(AbstractValue elementType, short[] contents) {
        this.elementType = elementType;
        this.contents = contents;
    }

    private char digit(int val, boolean pad) {
        return (char)((val %= 10) == 0 && pad ? 32 : (char)(48 + val));
    }

    private void writeVal(Appendable target, short item) throws IOException {
        int val = Short.toUnsignedInt(item);
        char digit = this.digit(val / 10000, true);
        target.append(digit);
        digit = this.digit(val / 1000, digit == ' ');
        target.append(digit);
        digit = this.digit(val / 100, digit == ' ');
        target.append(digit);
        digit = this.digit(val / 10, digit == ' ');
        target.append(digit);
        digit = this.digit(val, false);
        target.append(digit);
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        int i;
        target.append('[');
        boolean multiLineOutput = false;
        if (this.contents.length > 8) {
            multiLineOutput = true;
            target.append('\n');
        }
        if ((i = 0) < this.contents.length) {
            target.append(' ');
            this.elementType.appendTo(target);
            target.append(' ');
            this.writeVal(target, this.contents[i]);
            ++i;
            while (i < this.contents.length) {
                target.append(',');
                if (multiLineOutput && (i & 7) == 0) {
                    target.append(" ; ").append(String.valueOf(i - 8)).append(" \n");
                }
                target.append(' ');
                this.elementType.appendTo(target);
                target.append(' ');
                this.writeVal(target, this.contents[i]);
                ++i;
            }
        }
        if (multiLineOutput) {
            target.append(" ; ").append(String.valueOf(i - 8)).append(" \n");
        }
        target.append(' ');
        target.append(']');
        return target;
    }
}

