/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import io.smallrye.common.constraint.Assert;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.StructType;
import org.qbicc.machine.llvm.impl.AbstractValue;

final class StructTypeImpl
extends AbstractValue
implements StructType {
    final ArrayList<AbstractValue> members = new ArrayList();
    final ArrayList<String> memberNames = new ArrayList();
    final boolean isIdentified;

    StructTypeImpl(boolean isIdentified) {
        this.isIdentified = isIdentified;
    }

    @Override
    public StructType member(LLValue type, String name) {
        this.members.add((AbstractValue)Assert.checkNotNullParam((String)"type", (Object)type));
        this.memberNames.add(name);
        return this;
    }

    public boolean literalPaddingMember(String name) {
        return !this.isIdentified && name.equals("padding");
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        Iterator<AbstractValue> iterator = this.members.iterator();
        Iterator<String> nameIterator = this.memberNames.iterator();
        target.append('{');
        if (iterator.hasNext()) {
            String name = nameIterator.next();
            AbstractValue value = iterator.next();
            if (!this.literalPaddingMember(name)) {
                target.append(' ');
                value.appendTo(target);
                if (this.isIdentified) {
                    target.append(" ; " + name);
                }
            }
            while (iterator.hasNext()) {
                name = nameIterator.next();
                value = iterator.next();
                if (this.literalPaddingMember(name)) continue;
                if (this.isIdentified) {
                    target.append('\n').append('\t');
                }
                target.append(',');
                target.append(' ');
                value.appendTo(target);
                if (!this.isIdentified) continue;
                target.append(" ; " + name);
            }
        }
        if (this.isIdentified) {
            target.append('\n').append('\t');
        }
        target.append(' ');
        target.append('}');
        return target;
    }
}

