/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.impl;

import java.io.IOException;
import org.qbicc.machine.llvm.LLBasicBlock;
import org.qbicc.machine.llvm.LLValue;
import org.qbicc.machine.llvm.impl.AbstractEmittable;
import org.qbicc.machine.llvm.impl.AbstractInstruction;
import org.qbicc.machine.llvm.impl.AbstractValue;
import org.qbicc.machine.llvm.impl.BasicBlockImpl;
import org.qbicc.machine.llvm.op.Switch;

final class SwitchImpl
extends AbstractInstruction
implements Switch {
    private final AbstractValue type;
    private final AbstractValue value;
    private final BasicBlockImpl defaultTarget;
    private CaseImpl lastCase;

    SwitchImpl(AbstractValue type, AbstractValue value, BasicBlockImpl defaultTarget) {
        this.type = type;
        this.value = value;
        this.defaultTarget = defaultTarget;
    }

    @Override
    public Switch meta(String name, LLValue data) {
        super.meta(name, data);
        return this;
    }

    @Override
    public Switch comment(String comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public Switch.Case case_(LLValue value, LLBasicBlock target) {
        this.lastCase = new CaseImpl(this, this.lastCase, (AbstractValue)value, (BasicBlockImpl)target);
        return this.lastCase;
    }

    @Override
    public Appendable appendTo(Appendable target) throws IOException {
        super.appendTo(target);
        target.append("switch ");
        SwitchImpl.appendValue(target, this.type);
        target.append(' ');
        this.value.appendTo(target);
        target.append(", label ");
        this.defaultTarget.appendTo(target);
        target.append(" [\n");
        if (this.lastCase != null) {
            this.lastCase.appendTo(target);
        }
        target.append("  ]");
        return this.appendTrailer(target);
    }

    static final class CaseImpl
    extends AbstractEmittable
    implements Switch.Case {
        final SwitchImpl switch_;
        final CaseImpl prev;
        final AbstractValue value;
        final BasicBlockImpl target;

        CaseImpl(SwitchImpl switch_, CaseImpl prev, AbstractValue value, BasicBlockImpl target) {
            this.switch_ = switch_;
            this.prev = prev;
            this.value = value;
            this.target = target;
        }

        @Override
        public Switch.Case case_(LLValue value, LLBasicBlock target) {
            return this.switch_.case_(value, target);
        }

        @Override
        public Appendable appendTo(Appendable target) throws IOException {
            if (this.prev != null) {
                this.prev.appendTo(target);
            }
            target.append("    ");
            CaseImpl.appendValue(target, this.switch_.type);
            target.append(' ');
            this.value.appendTo(target);
            target.append(", label ");
            this.target.appendTo(target);
            target.append('\n');
            return target;
        }
    }
}

