/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.llvm.stackmap;

import java.nio.ByteBuffer;
import org.qbicc.machine.llvm.stackmap.LocationType;
import org.qbicc.machine.llvm.stackmap.StackMapVisitor;

public final class StackMap {
    private StackMap() {
    }

    public static void parse(ByteBuffer stackMapBuffer, StackMapVisitor visitor) {
        ByteBuffer buf = stackMapBuffer.duplicate().order(stackMapBuffer.order());
        int version = buf.get() & 0xFF;
        if (version == 3) {
            buf.get();
            buf.getShort();
            long fnCnt = (long)buf.getInt() & 0xFFFFFFFFL;
            long constCnt = (long)buf.getInt() & 0xFFFFFFFFL;
            long recCnt = (long)buf.getInt() & 0xFFFFFFFFL;
            ByteBuffer stackSizesBuf = buf.duplicate().order(buf.order());
            buf.position((int)((long)buf.position() + 24L * fnCnt));
            int constEnd = (int)((long)buf.position() + constCnt * 8L);
            ByteBuffer constBuf = buf.duplicate().limit(constEnd).slice().order(buf.order());
            buf.position(constEnd);
            visitor.start(version, fnCnt, recCnt);
            for (long i = 0L; i < fnCnt; ++i) {
                long addr = stackSizesBuf.getLong();
                long stackSize = stackSizesBuf.getLong();
                long fnRecCnt = stackSizesBuf.getLong();
                visitor.startFunction(i, addr, stackSize, fnRecCnt);
                for (long j = 0L; j < fnRecCnt; ++j) {
                    long ppId = buf.getLong();
                    long offs = (long)buf.getInt() & 0xFFFFFFFFL;
                    buf.getShort();
                    int locCnt = buf.getShort() & 0xFFFF;
                    int jump = buf.position() + locCnt * 12;
                    if ((jump & 7) != 0) {
                        jump += 4;
                    }
                    int liveOutCnt = buf.getShort(jump += 2) & 0xFFFF;
                    visitor.startRecord(j, ppId, offs, locCnt, liveOutCnt);
                    for (int k = 0; k < locCnt; ++k) {
                        int encType = buf.get() & 0xFF;
                        LocationType type = LocationType.forEncoding(encType);
                        buf.get();
                        int locSize = buf.getShort() & 0xFFFF;
                        int regNum = buf.getShort() & 0xFFFF;
                        buf.getShort();
                        long data = encType == 5 ? constBuf.getLong(buf.getInt() * 8) : (long)buf.getInt();
                        visitor.location(k, type, locSize, regNum, data);
                    }
                    if ((buf.position() & 7) != 0) {
                        buf.getInt();
                    }
                    buf.getShort();
                    int liveOutCnt2 = buf.getShort() & 0xFFFF;
                    assert (liveOutCnt2 == liveOutCnt);
                    for (int k = 0; k < liveOutCnt; ++k) {
                        int regNum = buf.getShort() & 0xFFFF;
                        buf.get();
                        int size = buf.get() & 0xFF;
                        visitor.liveOut(k, regNum, size);
                    }
                    if ((buf.position() & 7) != 0) {
                        buf.getInt();
                    }
                    visitor.endRecord(j);
                }
                visitor.endFunction(i);
            }
        } else {
            throw new IllegalArgumentException("Unrecognized stack map version " + version);
        }
        visitor.end();
    }
}

