/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool;

import org.qbicc.context.CompilationContext;
import org.qbicc.context.Location;
import org.qbicc.machine.tool.ToolInvoker;

public interface ToolMessageHandler {
    public static final ToolMessageHandler DISCARDING = new ToolMessageHandler(){

        @Override
        public void handleMessage(ToolInvoker invoker, Level level, String file, int line, int column, String message) {
        }
    };

    public static ToolMessageHandler reporting(final CompilationContext context) {
        return new ToolMessageHandler(){

            @Override
            public void handleMessage(ToolInvoker invoker, Level level, String file, int line, int column, String message) {
                switch (level) {
                    case ERROR: {
                        context.error(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getPath(), message});
                        return;
                    }
                    case WARNING: {
                        context.warning(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getPath(), message});
                        return;
                    }
                    case INFO: {
                        context.note(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getPath(), message});
                        return;
                    }
                }
                context.debug(Location.builder().setSourceFilePath(file).setLineNumber(line).build(), "%s: %s", new Object[]{invoker.getPath(), message});
            }
        };
    }

    public void handleMessage(ToolInvoker var1, Level var2, String var3, int var4, int var5, String var6);

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        DEBUG;


        public Level max(Level other) {
            return other.ordinal() >= this.ordinal() ? this : other;
        }

        public Level min(Level other) {
            return other.ordinal() <= this.ordinal() ? this : other;
        }
    }
}

