/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionFunction;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.AppendableWriter;
import org.qbicc.machine.tool.process.EmptyInputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class AppendableSupplierOutputDestination<T>
extends OutputDestination {
    private final ExceptionFunction<T, Appendable, IOException> supplier;
    private final T param;
    private final Charset charset;

    AppendableSupplierOutputDestination(ExceptionFunction<T, Appendable, IOException> supplier, T param, Charset charset) {
        this.supplier = supplier;
        this.param = param;
        this.charset = charset;
    }

    @Override
    void transferFrom(InputStream is) throws IOException {
        try (InputStreamReader r = new InputStreamReader(is, this.charset);){
            this.transferFrom(r, this.charset);
        }
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        Appendable destination = this.openAppendable();
        if (destination instanceof Closeable) {
            try (Closeable closeable = (Closeable)((Object)destination);){
                if (destination instanceof Writer) {
                    reader.transferTo((Writer)destination);
                }
                reader.transferTo(new AppendableWriter(destination));
            }
        } else {
            reader.transferTo(new AppendableWriter(destination));
        }
    }

    Appendable openAppendable() throws IOException {
        return (Appendable)this.supplier.apply(this.param);
    }

    @Override
    void transferFrom(EmptyInputSource source) {
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }
}

