/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class EmptyInputSource
extends InputSource {
    static final EmptyInputSource INSTANCE = new EmptyInputSource();

    private EmptyInputSource() {
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        destination.transferFrom(this);
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    Closeable provideProcessInput(Process process, ProcessBuilder.Redirect inputRedirect) {
        return process.getOutputStream();
    }

    @Override
    InputStream openStream() {
        return InputStream.nullInputStream();
    }

    @Override
    void transferTo(OutputStream os) {
    }

    @Override
    void writeTo(Path path) throws IOException {
        Files.copy(InputStream.nullInputStream(), path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public String toString() {
        return "<empty>";
    }
}

