/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionConsumer;
import io.smallrye.common.function.ExceptionFunction;
import io.smallrye.common.function.ExceptionSupplier;
import io.smallrye.common.function.Functions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.qbicc.machine.tool.process.CharSequenceInputSource;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.EmptyInputSource;
import org.qbicc.machine.tool.process.InputStreamSupplierInputSource;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.machine.tool.process.OutputStreamConsumerInputSource;
import org.qbicc.machine.tool.process.PathInputSource;
import org.qbicc.machine.tool.process.ReaderSupplierInputSource;
import org.qbicc.machine.tool.process.WriterConsumerInputSource;

public abstract class InputSource {
    InputSource() {
    }

    public static InputSource empty() {
        return EmptyInputSource.INSTANCE;
    }

    public static InputSource from(CharSequence string, Charset charset) {
        Assert.checkNotNullParam((String)"string", (Object)string);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return new CharSequenceInputSource(string, charset);
    }

    public static InputSource from(CharSequence string) {
        return InputSource.from(string, StandardCharsets.UTF_8);
    }

    public static <T> InputSource from(ExceptionFunction<T, Reader, IOException> supplier, T param, Charset charset) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return new ReaderSupplierInputSource<T>(supplier, param, charset);
    }

    public static InputSource from(ExceptionSupplier<Reader, IOException> supplier, Charset charset) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return InputSource.from(Functions.exceptionSupplierFunction(), supplier, charset);
    }

    public static <T> InputSource from(ExceptionBiConsumer<T, Writer, IOException> consumer, T param, Charset charset) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        Assert.checkNotNullParam((String)"charset", (Object)charset);
        return new WriterConsumerInputSource<T>(consumer, param, charset);
    }

    public static InputSource from(ExceptionConsumer<Writer, IOException> consumer, Charset charset) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        return InputSource.from(Functions.exceptionConsumerBiConsumer(), consumer, charset);
    }

    public static InputSource from(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        return new PathInputSource(path);
    }

    public static InputSource from(File file) {
        Assert.checkNotNullParam((String)"file", (Object)file);
        return InputSource.from(file.toPath());
    }

    public static <T> InputSource from(ExceptionFunction<T, InputStream, IOException> supplier, T param) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return new InputStreamSupplierInputSource<T>(supplier, param);
    }

    public static InputSource from(ExceptionSupplier<InputStream, IOException> supplier) {
        Assert.checkNotNullParam((String)"supplier", supplier);
        return InputSource.from(Functions.exceptionSupplierFunction(), supplier);
    }

    public static <T> InputSource from(ExceptionBiConsumer<T, OutputStream, IOException> consumer, T param) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        return new OutputStreamConsumerInputSource<T>(consumer, param);
    }

    public static InputSource from(ExceptionConsumer<OutputStream, IOException> consumer) {
        Assert.checkNotNullParam((String)"consumer", consumer);
        return InputSource.from(Functions.exceptionConsumerBiConsumer(), consumer);
    }

    public abstract void transferTo(OutputDestination var1) throws IOException;

    abstract ProcessBuilder.Redirect getInputRedirect();

    Closeable provideProcessInput(Process process, ProcessBuilder.Redirect inputRedirect) throws IOException {
        try (OutputStream os = process.getOutputStream();){
            this.transferTo(os);
        }
        return Closeables.BLANK_CLOSEABLE;
    }

    void transferTo(OutputStream os) throws IOException {
        try (InputStream is = this.openStream();){
            is.transferTo(os);
        }
    }

    abstract InputStream openStream() throws IOException;

    void writeTo(Path path) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.transferTo(os);
        }
    }

    static String nameOf(Process p) {
        try {
            return p.info().command().orElse("<unknown process>");
        }
        catch (RuntimeException ignored) {
            return "<unknown process>";
        }
    }

    public abstract String toString();
}

