/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionFunction;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

final class InputStreamSupplierInputSource<T>
extends InputSource {
    private final ExceptionFunction<T, InputStream, IOException> function;
    private final T param;

    InputStreamSupplierInputSource(ExceptionFunction<T, InputStream, IOException> function, T param) {
        this.function = function;
        this.param = param;
    }

    @Override
    public void transferTo(OutputDestination destination) throws IOException {
        destination.transferFrom(this);
    }

    @Override
    ProcessBuilder.Redirect getInputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }

    @Override
    void writeTo(Path path) throws IOException {
        try (InputStream is = this.openStream();){
            Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public String toString() {
        return "<stream>";
    }

    ExceptionFunction<T, InputStream, IOException> getFunction() {
        return this.function;
    }

    T getParam() {
        return this.param;
    }

    @Override
    InputStream openStream() throws IOException {
        return (InputStream)this.function.apply(this.param);
    }
}

