/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.process;

import io.smallrye.common.function.ExceptionBiConsumer;
import io.smallrye.common.function.ExceptionRunnable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import org.qbicc.machine.tool.process.Closeables;
import org.qbicc.machine.tool.process.OutputDestination;
import org.qbicc.machine.tool.process.OutputStreamConsumerInputSource;
import org.qbicc.machine.tool.process.WriterConsumerInputSource;

final class ReaderConsumerOutputDestination<T>
extends OutputDestination {
    private final ExceptionBiConsumer<T, Reader, IOException> consumer;
    private final T param;
    private final Charset charset;

    ReaderConsumerOutputDestination(ExceptionBiConsumer<T, Reader, IOException> consumer, T param, Charset charset) {
        this.consumer = consumer;
        this.param = param;
        this.charset = charset;
    }

    @Override
    void transferFrom(InputStream stream) throws IOException {
        try (InputStreamReader isr = new InputStreamReader(stream, this.charset);){
            this.transferFrom(isr, this.charset);
        }
    }

    @Override
    void transferFrom(Reader reader, Charset charset) throws IOException {
        this.consumer.accept(this.param, (Object)reader);
    }

    @Override
    void transferFrom(OutputStreamConsumerInputSource<?> source) throws IOException {
        try (PipedInputStream inputStream = new PipedInputStream();
             PipedOutputStream outputStream = new PipedOutputStream(inputStream);
             Closeable thr1 = Closeables.start("Transfer thread", (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> this.transferFrom(inputStream)));){
            source.transferTo(outputStream);
        }
    }

    @Override
    void transferFrom(WriterConsumerInputSource<?> source) throws IOException {
        try (PipedReader reader = new PipedReader();
             PipedWriter writer = new PipedWriter(reader);
             Closeable thr1 = Closeables.start("Transfer thread", (ExceptionRunnable<IOException>)((ExceptionRunnable)() -> this.transferFrom(reader, this.charset)));){
            source.transferTo(writer, this.charset);
        }
    }

    @Override
    ProcessBuilder.Redirect getOutputRedirect() {
        return ProcessBuilder.Redirect.PIPE;
    }
}

