/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.emscripten;

import io.smallrye.common.constraint.Assert;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.qbicc.machine.tool.emscripten.AbstractEmscriptenInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenLinkerInvoker;
import org.qbicc.machine.tool.emscripten.EmscriptenToolChainImpl;

final class EmscriptenLinkerInvokerImpl
extends AbstractEmscriptenInvoker
implements EmscriptenLinkerInvoker {
    private final List<Path> libraryPaths = new ArrayList<Path>(4);
    private final List<String> libraries = new ArrayList<String>(4);
    private final List<Path> objectFiles = new ArrayList<Path>(4);
    private Path outputPath = TMP.resolve("qbicc-output-image");
    private Path workingDirectory;
    private boolean isPie = false;

    EmscriptenLinkerInvokerImpl(EmscriptenToolChainImpl tool) {
        super(tool);
    }

    public void addLibraryPath(Path path) {
        this.libraryPaths.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getLibraryPathCount() {
        return this.libraryPaths.size();
    }

    public Path getLibraryPath(int index) throws IndexOutOfBoundsException {
        return this.libraryPaths.get(index);
    }

    public void addLibrary(String name) {
        this.libraries.add((String)Assert.checkNotNullParam((String)"name", (Object)name));
    }

    public int getLibraryCount() {
        return this.libraries.size();
    }

    public String getLibrary(int index) throws IndexOutOfBoundsException {
        return this.libraries.get(index);
    }

    public void addObjectFile(Path path) {
        this.objectFiles.add((Path)Assert.checkNotNullParam((String)"path", (Object)path));
    }

    public int getObjectFileCount() {
        return this.objectFiles.size();
    }

    public Path getObjectFile(int index) throws IndexOutOfBoundsException {
        return this.objectFiles.get(index);
    }

    public void setOutputPath(Path path) {
        this.outputPath = (Path)Assert.checkNotNullParam((String)"path", (Object)path);
    }

    public Path getOutputPath() {
        return this.outputPath;
    }

    public void setIsPie(boolean isPie) {
        this.isPie = isPie;
    }

    public boolean getIsPie() {
        return this.isPie;
    }

    @Override
    void addArguments(List<String> cmd) {
        if (this.isPie) {
            cmd.add("-pie");
        } else {
            cmd.add("-no-pie");
        }
        for (Path libraryPath : this.libraryPaths) {
            cmd.add("-L" + libraryPath.toString());
        }
        for (String library : this.libraries) {
            cmd.add("-l" + library);
        }
        for (Path objectFile : this.objectFiles) {
            cmd.add(objectFile.toString());
        }
        this.enableExceptions(cmd);
        this.appendLinkingOptions(cmd);
        Collections.addAll(cmd, "-g", "-fbulk-memory", "-o", this.outputPath.toString());
    }

    private void enableExceptions(List<String> cmd) {
        Collections.addAll(cmd, "-fexceptions");
    }

    private void appendLinkingOptions(List<String> cmd) {
        Collections.addAll(cmd, "-sALLOW_MEMORY_GROWTH=1", "-sEXIT_RUNTIME=1", "-sERROR_ON_UNDEFINED_SYMBOLS=0", "-sLLD_REPORT_UNDEFINED");
    }
}

