/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.gnu;

import io.smallrye.common.constraint.Assert;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qbicc.machine.tool.CompilationFailureException;
import org.qbicc.machine.tool.MessagingToolInvoker;
import org.qbicc.machine.tool.ToolInvoker;
import org.qbicc.machine.tool.ToolMessageHandler;
import org.qbicc.machine.tool.gnu.GccToolChainImpl;
import org.qbicc.machine.tool.process.InputSource;
import org.qbicc.machine.tool.process.OutputDestination;

abstract class AbstractGccInvoker
implements MessagingToolInvoker {
    static final Path TMP = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private final GccToolChainImpl tool;
    private ToolMessageHandler messageHandler = ToolMessageHandler.DISCARDING;
    private Path workingDirectory;
    static final Pattern DIAG_PATTERN = Pattern.compile("([^:]+):(?:(\\d+):(?:(\\d+):)?)? (?:((?:fatal )?error|warning|note): )?(.*)(?: \\[-[^]]+])?");

    AbstractGccInvoker(GccToolChainImpl tool) {
        this.tool = tool;
    }

    public void setMessageHandler(ToolMessageHandler messageHandler) {
        this.messageHandler = (ToolMessageHandler)Assert.checkNotNullParam((String)"messageHandler", (Object)messageHandler);
    }

    public ToolMessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public GccToolChainImpl getTool() {
        return this.tool;
    }

    public Path getPath() {
        return this.tool.getExecutablePath();
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(Path workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    void collectError(Reader reader) throws IOException {
        ToolMessageHandler handler = this.getMessageHandler();
        try (BufferedReader br = new BufferedReader(reader);){
            String line;
            StringBuilder b = new StringBuilder();
            ToolMessageHandler.Level level = null;
            String file = "";
            while ((line = br.readLine()) != null) {
                Matcher matcher = DIAG_PATTERN.matcher(line.trim());
                if (matcher.matches()) {
                    String levelStr;
                    if (b.length() > 0) {
                        handler.handleMessage((ToolInvoker)this, level, file, -1, -1, b.toString());
                        b.setLength(0);
                    }
                    if ((levelStr = matcher.group(4)) != null) {
                        switch (levelStr) {
                            case "note": {
                                level = ToolMessageHandler.Level.INFO;
                                break;
                            }
                            case "warning": {
                                level = ToolMessageHandler.Level.WARNING;
                                break;
                            }
                            default: {
                                level = ToolMessageHandler.Level.ERROR;
                                break;
                            }
                        }
                    } else {
                        level = ToolMessageHandler.Level.ERROR;
                    }
                    file = matcher.group(1);
                    b.append(matcher.group(5));
                    continue;
                }
                b.append('\n').append(line);
            }
            if (b.length() > 0) {
                handler.handleMessage((ToolInvoker)this, level, file, -1, -1, b.toString());
            }
        }
    }

    void addArguments(List<String> cmd) {
    }

    InputSource getSource() {
        return InputSource.empty();
    }

    public void invoke() throws IOException {
        OutputDestination errorHandler = OutputDestination.of(AbstractGccInvoker::collectError, (Object)this, (Charset)StandardCharsets.UTF_8);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.getTool().getExecutablePath().toString());
        cmd.add("-pthread");
        this.addArguments(cmd);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.command(cmd);
        if (this.getWorkingDirectory() != null) {
            pb.directory(this.getWorkingDirectory().toFile());
        }
        pb.environment().put("LC_ALL", "C");
        pb.environment().put("LANG", "C");
        this.getSource().transferTo(OutputDestination.of((ProcessBuilder)pb, (OutputDestination)errorHandler, (OutputDestination)OutputDestination.discarding(), p -> {
            int ev = p.exitValue();
            if (ev != 0) {
                throw new CompilationFailureException("Compiler terminated with exit code " + ev);
            }
        }));
    }
}

