/*
 * Decompiled with CFR 0.152.
 */
package org.qbicc.machine.tool.gnu;

import io.smallrye.common.version.VersionScheme;
import java.nio.file.Path;
import org.qbicc.machine.arch.Platform;
import org.qbicc.machine.tool.gnu.GccToolChain;
import org.qbicc.machine.tool.gnu.GnuCCompilerInvoker;
import org.qbicc.machine.tool.gnu.GnuCCompilerInvokerImpl;
import org.qbicc.machine.tool.gnu.GnuLinkerInvoker;
import org.qbicc.machine.tool.gnu.GnuLinkerInvokerImpl;

final class GccToolChainImpl
implements GccToolChain {
    private final Path executablePath;
    private final Platform platform;
    private final String version;
    private final boolean m32;

    GccToolChainImpl(Path executablePath, Platform platform, String version, boolean m32) {
        this.executablePath = executablePath;
        this.platform = platform;
        this.version = version;
        this.m32 = m32;
    }

    public Path getExecutablePath() {
        return this.executablePath;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public GnuCCompilerInvoker newCompilerInvoker() {
        return new GnuCCompilerInvokerImpl(this);
    }

    @Override
    public GnuLinkerInvoker newLinkerInvoker() {
        return new GnuLinkerInvokerImpl(this);
    }

    public String getVersion() {
        return this.version;
    }

    public int compareVersionTo(String version) {
        return VersionScheme.BASIC.compare(this.version, version);
    }

    boolean isM32() {
        return this.m32;
    }
}

